/*
 * Decompiled with CFR 0.152.
 */
package dev.frankheijden.insights.commands;

import dev.frankheijden.insights.api.InsightsPlugin;
import dev.frankheijden.insights.api.addons.Region;
import dev.frankheijden.insights.api.commands.InsightsCommand;
import dev.frankheijden.insights.api.concurrent.storage.Storage;
import dev.frankheijden.insights.api.config.Messages;
import dev.frankheijden.insights.api.config.limits.Limit;
import dev.frankheijden.insights.api.objects.wrappers.ScanObject;
import dev.frankheijden.insights.api.reflection.RTileEntityTypes;
import dev.frankheijden.insights.api.utils.ChunkUtils;
import dev.frankheijden.insights.api.utils.Constants;
import dev.frankheijden.insights.api.utils.EnumUtils;
import dev.frankheijden.insights.core.dependencies.cloud.annotations.Argument;
import dev.frankheijden.insights.core.dependencies.cloud.annotations.Command;
import dev.frankheijden.insights.core.dependencies.cloud.annotations.Permission;
import dev.frankheijden.insights.dependencies.adventure.text.Component;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@Command(value="scancache")
public class CommandScanCache
extends InsightsCommand {
    public CommandScanCache(InsightsPlugin plugin) {
        super(plugin);
    }

    @Command(value="tile")
    @Permission(value={"insights.scancache.tile"})
    private void handleTileScan(Player player) {
        this.handleScan(player, RTileEntityTypes.getTileEntities(), false);
    }

    @Command(value="entity")
    @Permission(value={"insights.scancache.entity"})
    private void handleEntityScan(Player player) {
        this.handleScan(player, Constants.SCAN_ENTITIES, false);
    }

    @Command(value="all")
    @Permission(value={"insights.scancache.all"})
    private void handleAllScan(Player player) {
        this.handleScan(player, null, false);
    }

    @Command(value="custom <items>")
    @Permission(value={"insights.scancache.custom"})
    private void handleCustomScan(Player player, @Argument(value="items") ScanObject<?>[] items) {
        this.handleScan(player, new HashSet(Arrays.asList(items)), true);
    }

    @Command(value="limit <limit>")
    @Permission(value={"insights.scancache.limit"})
    private void handleLimitScan(Player player, @Argument(value="limit") Limit limit) {
        this.handleScan(player, limit.getScanObjects(), false);
    }

    @Command(value="clear")
    @Permission(value={"insights.scancache.clear"})
    private void handleCacheClear(Player player) {
        Location loc = player.getLocation();
        Optional<Region> optionalRegion = this.plugin.getAddonManager().getRegion(loc);
        if (optionalRegion.isPresent()) {
            this.plugin.getAddonStorage().remove(optionalRegion.get().getKey());
        } else {
            this.plugin.getWorldStorage().getWorld(loc.getWorld().getUID()).remove(ChunkUtils.getKey(loc.getChunk()));
        }
        String areaName = optionalRegion.map(r -> this.plugin.getAddonManager().getAddon(r.getAddon()).getAreaName()).orElse("chunk");
        this.plugin.getMessages().getMessage(Messages.Key.SCANCACHE_CLEARED).addTemplates(Messages.tagOf("area", areaName)).sendTo((CommandSender)player);
    }

    public void handleScan(Player player, Set<? extends ScanObject<?>> items, boolean displayZeros) {
        Location loc = player.getLocation();
        Optional<Region> optionalRegion = this.plugin.getAddonManager().getRegion(loc);
        Optional<Storage> optionalStorage = optionalRegion.isPresent() ? this.plugin.getAddonStorage().get(optionalRegion.get().getKey()) : this.plugin.getWorldStorage().getWorld(loc.getWorld().getUID()).get(ChunkUtils.getKey(loc.getChunk()));
        if (optionalStorage.isPresent()) {
            Storage storage = optionalStorage.get();
            Messages messages = this.plugin.getMessages();
            ScanObject[] displayItems = (ScanObject[])(items == null ? storage.keys() : items).stream().filter(item -> storage.count((ScanObject<?>)item) != 0L || displayZeros).sorted(Comparator.comparing(ScanObject::name)).toArray(ScanObject[]::new);
            Messages.Message footer = messages.getMessage(Messages.Key.SCANCACHE_RESULT_FOOTER).addTemplates(Messages.tagOf("area", optionalRegion.map(r -> this.plugin.getAddonManager().getAddon(r.getAddon()).getAreaName()).orElse("chunk")));
            Messages.PaginatedMessage<ScanObject> message = messages.createPaginatedMessage(messages.getMessage(Messages.Key.SCANCACHE_RESULT_HEADER), Messages.Key.SCANCACHE_RESULT_FORMAT, footer, displayItems, storage::count, item -> Component.text(EnumUtils.pretty(item.getObject())));
            this.plugin.getScanHistory().setHistory(player.getUniqueId(), message);
            message.sendTo((CommandSender)player, 0);
        } else {
            this.plugin.getMessages().getMessage(Messages.Key.SCANCACHE_NO_CACHE).sendTo((CommandSender)player);
        }
    }
}

