/*
 * Decompiled with CFR 0.152.
 */
package dev.frankheijden.insights.commands;

import dev.frankheijden.insights.api.InsightsPlugin;
import dev.frankheijden.insights.api.addons.Region;
import dev.frankheijden.insights.api.commands.InsightsCommand;
import dev.frankheijden.insights.api.concurrent.ScanOptions;
import dev.frankheijden.insights.api.config.Messages;
import dev.frankheijden.insights.api.config.limits.Limit;
import dev.frankheijden.insights.api.objects.chunk.ChunkPart;
import dev.frankheijden.insights.api.objects.wrappers.ScanObject;
import dev.frankheijden.insights.api.reflection.RTileEntityTypes;
import dev.frankheijden.insights.api.tasks.ScanTask;
import dev.frankheijden.insights.api.utils.Constants;
import dev.frankheijden.insights.core.dependencies.cloud.annotations.Argument;
import dev.frankheijden.insights.core.dependencies.cloud.annotations.Command;
import dev.frankheijden.insights.core.dependencies.cloud.annotations.Flag;
import dev.frankheijden.insights.core.dependencies.cloud.annotations.Permission;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@Command(value="scanregion")
public class CommandScanRegion
extends InsightsCommand {
    public CommandScanRegion(InsightsPlugin plugin) {
        super(plugin);
    }

    @Command(value="tile")
    @Permission(value={"insights.scanregion.tile"})
    private void handleTileScan(Player player, @Flag(value="group-by-chunk", aliases={"c"}) boolean groupByChunk) {
        this.handleScan(player, RTileEntityTypes.getTileEntities(), ScanOptions.materialsOnly(), false, groupByChunk);
    }

    @Command(value="entity")
    @Permission(value={"insights.scanregion.entity"})
    private void handleEntityScan(Player player, @Flag(value="group-by-chunk", aliases={"c"}) boolean groupByChunk) {
        this.handleScan(player, Constants.SCAN_ENTITIES, ScanOptions.entitiesOnly(), false, groupByChunk);
    }

    @Command(value="all")
    @Permission(value={"insights.scanregion.all"})
    private void handleAllScan(Player player, @Flag(value="group-by-chunk", aliases={"c"}) boolean groupByChunk) {
        this.handleScan(player, null, ScanOptions.scanOnly(), false, groupByChunk);
    }

    @Command(value="custom <items>")
    @Permission(value={"insights.scanregion.custom"})
    private void handleCustomScan(Player player, @Flag(value="group-by-chunk", aliases={"c"}) boolean groupByChunk, @Argument(value="items") ScanObject<?>[] items) {
        this.handleScan(player, new HashSet(Arrays.asList(items)), ScanOptions.scanOnly(), true, groupByChunk);
    }

    @Command(value="limit <limit>")
    @Permission(value={"insights.scanregion.limit"})
    private void handleLimitScan(Player player, @Flag(value="group-by-chunk", aliases={"c"}) boolean groupByChunk, @Argument(value="limit") Limit limit) {
        this.handleScan(player, limit.getScanObjects(), limit.getScanOptions(), false, groupByChunk);
    }

    public void handleScan(Player player, Set<? extends ScanObject<?>> items, ScanOptions options, boolean displayZeros, boolean groupByChunk) {
        Optional<Region> optionalRegion = this.plugin.getAddonManager().getRegion(player.getLocation());
        if (optionalRegion.isEmpty()) {
            this.plugin.getMessages().getMessage(Messages.Key.SCANREGION_NO_REGION).sendTo((CommandSender)player);
            return;
        }
        List<ChunkPart> parts = optionalRegion.get().toChunkParts();
        if (groupByChunk) {
            ScanTask.scanAndDisplayGroupedByChunk(this.plugin, player, parts, parts.size(), options, items, false);
        } else {
            ScanTask.scanAndDisplay(this.plugin, player, parts, parts.size(), options, items, displayZeros);
        }
    }
}

