/*
 * Decompiled with CFR 0.152.
 */
package dev.frankheijden.insights.commands;

import dev.frankheijden.insights.api.InsightsPlugin;
import dev.frankheijden.insights.api.commands.InsightsCommand;
import dev.frankheijden.insights.api.concurrent.ScanOptions;
import dev.frankheijden.insights.api.config.limits.Limit;
import dev.frankheijden.insights.api.objects.chunk.ChunkLocation;
import dev.frankheijden.insights.api.objects.chunk.ChunkPart;
import dev.frankheijden.insights.api.objects.wrappers.ScanObject;
import dev.frankheijden.insights.api.reflection.RTileEntityTypes;
import dev.frankheijden.insights.api.tasks.ScanTask;
import dev.frankheijden.insights.api.utils.Constants;
import dev.frankheijden.insights.core.dependencies.cloud.annotations.Argument;
import dev.frankheijden.insights.core.dependencies.cloud.annotations.Command;
import dev.frankheijden.insights.core.dependencies.cloud.annotations.Flag;
import dev.frankheijden.insights.core.dependencies.cloud.annotations.Permission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.entity.Player;

@Command(value="scanworld")
public class CommandScanWorld
extends InsightsCommand {
    public CommandScanWorld(InsightsPlugin plugin) {
        super(plugin);
    }

    @Command(value="tile")
    @Permission(value={"insights.scanworld.tile"})
    private void handleTileScan(Player player, @Flag(value="group-by-chunk", aliases={"c"}) boolean groupByChunk) {
        this.handleScan(player, RTileEntityTypes.getTileEntities(), ScanOptions.materialsOnly(), false, groupByChunk);
    }

    @Command(value="entity")
    @Permission(value={"insights.scanworld.entity"})
    private void handleEntityScan(Player player, @Flag(value="group-by-chunk", aliases={"c"}) boolean groupByChunk) {
        this.handleScan(player, Constants.SCAN_ENTITIES, ScanOptions.entitiesOnly(), false, groupByChunk);
    }

    @Command(value="all")
    @Permission(value={"insights.scanworld.all"})
    private void handleAllScan(Player player, @Flag(value="group-by-chunk", aliases={"c"}) boolean groupByChunk) {
        this.handleScan(player, null, ScanOptions.scanOnly(), false, groupByChunk);
    }

    @Command(value="custom <items>")
    @Permission(value={"insights.scanworld.custom"})
    private void handleCustomScan(Player player, @Flag(value="group-by-chunk", aliases={"c"}) boolean groupByChunk, @Argument(value="items") ScanObject<?>[] items) {
        this.handleScan(player, new HashSet(Arrays.asList(items)), ScanOptions.scanOnly(), true, groupByChunk);
    }

    @Command(value="limit <limit>")
    @Permission(value={"insights.scanworld.limit"})
    private void handleLimitScan(Player player, @Flag(value="group-by-chunk", aliases={"c"}) boolean groupByChunk, @Argument(value="limit") Limit limit) {
        this.handleScan(player, limit.getScanObjects(), limit.getScanOptions(), false, groupByChunk);
    }

    public void handleScan(Player player, Set<? extends ScanObject<?>> items, ScanOptions options, boolean displayZeros, boolean groupByChunk) {
        World world = player.getWorld();
        Chunk[] chunks = world.getLoadedChunks();
        ArrayList<ChunkPart> chunkParts = new ArrayList<ChunkPart>(chunks.length);
        for (Chunk chunk : chunks) {
            chunkParts.add(ChunkLocation.of(chunk).toPart());
        }
        if (groupByChunk) {
            ScanTask.scanAndDisplayGroupedByChunk(this.plugin, player, chunkParts, chunkParts.size(), options, items, false);
        } else {
            ScanTask.scanAndDisplay(this.plugin, player, chunkParts, chunkParts.size(), options, items, displayZeros);
        }
    }
}

