/*
 * Decompiled with CFR 0.152.
 */
package dev.frankheijden.insights.commands;

import dev.frankheijden.insights.api.InsightsPlugin;
import dev.frankheijden.insights.api.commands.InsightsCommand;
import dev.frankheijden.insights.api.concurrent.ChunkTeleport;
import dev.frankheijden.insights.api.config.Messages;
import dev.frankheijden.insights.core.dependencies.cloud.annotations.Argument;
import dev.frankheijden.insights.core.dependencies.cloud.annotations.Command;
import dev.frankheijden.insights.core.dependencies.cloud.annotations.Flag;
import dev.frankheijden.insights.core.dependencies.cloud.annotations.Permission;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CommandTeleportChunk
extends InsightsCommand {
    public CommandTeleportChunk(InsightsPlugin plugin) {
        super(plugin);
    }

    @Command(value="teleportchunk|tpchunk <world> <x> <z>")
    @Permission(value={"insights.teleportchunk"})
    private void handleTeleportChunk(Player player, @Argument(value="world") World world, @Argument(value="x") int chunkX, @Argument(value="z") int chunkZ, @Flag(value="generate", aliases={"g"}) boolean generate) {
        ChunkTeleport chunkTp = this.plugin.getChunkTeleport();
        Messages messages = this.plugin.getMessages();
        chunkTp.teleportPlayerToChunk(player, world, chunkX, chunkZ, generate).whenComplete((res, err) -> {
            Messages.Message message;
            if (err != null) {
                message = messages.getMessage(Messages.Key.TELEPORTCHUNK_ERROR);
            } else {
                message = switch (res) {
                    case ChunkTeleport.Result.NOT_GENERATED -> messages.getMessage(Messages.Key.TELEPORTCHUNK_NOT_GENERATED);
                    case ChunkTeleport.Result.FAILED -> messages.getMessage(Messages.Key.TELEPORTCHUNK_FAILED);
                    case ChunkTeleport.Result.SUCCESS -> messages.getMessage(Messages.Key.TELEPORTCHUNK_SUCCESS).addTemplates(Messages.tagOf("world", world.getName()), Messages.tagOf("chunk-x", chunkX), Messages.tagOf("chunk-z", chunkZ));
                    default -> throw new IllegalArgumentException("Unhandled result case: " + String.valueOf(res));
                };
            }
            message.sendTo((CommandSender)player);
        });
    }
}

