/*
 * Decompiled with CFR 0.152.
 */
package dev.frankheijden.insights.commands.parser;

import dev.frankheijden.insights.api.InsightsPlugin;
import dev.frankheijden.insights.api.config.limits.Limit;
import dev.frankheijden.insights.core.dependencies.cloud.context.CommandContext;
import dev.frankheijden.insights.core.dependencies.cloud.context.CommandInput;
import dev.frankheijden.insights.core.dependencies.cloud.parser.ArgumentParseResult;
import dev.frankheijden.insights.core.dependencies.cloud.parser.ArgumentParser;
import dev.frankheijden.insights.core.dependencies.cloud.parser.ParserParameters;
import dev.frankheijden.insights.core.dependencies.cloud.suggestion.Suggestion;
import dev.frankheijden.insights.core.dependencies.cloud.suggestion.SuggestionProvider;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public class LimitParser<C>
implements ArgumentParser<C, Limit>,
SuggestionProvider<C> {
    public LimitParser(ParserParameters options) {
    }

    @Override
    public ArgumentParseResult<Limit> parse(CommandContext<C> ctx, CommandInput input) {
        String fileName = input.peekString();
        Optional<Limit> limit = InsightsPlugin.getInstance().getLimits().getLimitByFileName(fileName);
        if (limit.isEmpty()) {
            return ArgumentParseResult.failure(new IllegalArgumentException("Invalid limit file name '" + fileName + "'"));
        }
        input.readString();
        return ArgumentParseResult.success(limit.get());
    }

    @Override
    public CompletableFuture<? extends Iterable<? extends Suggestion>> suggestionsFuture(CommandContext<C> ctx, CommandInput input) {
        return CompletableFuture.completedFuture(InsightsPlugin.getInstance().getLimits().getLimitFileNames().stream().map(Suggestion::suggestion).toList());
    }
}

