/*
 * Decompiled with CFR 0.152.
 */
package dev.frankheijden.insights.commands.parser;

import dev.frankheijden.insights.api.InsightsPlugin;
import dev.frankheijden.insights.api.concurrent.storage.ScanHistory;
import dev.frankheijden.insights.api.config.Messages;
import dev.frankheijden.insights.api.utils.StringUtils;
import dev.frankheijden.insights.commands.CommandScanHistory;
import dev.frankheijden.insights.core.dependencies.cloud.context.CommandContext;
import dev.frankheijden.insights.core.dependencies.cloud.context.CommandInput;
import dev.frankheijden.insights.core.dependencies.cloud.parser.ArgumentParseResult;
import dev.frankheijden.insights.core.dependencies.cloud.parser.ArgumentParser;
import dev.frankheijden.insights.core.dependencies.cloud.parser.ParserParameters;
import dev.frankheijden.insights.core.dependencies.cloud.suggestion.Suggestion;
import dev.frankheijden.insights.core.dependencies.cloud.suggestion.SuggestionProvider;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ScanHistoryPageParser<C>
implements ArgumentParser<C, CommandScanHistory.Page>,
SuggestionProvider<C> {
    public ScanHistoryPageParser(ParserParameters options) {
    }

    @Override
    public ArgumentParseResult<CommandScanHistory.Page> parse(CommandContext<C> ctx, CommandInput input) {
        try {
            int pageNumber = Integer.parseInt(input.peekString());
            if (pageNumber <= 0) {
                throw new NumberFormatException();
            }
            input.readString();
            return ArgumentParseResult.success(new CommandScanHistory.Page(pageNumber - 1));
        }
        catch (NumberFormatException ex) {
            return ArgumentParseResult.failure(new IllegalArgumentException("Invalid Page '" + input.peekString() + "'"));
        }
    }

    @Override
    public CompletableFuture<? extends Iterable<? extends Suggestion>> suggestionsFuture(CommandContext<C> ctx, CommandInput input) {
        return CompletableFuture.supplyAsync(() -> {
            CommandSourceStack sourceStack;
            CommandSender patt1$temp;
            Object patt0$temp = ctx.sender();
            if (patt0$temp instanceof CommandSourceStack && (patt1$temp = (sourceStack = (CommandSourceStack)patt0$temp).getSender()) instanceof Player) {
                Player player = (Player)patt1$temp;
                ScanHistory scanHistory = InsightsPlugin.getInstance().getScanHistory();
                int pages = scanHistory.getHistory(player.getUniqueId()).map(Messages.PaginatedMessage::getPageAmount).orElse(0);
                ArrayList<String> suggestions = new ArrayList<String>(pages);
                for (int i = 1; i <= pages; ++i) {
                    suggestions.add(String.valueOf(i));
                }
                return StringUtils.findThatStartsWith(suggestions, input.peekString()).stream().map(Suggestion::suggestion).toList();
            }
            return Collections.emptyList();
        });
    }
}

