/*
 * Decompiled with CFR 0.152.
 */
package dev.frankheijden.insights.commands.parser;

import dev.frankheijden.insights.api.objects.wrappers.ScanObject;
import dev.frankheijden.insights.api.utils.Constants;
import dev.frankheijden.insights.api.utils.StringUtils;
import dev.frankheijden.insights.core.dependencies.cloud.context.CommandContext;
import dev.frankheijden.insights.core.dependencies.cloud.context.CommandInput;
import dev.frankheijden.insights.core.dependencies.cloud.parser.ArgumentParseResult;
import dev.frankheijden.insights.core.dependencies.cloud.parser.ArgumentParser;
import dev.frankheijden.insights.core.dependencies.cloud.parser.ParserParameters;
import dev.frankheijden.insights.core.dependencies.cloud.suggestion.Suggestion;
import dev.frankheijden.insights.core.dependencies.cloud.suggestion.SuggestionProvider;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ScanObjectArrayParser<C>
implements ArgumentParser<C, ScanObject<?>[]>,
SuggestionProvider<C> {
    protected static final Set<String> SUGGESTIONS = Stream.concat(Constants.BLOCKS.stream(), Constants.ENTITIES.stream()).map(Enum::name).map(String::toLowerCase).collect(Collectors.toSet());

    public ScanObjectArrayParser(ParserParameters options) {
    }

    @Override
    public ArgumentParseResult<ScanObject<?>[]> parse(CommandContext<C> ctx, CommandInput input) {
        try {
            int indexOf = input.input().indexOf(input.peekString());
            int queueSize = input.input().substring(indexOf).split(" ").length;
            ArrayList items = new ArrayList(queueSize);
            for (int i = 0; i < queueSize - 1; ++i) {
                items.add(ScanObject.parse(input.peekString()));
                input.readString();
            }
            String last = input.peekString();
            if (!last.equalsIgnoreCase("-c") && !last.equalsIgnoreCase("--group-by-chunk")) {
                items.add(ScanObject.parse(last));
                input.readString();
            }
            return ArgumentParseResult.success((ScanObject[])items.toArray(ScanObject[]::new));
        }
        catch (IllegalArgumentException ex) {
            return ArgumentParseResult.failure(new IllegalArgumentException("Invalid Material '" + input.peekString() + "'"));
        }
    }

    @Override
    public CompletableFuture<? extends Iterable<? extends Suggestion>> suggestionsFuture(CommandContext<C> ctx, CommandInput input) {
        return CompletableFuture.completedFuture(StringUtils.findThatStartsWith(SUGGESTIONS, input.peekString()).stream().map(Suggestion::suggestion).toList());
    }
}

