/*
 * Decompiled with CFR 0.152.
 */
package dev.frankheijden.insights.commands.parser;

import dev.frankheijden.insights.core.dependencies.cloud.context.CommandContext;
import dev.frankheijden.insights.core.dependencies.cloud.context.CommandInput;
import dev.frankheijden.insights.core.dependencies.cloud.parser.ArgumentParseResult;
import dev.frankheijden.insights.core.dependencies.cloud.parser.ArgumentParser;
import dev.frankheijden.insights.core.dependencies.cloud.parser.ParserParameters;
import dev.frankheijden.insights.core.dependencies.cloud.suggestion.Suggestion;
import dev.frankheijden.insights.core.dependencies.cloud.suggestion.SuggestionProvider;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Bukkit;
import org.bukkit.World;

public class WorldParser<C>
implements ArgumentParser<C, World>,
SuggestionProvider<C> {
    public WorldParser(ParserParameters options) {
    }

    @Override
    public ArgumentParseResult<World> parse(CommandContext<C> ctx, CommandInput input) {
        World world = Bukkit.getWorld((String)input.peekString());
        if (world == null) {
            return ArgumentParseResult.failure(new IllegalArgumentException("Invalid World '" + input.peekString() + "'"));
        }
        input.readString();
        return ArgumentParseResult.success(world);
    }

    @Override
    public CompletableFuture<? extends Iterable<? extends Suggestion>> suggestionsFuture(CommandContext<C> ctx, CommandInput input) {
        return CompletableFuture.completedFuture(Bukkit.getWorlds().stream().map(world -> Suggestion.suggestion(world.getName())).toList());
    }
}

