/*
 * Decompiled with CFR 0.152.
 */
package dev.frankheijden.insights.commands.util;

import dev.frankheijden.insights.core.dependencies.cloud.SenderMapper;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommandSenderMapper
implements SenderMapper<CommandSourceStack, CommandSender> {
    @Override
    public CommandSender map(CommandSourceStack source) {
        return source.getSender();
    }

    @Override
    public CommandSourceStack reverse(final CommandSender sender) {
        return new CommandSourceStack(){

            @NotNull
            public Location getLocation() {
                if (sender instanceof Entity) {
                    Entity entity = (Entity)sender;
                    return entity.getLocation();
                }
                List worlds = Bukkit.getWorlds();
                return new Location(worlds.isEmpty() ? null : (World)worlds.getFirst(), 0.0, 0.0, 0.0);
            }

            @NotNull
            public CommandSender getSender() {
                return sender;
            }

            @Nullable
            public Entity getExecutor() {
                Entity entity;
                return sender instanceof Entity ? (entity = (Entity)sender) : null;
            }
        };
    }
}

