/*
 * Decompiled with CFR 0.152.
 */
package dev.frankheijden.insights.core.dependencies.cloud.annotations.extractor;

import dev.frankheijden.insights.core.dependencies.cloud.annotations.AnnotationParser;
import dev.frankheijden.insights.core.dependencies.cloud.annotations.Command;
import dev.frankheijden.insights.core.dependencies.cloud.annotations.descriptor.CommandDescriptor;
import dev.frankheijden.insights.core.dependencies.cloud.annotations.descriptor.ImmutableCommandDescriptor;
import dev.frankheijden.insights.core.dependencies.cloud.annotations.extractor.CommandExtractor;
import dev.frankheijden.insights.core.dependencies.cloud.util.annotation.AnnotationAccessor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;

@API(status=API.Status.INTERNAL, consumers={"dev.frankheijden.insights.core.dependencies.cloud.annotations.*"})
public final class CommandExtractorImpl
implements CommandExtractor {
    private final AnnotationParser<?> annotationParser;

    public CommandExtractorImpl(@NonNull AnnotationParser<?> annotationParser) {
        this.annotationParser = annotationParser;
    }

    @Override
    public @NonNull Collection<@NonNull CommandDescriptor> extractCommands(@NonNull Object instance) {
        AnnotationAccessor classAnnotations = AnnotationAccessor.of(instance.getClass());
        Command classCommand = classAnnotations.annotation(Command.class);
        String syntaxPrefix = classCommand == null ? "" : this.annotationParser.processString(classCommand.value()) + " ";
        Method[] methods = instance.getClass().getDeclaredMethods();
        ArrayList<CommandDescriptor> commandDescriptors = new ArrayList<CommandDescriptor>();
        for (Method method : methods) {
            Command[] commands = (Command[])method.getAnnotationsByType(Command.class);
            if (commands.length == 0) continue;
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            if (Modifier.isStatic(method.getModifiers())) {
                throw new IllegalArgumentException(String.format("@Command annotated method '%s' is static! @Command annotated methods should not be static.", method.getName()));
            }
            for (Command command : commands) {
                String syntax = syntaxPrefix + this.annotationParser.processString(command.value());
                commandDescriptors.add(ImmutableCommandDescriptor.builder().method(method).syntax(this.annotationParser.syntaxParser().parseSyntax(method, syntax)).commandToken(syntax.split(" ")[0].split("\\|")[0]).requiredSender(command.requiredSender()).build());
            }
        }
        return commandDescriptors;
    }
}

