/*
 * Decompiled with CFR 0.152.
 */
package dev.frankheijden.insights.core.dependencies.cloud.bukkit;

import dev.frankheijden.insights.core.dependencies.cloud.CommandManager;
import dev.frankheijden.insights.core.dependencies.cloud.bukkit.BukkitParserParameters;
import dev.frankheijden.insights.core.dependencies.cloud.bukkit.CloudBukkitCapabilities;
import dev.frankheijden.insights.core.dependencies.cloud.bukkit.annotation.specifier.AllowEmptySelection;
import dev.frankheijden.insights.core.dependencies.cloud.bukkit.annotation.specifier.DefaultNamespace;
import dev.frankheijden.insights.core.dependencies.cloud.bukkit.annotation.specifier.RequireExplicitNamespace;
import dev.frankheijden.insights.core.dependencies.cloud.bukkit.data.MultipleEntitySelector;
import dev.frankheijden.insights.core.dependencies.cloud.bukkit.data.MultiplePlayerSelector;
import dev.frankheijden.insights.core.dependencies.cloud.bukkit.internal.CraftBukkitReflection;
import dev.frankheijden.insights.core.dependencies.cloud.bukkit.parser.BlockPredicateParser;
import dev.frankheijden.insights.core.dependencies.cloud.bukkit.parser.EnchantmentParser;
import dev.frankheijden.insights.core.dependencies.cloud.bukkit.parser.ItemStackParser;
import dev.frankheijden.insights.core.dependencies.cloud.bukkit.parser.ItemStackPredicateParser;
import dev.frankheijden.insights.core.dependencies.cloud.bukkit.parser.MaterialParser;
import dev.frankheijden.insights.core.dependencies.cloud.bukkit.parser.NamespacedKeyParser;
import dev.frankheijden.insights.core.dependencies.cloud.bukkit.parser.OfflinePlayerParser;
import dev.frankheijden.insights.core.dependencies.cloud.bukkit.parser.PlayerParser;
import dev.frankheijden.insights.core.dependencies.cloud.bukkit.parser.WorldParser;
import dev.frankheijden.insights.core.dependencies.cloud.bukkit.parser.location.Location2DParser;
import dev.frankheijden.insights.core.dependencies.cloud.bukkit.parser.location.LocationParser;
import dev.frankheijden.insights.core.dependencies.cloud.bukkit.parser.selector.MultipleEntitySelectorParser;
import dev.frankheijden.insights.core.dependencies.cloud.bukkit.parser.selector.MultiplePlayerSelectorParser;
import dev.frankheijden.insights.core.dependencies.cloud.bukkit.parser.selector.SingleEntitySelectorParser;
import dev.frankheijden.insights.core.dependencies.cloud.bukkit.parser.selector.SinglePlayerSelectorParser;
import dev.frankheijden.insights.core.dependencies.cloud.parser.ParserParameters;
import dev.frankheijden.insights.core.dependencies.typetoken.TypeToken;
import java.lang.reflect.Method;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;

@API(status=API.Status.INTERNAL)
public final class BukkitParsers {
    private BukkitParsers() {
    }

    public static <C> void register(CommandManager<C> manager) {
        manager.parserRegistry().registerParser(WorldParser.worldParser()).registerParser(MaterialParser.materialParser()).registerParser(PlayerParser.playerParser()).registerParser(OfflinePlayerParser.offlinePlayerParser()).registerParser(EnchantmentParser.enchantmentParser()).registerParser(LocationParser.locationParser()).registerParser(Location2DParser.location2DParser()).registerParser(ItemStackParser.itemStackParser()).registerParser(SingleEntitySelectorParser.singleEntitySelectorParser()).registerParser(SinglePlayerSelectorParser.singlePlayerSelectorParser());
        manager.parserRegistry().registerAnnotationMapper(AllowEmptySelection.class, (annotation, type) -> ParserParameters.single(BukkitParserParameters.ALLOW_EMPTY_SELECTOR_RESULT, annotation.value()));
        manager.parserRegistry().registerParserSupplier(TypeToken.get(MultipleEntitySelector.class), parserParameters -> new MultipleEntitySelectorParser(parserParameters.get(BukkitParserParameters.ALLOW_EMPTY_SELECTOR_RESULT, true)));
        manager.parserRegistry().registerParserSupplier(TypeToken.get(MultiplePlayerSelector.class), parserParameters -> new MultiplePlayerSelectorParser(parserParameters.get(BukkitParserParameters.ALLOW_EMPTY_SELECTOR_RESULT, true)));
        if (CraftBukkitReflection.classExists("org.bukkit.NamespacedKey")) {
            BukkitParsers.registerParserSupplierFor(manager, NamespacedKeyParser.class);
            manager.parserRegistry().registerAnnotationMapper(RequireExplicitNamespace.class, (annotation, type) -> ParserParameters.single(BukkitParserParameters.REQUIRE_EXPLICIT_NAMESPACE, true));
            manager.parserRegistry().registerAnnotationMapper(DefaultNamespace.class, (annotation, type) -> ParserParameters.single(BukkitParserParameters.DEFAULT_NAMESPACE, annotation.value()));
        }
        if (manager.hasCapability(CloudBukkitCapabilities.BRIGADIER)) {
            BukkitParsers.registerParserSupplierFor(manager, ItemStackPredicateParser.class);
            BukkitParsers.registerParserSupplierFor(manager, BlockPredicateParser.class);
        }
    }

    private static void registerParserSupplierFor(CommandManager<?> manager, @NonNull Class<?> argumentClass) {
        try {
            Method registerParserSuppliers = argumentClass.getDeclaredMethod("registerParserSupplier", CommandManager.class);
            registerParserSuppliers.setAccessible(true);
            registerParserSuppliers.invoke(null, manager);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }
}

