/*
 * Decompiled with CFR 0.152.
 */
package dev.frankheijden.insights.core.dependencies.cloud.bukkit.parser;

import dev.frankheijden.insights.core.dependencies.cloud.bukkit.BukkitCaptionKeys;
import dev.frankheijden.insights.core.dependencies.cloud.bukkit.BukkitCommandContextKeys;
import dev.frankheijden.insights.core.dependencies.cloud.caption.CaptionVariable;
import dev.frankheijden.insights.core.dependencies.cloud.component.CommandComponent;
import dev.frankheijden.insights.core.dependencies.cloud.context.CommandContext;
import dev.frankheijden.insights.core.dependencies.cloud.context.CommandInput;
import dev.frankheijden.insights.core.dependencies.cloud.exception.parsing.ParserException;
import dev.frankheijden.insights.core.dependencies.cloud.parser.ArgumentParseResult;
import dev.frankheijden.insights.core.dependencies.cloud.parser.ArgumentParser;
import dev.frankheijden.insights.core.dependencies.cloud.parser.ParserDescriptor;
import dev.frankheijden.insights.core.dependencies.cloud.suggestion.BlockingSuggestionProvider;
import dev.frankheijden.insights.core.dependencies.cloud.suggestion.Suggestion;
import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class PlayerParser<C>
implements ArgumentParser<C, Player>,
BlockingSuggestionProvider<C> {
    @API(status=API.Status.STABLE, since="2.0.0")
    public static <C> @NonNull ParserDescriptor<C, Player> playerParser() {
        return ParserDescriptor.of(new PlayerParser<C>(), Player.class);
    }

    @API(status=API.Status.STABLE, since="2.0.0")
    public static <C> @NonNull CommandComponent.Builder<C, Player> playerComponent() {
        return CommandComponent.builder().parser(PlayerParser.playerParser());
    }

    @Override
    public @NonNull ArgumentParseResult<Player> parse(@NonNull CommandContext<C> commandContext, @NonNull CommandInput commandInput) {
        String input = commandInput.readString();
        Player player = Bukkit.getPlayer((String)input);
        if (player == null) {
            return ArgumentParseResult.failure(new PlayerParseException(input, commandContext));
        }
        return ArgumentParseResult.success(player);
    }

    @Override
    public @NonNull Iterable<@NonNull Suggestion> suggestions(@NonNull CommandContext<C> commandContext, @NonNull CommandInput input) {
        CommandSender bukkit = commandContext.get(BukkitCommandContextKeys.BUKKIT_COMMAND_SENDER);
        return Bukkit.getOnlinePlayers().stream().filter(player -> !(bukkit instanceof Player) || ((Player)bukkit).canSee(player)).map(OfflinePlayer::getName).map(Suggestion::suggestion).collect(Collectors.toList());
    }

    public static final class PlayerParseException
    extends ParserException {
        private final String input;

        public PlayerParseException(@NonNull String input, @NonNull CommandContext<?> context) {
            super(PlayerParser.class, context, BukkitCaptionKeys.ARGUMENT_PARSE_FAILURE_PLAYER, CaptionVariable.of("input", input));
            this.input = input;
        }

        public @NonNull String input() {
            return this.input;
        }
    }
}

