/*
 * Decompiled with CFR 0.152.
 */
package dev.frankheijden.insights.core.dependencies.cloud.parser.standard;

import dev.frankheijden.insights.core.dependencies.cloud.caption.CaptionVariable;
import dev.frankheijden.insights.core.dependencies.cloud.caption.StandardCaptionKeys;
import dev.frankheijden.insights.core.dependencies.cloud.component.CommandComponent;
import dev.frankheijden.insights.core.dependencies.cloud.context.CommandContext;
import dev.frankheijden.insights.core.dependencies.cloud.context.CommandInput;
import dev.frankheijden.insights.core.dependencies.cloud.exception.parsing.ParserException;
import dev.frankheijden.insights.core.dependencies.cloud.parser.ArgumentParseResult;
import dev.frankheijden.insights.core.dependencies.cloud.parser.ArgumentParser;
import dev.frankheijden.insights.core.dependencies.cloud.parser.ParserDescriptor;
import java.util.Objects;
import java.util.UUID;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;

@API(status=API.Status.STABLE)
public final class UUIDParser<C>
implements ArgumentParser<C, UUID> {
    @API(status=API.Status.STABLE)
    public static <C> @NonNull ParserDescriptor<C, UUID> uuidParser() {
        return ParserDescriptor.of(new UUIDParser<C>(), UUID.class);
    }

    @API(status=API.Status.STABLE)
    public static <C> @NonNull CommandComponent.Builder<C, UUID> uuidComponent() {
        return CommandComponent.builder().parser(UUIDParser.uuidParser());
    }

    @Override
    public @NonNull ArgumentParseResult<UUID> parse(@NonNull CommandContext<C> commandContext, @NonNull CommandInput commandInput) {
        String input = commandInput.readString();
        try {
            UUID uuid = UUID.fromString(input);
            return ArgumentParseResult.success(uuid);
        }
        catch (IllegalArgumentException e) {
            return ArgumentParseResult.failure(new UUIDParseException(input, commandContext));
        }
    }

    @API(status=API.Status.STABLE)
    public static final class UUIDParseException
    extends ParserException {
        private final String input;

        public UUIDParseException(@NonNull String input, @NonNull CommandContext<?> context) {
            super(UUIDParser.class, context, StandardCaptionKeys.ARGUMENT_PARSE_FAILURE_UUID, CaptionVariable.of("input", input));
            this.input = input;
        }

        public String input() {
            return this.input;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UUIDParseException that = (UUIDParseException)o;
            return this.input.equals(that.input);
        }

        public int hashCode() {
            return Objects.hash(this.input);
        }
    }
}

