/*
 * Decompiled with CFR 0.152.
 */
package dev.frankheijden.insights.listeners;

import dev.frankheijden.insights.Insights;
import dev.frankheijden.insights.api.addons.Region;
import dev.frankheijden.insights.api.annotations.AllowDisabling;
import dev.frankheijden.insights.api.annotations.AllowPriorityOverride;
import dev.frankheijden.insights.api.listeners.InsightsListener;
import dev.frankheijden.insights.api.objects.wrappers.ScanObject;
import dev.frankheijden.insights.api.util.MaterialTags;
import dev.frankheijden.insights.api.utils.BlockUtils;
import dev.frankheijden.insights.api.utils.ChunkUtils;
import dev.frankheijden.insights.listeners.PlayerListener;
import java.util.List;
import java.util.Optional;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.Waterlogged;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.block.BlockFadeEvent;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.block.BlockGrowEvent;
import org.bukkit.event.block.BlockIgniteEvent;
import org.bukkit.event.block.BlockMultiPlaceEvent;
import org.bukkit.event.block.BlockPistonEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.event.block.BlockSpreadEvent;
import org.bukkit.event.block.EntityBlockFormEvent;
import org.bukkit.event.block.FluidLevelChangeEvent;
import org.bukkit.event.block.LeavesDecayEvent;
import org.bukkit.event.block.SpongeAbsorbEvent;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.event.player.PlayerBucketFillEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class BlockListener
extends InsightsListener {
    public BlockListener(Insights plugin) {
        super(plugin);
    }

    @AllowPriorityOverride
    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onBlockPlace(BlockPlaceEvent event) {
        Block block = event.getBlock();
        Location location = block.getLocation();
        Material material = block.getType();
        Player player = event.getPlayer();
        int delta = 0;
        if (event instanceof BlockMultiPlaceEvent && material != Material.TRIPWIRE_HOOK) {
            List replacedBlockStates = ((BlockMultiPlaceEvent)event).getReplacedBlockStates();
            for (BlockState state : replacedBlockStates) {
                if (!BlockUtils.isSameChunk(location.getBlockX(), location.getBlockZ(), state.getX(), state.getZ())) continue;
                ++delta;
            }
        } else {
            delta = 1;
        }
        if (this.handleAddition(player, location, ScanObject.of(material), delta, false)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockPlaceMonitor(BlockPlaceEvent event) {
        Block block = event.getBlock();
        Location location = block.getLocation();
        Material material = block.getType();
        Player player = event.getPlayer();
        if (event instanceof BlockMultiPlaceEvent && material != Material.TRIPWIRE_HOOK) {
            List replacedBlockStates = ((BlockMultiPlaceEvent)event).getReplacedBlockStates();
            for (BlockState state : replacedBlockStates) {
                Location loc = state.getLocation();
                this.handleModification(loc, state.getType(), material, 1);
            }
        } else {
            this.handleModification(location, event.getBlockReplacedState().getType(), material, 1);
        }
        this.evaluateAddition(player, location, ScanObject.of(material), 0);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent event) {
        Optional<Block> blockOptional;
        Block block = event.getBlock();
        Location location = block.getLocation();
        Material material = block.getType();
        Player player = event.getPlayer();
        if (Tag.BEDS.isTagged((Keyed)material) && (blockOptional = BlockUtils.getOtherHalf(block)).isPresent()) {
            Block otherHalf = blockOptional.get();
            this.handleModification(otherHalf.getLocation(), material, -1);
        }
        this.handleRemoval(player, location, ScanObject.of(material), 1, false);
        Block aboveBlock = this.getTopNonGravityBlock(block);
        Material aboveMaterial = aboveBlock.getType();
        if (MaterialTags.NEEDS_GROUND.isTagged(aboveMaterial)) {
            this.handleRemoval(player, aboveBlock.getLocation(), ScanObject.of(aboveMaterial), 1, false);
        }
    }

    @AllowPriorityOverride
    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerBucketEmpty(PlayerBucketEmptyEvent event) {
        Block block = event.getBlock();
        Location location = block.getLocation();
        Material material = this.bucketToBlock(event.getBucket());
        if (this.handleAddition(event.getPlayer(), location, ScanObject.of(material), 1, false)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerBucketEmptyMonitor(PlayerBucketEmptyEvent event) {
        Block block = event.getBlock();
        Location location = block.getLocation();
        Material material = this.bucketToBlock(event.getBucket());
        this.handleModification(location, block.getType(), material, 1);
        this.evaluateAddition(event.getPlayer(), location, ScanObject.of(material), 0);
    }

    private Material bucketToBlock(Material bucket) {
        return switch (bucket) {
            case Material.LAVA_BUCKET -> Material.LAVA;
            case Material.POWDER_SNOW_BUCKET -> Material.POWDER_SNOW;
            default -> Material.WATER;
        };
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerBucketFill(PlayerBucketFillEvent event) {
        Waterlogged waterlogged;
        Block block = event.getBlock();
        ItemStack itemStack = event.getItemStack();
        if (itemStack != null && itemStack.getType() == Material.MILK_BUCKET) {
            return;
        }
        Material material = block.getType();
        BlockData blockData = block.getBlockData();
        if (blockData instanceof Waterlogged && (waterlogged = (Waterlogged)blockData).isWaterlogged()) {
            material = Material.WATER;
        }
        this.handleRemoval(event.getPlayer(), block.getLocation(), ScanObject.of(material), 1, false);
    }

    private Block getTopNonGravityBlock(Block start) {
        while ((start = start.getRelative(BlockFace.UP)).getType().hasGravity()) {
        }
        return start;
    }

    @AllowDisabling
    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockBurn(BlockBurnEvent event) {
        this.handleModification(event.getBlock(), -1);
    }

    @AllowDisabling
    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockDispense(BlockDispenseEvent event) {
        Block block = event.getBlock();
        BlockData blockData = block.getBlockData();
        if (!(blockData instanceof Directional)) {
            return;
        }
        Block relative = block.getRelative(((Directional)blockData).getFacing());
        Material item = event.getItem().getType();
        if (item == Material.BUCKET) {
            this.handleModification(relative, -1);
            return;
        }
        Material material = null;
        if (MaterialTags.BUCKETS.isTagged(item) && item != Material.MILK_BUCKET) {
            material = Material.WATER;
        } else if (Tag.SHULKER_BOXES.isTagged((Keyed)item)) {
            material = item;
        }
        if (material != null) {
            this.handleModification(relative.getLocation(), relative.getType(), material, 1);
        }
    }

    @AllowDisabling
    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockExplode(BlockExplodeEvent event) {
        Block block = event.getBlock();
        Location location = block.getLocation();
        PlayerListener playerListener = ((Insights)this.plugin).getListenerManager().getPlayerListener();
        Optional<PlayerListener.ExplodedBed> bedOptional = playerListener.getIntentionalDesignBugAt(location);
        if (bedOptional.isPresent()) {
            PlayerListener.ExplodedBed explodedBed = bedOptional.get();
            Material material = explodedBed.getMaterial();
            this.handleModification(explodedBed.getHead(), material, -1);
            this.handleModification(explodedBed.getFoot(), material, -1);
        } else {
            this.handleModification(location, block.getType(), -1);
        }
        for (Block explodedBlock : event.blockList()) {
            this.handleModification(explodedBlock, -1);
        }
    }

    @AllowDisabling
    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockFade(BlockFadeEvent event) {
        Block block = event.getBlock();
        this.handleModification(block.getLocation(), block.getType(), event.getNewState().getType(), 1);
    }

    @AllowDisabling
    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockFromTo(BlockFromToEvent event) {
        Block block = event.getToBlock();
        this.handleModification(block.getLocation(), block.getType(), event.getBlock().getType(), 1);
    }

    @AllowDisabling
    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onFluidLevelChange(FluidLevelChangeEvent event) {
        if (event.getNewData().getMaterial() == Material.AIR) {
            this.handleModification(event.getBlock(), -1);
        }
    }

    @AllowDisabling
    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockGrow(BlockGrowEvent event) {
        Block block = event.getBlock();
        this.handleModification(block.getLocation(), block.getType(), event.getNewState().getType(), 1);
    }

    @AllowDisabling
    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockIgnite(BlockIgniteEvent event) {
        this.handleModification(event.getBlock(), -1);
    }

    @AllowDisabling
    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockPistonExtend(BlockPistonExtendEvent event) {
        this.handlePistonEvent((BlockPistonEvent)event, event.getBlocks());
    }

    @AllowDisabling
    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockPistonRetract(BlockPistonRetractEvent event) {
        this.handlePistonEvent((BlockPistonEvent)event, event.getBlocks());
    }

    private void handlePistonEvent(BlockPistonEvent event, List<Block> blocks) {
        if (blocks.isEmpty()) {
            return;
        }
        Material[] materials = new Material[blocks.size()];
        for (int i = 0; i < blocks.size(); ++i) {
            Block block = blocks.get(i);
            Material material = block.getType();
            this.handleModification(block.getLocation(), material, -1);
            materials[i] = material;
        }
        this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            for (int i = 0; i < blocks.size(); ++i) {
                Block relative = ((Block)blocks.get(i)).getRelative(event.getDirection());
                Material material = relative.getType();
                if (materials[i] != material) continue;
                this.handleModification(relative.getLocation(), material, 1);
            }
        }, 3L);
    }

    @AllowDisabling
    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockSpread(BlockSpreadEvent event) {
        Block block = event.getBlock();
        this.handleModification(block.getLocation(), block.getType(), event.getNewState().getType(), 1);
    }

    @AllowDisabling
    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onEntityBlockForm(EntityBlockFormEvent event) {
        Block block = event.getBlock();
        this.handleModification(block.getLocation(), block.getType(), event.getNewState().getType(), 1);
    }

    @AllowDisabling
    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onLeavesDecay(LeavesDecayEvent event) {
        this.handleModification(event.getBlock(), -1);
    }

    @AllowDisabling
    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onSpongeAbsorb(SpongeAbsorbEvent event) {
        Block block = event.getBlock();
        this.handleModification(block.getLocation(), Material.SPONGE, Material.WET_SPONGE, 1);
        for (BlockState state : event.getBlocks()) {
            this.handleModification(state.getLocation(), Material.WATER, state.getType(), 1);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onBlockRedstone(BlockRedstoneEvent event) {
        int count;
        Block block = event.getBlock();
        Location loc = block.getLocation();
        Optional<Region> regionOptional = this.plugin.getAddonManager().getRegion(loc);
        if (regionOptional.isPresent()) {
            count = this.plugin.getRedstoneUpdateCount().increment(regionOptional.get().getKey());
        } else {
            if (this.plugin.getSettings().REDSTONE_UPDATE_LIMITER_BLOCK_OUTSIDE_REGION) {
                event.setNewCurrent(0);
                return;
            }
            count = this.plugin.getRedstoneUpdateCount().increment(ChunkUtils.getKey(loc));
        }
        if (count > this.plugin.getSettings().REDSTONE_UPDATE_LIMITER_LIMIT) {
            event.setNewCurrent(0);
        }
    }
}

