/*
 * Decompiled with CFR 0.152.
 */
package dev.frankheijden.insights.listeners;

import dev.frankheijden.insights.api.InsightsPlugin;
import dev.frankheijden.insights.api.annotations.AllowPriorityOverride;
import dev.frankheijden.insights.api.events.EntityRemoveFromWorldEvent;
import dev.frankheijden.insights.api.listeners.InsightsListener;
import dev.frankheijden.insights.api.objects.wrappers.ScanObject;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Tameable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityBreakDoorEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.EntityPlaceEvent;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.bukkit.event.hanging.HangingBreakEvent;
import org.bukkit.event.hanging.HangingPlaceEvent;
import org.bukkit.projectiles.ProjectileSource;

public class EntityListener
extends InsightsListener {
    protected static final Set<EntityType> LIMITED_ENTITIES = EnumSet.of(EntityType.ARMOR_STAND, EntityType.END_CRYSTAL, EntityType.ITEM_FRAME, EntityType.GLOW_ITEM_FRAME, EntityType.PAINTING);
    private final Set<UUID> removedEntities = new HashSet<UUID>();

    public EntityListener(InsightsPlugin plugin) {
        super(plugin);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onEntityBreakDoor(EntityBreakDoorEvent event) {
        this.handleModification(event.getBlock(), -2);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onEntityChangeBlock(EntityChangeBlockEvent event) {
        Block block = event.getBlock();
        this.handleModification(block.getLocation(), block.getType(), event.getTo(), 1);
    }

    @AllowPriorityOverride
    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onHangingPlace(HangingPlaceEvent event) {
        if (this.handleEntityPlace(event.getPlayer(), (Entity)event.getEntity())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onHangingPlaceMonitor(HangingPlaceEvent event) {
        this.evaluateEntityPlace(event.getPlayer(), (Entity)event.getEntity());
    }

    @AllowPriorityOverride
    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onEntityPlace(EntityPlaceEvent event) {
        if (this.handleEntityPlace(event.getPlayer(), event.getEntity())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onEntityPlaceMonitor(EntityPlaceEvent event) {
        this.evaluateEntityPlace(event.getPlayer(), event.getEntity());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onHangingBreak(HangingBreakEvent event) {
        Entity remover;
        Hanging entity = event.getEntity();
        EntityType entityType = entity.getType();
        if (!LIMITED_ENTITIES.contains(entityType)) {
            return;
        }
        this.removedEntities.add(entity.getUniqueId());
        Location location = entity.getLocation();
        int delta = 1;
        if (event instanceof HangingBreakByEntityEvent && (remover = ((HangingBreakByEntityEvent)event).getRemover()) instanceof Player) {
            this.handleRemoval((Player)remover, location, ScanObject.of(entityType), delta);
            return;
        }
        this.handleModification(location, entityType, -delta);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onEntityDeath(EntityDeathEvent event) {
        this.handleEntityRemoval((Entity)event.getEntity(), true);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onEntityExplosion(EntityExplodeEvent event) {
        this.handleEntityRemoval(event.getEntity(), true);
        for (Block block : event.blockList()) {
            this.handleModification(block, -1);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onEntityRemoveFromWorld(EntityRemoveFromWorldEvent event) {
        this.handleEntityRemoveFromWorld(event.getEntity());
    }

    protected void handleEntityRemoveFromWorld(Entity entity) {
        if (!entity.isDead() || this.removedEntities.remove(entity.getUniqueId())) {
            return;
        }
        this.handleEntityRemoval(entity, false);
    }

    protected boolean handleEntityPlace(Player player, Entity entity) {
        EntityType entityType = entity.getType();
        if (!LIMITED_ENTITIES.contains(entityType)) {
            return false;
        }
        return this.handleAddition(player, entity.getLocation(), ScanObject.of(entityType), 1, false);
    }

    protected void evaluateEntityPlace(Player player, Entity entity) {
        EntityType entityType = entity.getType();
        if (!LIMITED_ENTITIES.contains(entityType)) {
            return;
        }
        Location location = entity.getLocation();
        int delta = 1;
        this.evaluateAddition(player, location, ScanObject.of(entityType), delta);
        this.handleModification(location, entityType, delta);
    }

    protected void handleEntityRemoval(Entity entity, boolean isPlayer) {
        EntityType entityType = entity.getType();
        if (!LIMITED_ENTITIES.contains(entityType)) {
            return;
        }
        Location location = entity.getLocation();
        int delta = 1;
        if (isPlayer) {
            this.removedEntities.add(entity.getUniqueId());
            Optional<Player> player = this.getPlayerKiller(entity);
            if (player.isPresent()) {
                this.handleRemoval(player.get(), location, ScanObject.of(entityType), delta);
                return;
            }
        }
        this.handleModification(location, entityType, -delta);
    }

    protected Optional<Player> getPlayerKiller(Entity entity) {
        EntityDamageEvent event = entity.getLastDamageCause();
        if (event instanceof EntityDamageByEntityEvent) {
            return this.getPlayer(((EntityDamageByEntityEvent)event).getDamager());
        }
        return Optional.empty();
    }

    protected Optional<Player> getPlayer(Entity damager) {
        AnimalTamer tamer;
        if (damager instanceof Player) {
            return Optional.of((Player)damager);
        }
        if (damager instanceof Projectile) {
            ProjectileSource source = ((Projectile)damager).getShooter();
            if (source instanceof Player) {
                return Optional.of((Player)source);
            }
        } else if (damager instanceof Tameable && (tamer = ((Tameable)damager).getOwner()) instanceof Player) {
            return Optional.of((Player)tamer);
        }
        return Optional.empty();
    }
}

