/*
 * Decompiled with CFR 0.152.
 */
package dev.frankheijden.insights.listeners;

import dev.frankheijden.insights.api.InsightsPlugin;
import dev.frankheijden.insights.api.addons.Region;
import dev.frankheijden.insights.api.annotations.AllowPriorityOverride;
import dev.frankheijden.insights.api.concurrent.ScanOptions;
import dev.frankheijden.insights.api.concurrent.storage.Storage;
import dev.frankheijden.insights.api.config.limits.Limit;
import dev.frankheijden.insights.api.config.limits.LimitInfo;
import dev.frankheijden.insights.api.listeners.InsightsListener;
import dev.frankheijden.insights.api.objects.chunk.ChunkPart;
import dev.frankheijden.insights.api.objects.wrappers.ScanObject;
import dev.frankheijden.insights.api.tasks.ScanTask;
import dev.frankheijden.insights.api.utils.BlockUtils;
import dev.frankheijden.insights.api.utils.ChunkUtils;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Chunk;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockPistonEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;

public class PistonListener
extends InsightsListener {
    public PistonListener(InsightsPlugin plugin) {
        super(plugin);
    }

    @AllowPriorityOverride
    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onBlockPistonExtend(BlockPistonExtendEvent event) {
        this.handlePistonEvent((BlockPistonEvent)event, event.getBlocks());
    }

    @AllowPriorityOverride
    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onBlockPistonRetract(BlockPistonRetractEvent event) {
        this.handlePistonEvent((BlockPistonEvent)event, event.getBlocks());
    }

    private void handlePistonEvent(BlockPistonEvent event, List<Block> blocks) {
        for (Block block : blocks) {
            Block relative;
            if (!this.handlePistonBlock(block, relative = block.getRelative(event.getDirection()))) continue;
            event.setCancelled(true);
            break;
        }
    }

    private boolean handlePistonBlock(Block from, Block to) {
        Optional<Storage> storageOptional;
        boolean queued;
        Optional<Region> regionOptional = this.plugin.getAddonManager().getRegion(to.getLocation());
        if (regionOptional.isEmpty() && BlockUtils.isSameChunk(from, to)) {
            return false;
        }
        Material material = from.getType();
        Optional<Limit> limitOptional = this.plugin.getLimits().getFirstLimit(material, limit -> true);
        if (limitOptional.isEmpty()) {
            return false;
        }
        Chunk chunk = to.getChunk();
        UUID worldUid = chunk.getWorld().getUID();
        long chunkKey = ChunkUtils.getKey(chunk);
        if (regionOptional.isPresent()) {
            String key = regionOptional.get().getKey();
            queued = this.plugin.getAddonScanTracker().isQueued(key);
            storageOptional = this.plugin.getAddonStorage().get(key);
        } else {
            queued = this.plugin.getWorldChunkScanTracker().isQueued(worldUid, chunkKey);
            storageOptional = this.plugin.getWorldStorage().getWorld(worldUid).get(chunkKey);
        }
        if (queued) {
            return true;
        }
        if (storageOptional.isEmpty()) {
            if (regionOptional.isPresent()) {
                Region region = regionOptional.get();
                this.plugin.getAddonScanTracker().add(region.getAddon());
                List<ChunkPart> chunkParts = region.toChunkParts();
                ScanTask.scan(this.plugin, chunkParts, chunkParts.size(), ScanOptions.scanOnly(), info -> {}, storage -> {
                    this.plugin.getAddonScanTracker().remove(region.getAddon());
                    this.plugin.getAddonStorage().put(region.getKey(), (Storage)storage);
                });
            } else {
                this.plugin.getChunkContainerExecutor().submit(chunk);
            }
            return true;
        }
        Storage storage2 = storageOptional.get();
        Limit limit2 = limitOptional.get();
        LimitInfo limitInfo = limit2.getLimit(material);
        return storage2.count(limit2, ScanObject.of(material)) + 1L > (long)limitInfo.getLimit();
    }
}

