/*
 * Decompiled with CFR 0.152.
 */
package dev.frankheijden.insights.listeners;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import dev.frankheijden.insights.api.InsightsPlugin;
import dev.frankheijden.insights.api.listeners.InsightsListener;
import dev.frankheijden.insights.api.tasks.UpdateCheckerTask;
import dev.frankheijden.insights.api.utils.BlockUtils;
import dev.frankheijden.insights.api.utils.LocationUtils;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;

public class PlayerListener
extends InsightsListener {
    private final Cache<String, ExplodedBed> intentionalDesignBugs = CacheBuilder.newBuilder().expireAfterWrite(500L, TimeUnit.MILLISECONDS).build();

    public PlayerListener(InsightsPlugin plugin) {
        super(plugin);
    }

    public Optional<ExplodedBed> getIntentionalDesignBugAt(Location loc) {
        return Optional.ofNullable((ExplodedBed)this.intentionalDesignBugs.getIfPresent((Object)LocationUtils.getKey(loc)));
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        this.plugin.getPlayerList().addPlayer(player);
        if (player.hasPermission("insights.update")) {
            UpdateCheckerTask.check((CommandSender)player);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.plugin.getPlayerList().removePlayer(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Block block = event.getClickedBlock();
        if (block == null) {
            return;
        }
        Material material = block.getType();
        if (!Tag.BEDS.isTagged((Keyed)material)) {
            return;
        }
        if (block.getWorld().getEnvironment() == World.Environment.NORMAL) {
            return;
        }
        BlockUtils.getOtherHalf(block).ifPresent(otherHalf -> {
            Location location = block.getLocation();
            Location otherHalfLocation = otherHalf.getLocation();
            ExplodedBed explodedBed = new ExplodedBed(material, location, otherHalfLocation);
            this.intentionalDesignBugs.put((Object)LocationUtils.getKey(location), (Object)explodedBed);
            this.intentionalDesignBugs.put((Object)LocationUtils.getKey(otherHalfLocation), (Object)explodedBed);
        });
    }

    public static final class ExplodedBed {
        private final Material material;
        private final Location head;
        private final Location foot;

        private ExplodedBed(Material material, Location head, Location foot) {
            this.material = material;
            this.head = head;
            this.foot = foot;
        }

        public Material getMaterial() {
            return this.material;
        }

        public Location getHead() {
            return this.head;
        }

        public Location getFoot() {
            return this.foot;
        }
    }
}

