/*
 * Decompiled with CFR 0.152.
 */
package dev.frankheijden.insights.listeners.manager;

import dev.frankheijden.insights.Insights;
import dev.frankheijden.insights.api.annotations.AllowDisabling;
import dev.frankheijden.insights.api.annotations.AllowPriorityOverride;
import dev.frankheijden.insights.api.listeners.InsightsListener;
import dev.frankheijden.insights.api.listeners.manager.InsightsListenerManager;
import dev.frankheijden.insights.dependencies.paperlib.PaperLib;
import dev.frankheijden.insights.listeners.BlockListener;
import dev.frankheijden.insights.listeners.ChunkListener;
import dev.frankheijden.insights.listeners.EntityListener;
import dev.frankheijden.insights.listeners.PaperBlockListener;
import dev.frankheijden.insights.listeners.PaperEntityListener;
import dev.frankheijden.insights.listeners.PistonListener;
import dev.frankheijden.insights.listeners.PlayerListener;
import dev.frankheijden.insights.listeners.WorldListener;
import dev.frankheijden.insights.nms.core.ReflectionUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import org.bukkit.event.Event;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.plugin.EventExecutor;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredListener;

public class ListenerManager
implements InsightsListenerManager {
    private static final Map<String, Method> ALLOWED_DISABLE_EVENTS;
    private static final Map<String, Method> ALLOWED_PRIORITY_OVERRIDE_EVENTS;
    private final Insights plugin;
    private final PlayerListener playerListener;
    private final ChunkListener chunkListener;
    private final BlockListener blockListener;
    private final WorldListener worldListener;
    private final PaperEntityListener paperEntityListener;
    private final PaperBlockListener paperBlockListener;
    private final EntityListener entityListener;
    private final PistonListener pistonListener;

    private static Map<String, Method> getEventClassMap(List<Method> listenerMethods) {
        HashMap<String, Method> map = new HashMap<String, Method>();
        for (Method method : listenerMethods) {
            Class<?>[] params = method.getParameterTypes();
            if (params.length != 1 || !Event.class.isAssignableFrom(params[0])) continue;
            map.put(params[0].getSimpleName().toUpperCase(Locale.ENGLISH), method);
        }
        return Collections.unmodifiableMap(map);
    }

    public ListenerManager(Insights plugin) {
        this.plugin = plugin;
        this.playerListener = new PlayerListener(plugin);
        this.chunkListener = new ChunkListener(plugin);
        this.blockListener = new BlockListener(plugin);
        this.worldListener = new WorldListener(plugin);
        this.paperEntityListener = PaperLib.isPaper() ? new PaperEntityListener(plugin) : null;
        this.paperBlockListener = PaperLib.isPaper() ? new PaperBlockListener(plugin) : null;
        this.entityListener = PaperLib.isPaper() ? null : new EntityListener(plugin);
        this.pistonListener = new PistonListener(plugin);
    }

    @Override
    public void register() {
        HandlerList list;
        ArrayList<InsightsListener> listeners = new ArrayList<InsightsListener>();
        listeners.add(this.playerListener);
        listeners.add(this.chunkListener);
        ArrayList<InsightsListener> disableListeners = new ArrayList<InsightsListener>();
        disableListeners.add(this.blockListener);
        disableListeners.add(this.worldListener);
        if (!this.plugin.getSettings().REDSTONE_UPDATE_LIMITER_ENABLED) {
            BlockRedstoneEvent.getHandlerList().unregister((Listener)this.blockListener);
        }
        if (PaperLib.isPaper()) {
            listeners.add(this.paperEntityListener);
            disableListeners.add(this.paperBlockListener);
        } else {
            listeners.add(this.entityListener);
        }
        if (this.plugin.getSettings().APPLY_PISTON_LIMITS) {
            listeners.add(this.pistonListener);
        }
        listeners.addAll(disableListeners);
        listeners.forEach(listener -> this.plugin.getServer().getPluginManager().registerEvents((Listener)listener, (Plugin)this.plugin));
        Function<Class, HandlerList> getHandlerList = clazz -> {
            try {
                return (HandlerList)clazz.getMethod("getHandlerList", new Class[0]).invoke(null, new Object[0]);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
                throw new RuntimeException(ex);
            }
        };
        for (Class<? extends Event> clazz2 : this.plugin.getSettings().DISABLED_EVENTS) {
            list = getHandlerList.apply(clazz2);
            for (InsightsListener listener2 : disableListeners) {
                list.unregister((Listener)listener2);
            }
            this.plugin.getLogger().info("Unregistered listener of '" + clazz2.getSimpleName() + "'");
        }
        for (Map.Entry entry : this.plugin.getSettings().LISTENER_PRIORITIES.entrySet()) {
            if (entry.getValue() == EventPriority.LOWEST) continue;
            list = getHandlerList.apply((Class)entry.getKey());
            ArrayList<RegisteredListener> listenersToUnregister = new ArrayList<RegisteredListener>();
            ArrayList<RegisteredListener> listenersToRegister = new ArrayList<RegisteredListener>();
            for (RegisteredListener listener3 : list.getRegisteredListeners()) {
                if (!this.plugin.equals(listener3.getPlugin()) || listener3.getPriority() != EventPriority.LOWEST) continue;
                listenersToUnregister.add(listener3);
                String event = ((Class)entry.getKey()).getSimpleName();
                String eventUppercase = event.toUpperCase(Locale.ENGLISH);
                listenersToRegister.add(new RegisteredListener(listener3.getListener(), EventExecutor.create((Method)ALLOWED_PRIORITY_OVERRIDE_EVENTS.get(eventUppercase), (Class)((Class)entry.getKey())), (EventPriority)entry.getValue(), (Plugin)this.plugin, listener3.isIgnoringCancelled()));
                this.plugin.getLogger().info("Remapped EventPriority of '" + event + "' to '" + String.valueOf(entry.getValue()) + "'");
            }
            listenersToUnregister.forEach(arg_0 -> ((HandlerList)list).unregister(arg_0));
            listenersToRegister.forEach(arg_0 -> ((HandlerList)list).register(arg_0));
        }
        if (!this.plugin.getSettings().REDSTONE_UPDATE_LIMITER_ENABLED) {
            BlockRedstoneEvent.getHandlerList().unregister((Listener)this.blockListener);
        }
    }

    @Override
    public void unregister() {
        HandlerList.unregisterAll((Listener)this.playerListener);
        HandlerList.unregisterAll((Listener)this.chunkListener);
        HandlerList.unregisterAll((Listener)this.blockListener);
        HandlerList.unregisterAll((Listener)this.worldListener);
        if (this.paperEntityListener != null) {
            HandlerList.unregisterAll((Listener)this.paperEntityListener);
        }
        if (this.paperBlockListener != null) {
            HandlerList.unregisterAll((Listener)this.paperBlockListener);
        }
        if (this.entityListener != null) {
            HandlerList.unregisterAll((Listener)this.entityListener);
        }
        HandlerList.unregisterAll((Listener)this.pistonListener);
    }

    @Override
    public Map<String, Method> getAllowedDisableMethods() {
        return ALLOWED_DISABLE_EVENTS;
    }

    @Override
    public Map<String, Method> getAllowedPriorityOverrideMethods() {
        return ALLOWED_PRIORITY_OVERRIDE_EVENTS;
    }

    public PlayerListener getPlayerListener() {
        return this.playerListener;
    }

    static {
        ArrayList<Method> disableMethods = new ArrayList<Method>();
        disableMethods.addAll(ReflectionUtils.getAnnotatedMethods(BlockListener.class, AllowDisabling.class));
        disableMethods.addAll(ReflectionUtils.getAnnotatedMethods(WorldListener.class, AllowDisabling.class));
        if (PaperLib.isPaper()) {
            disableMethods.addAll(ReflectionUtils.getAnnotatedMethods(PaperBlockListener.class, AllowDisabling.class));
        }
        ALLOWED_DISABLE_EVENTS = ListenerManager.getEventClassMap(disableMethods);
        ArrayList<Method> priorityMethods = new ArrayList<Method>();
        priorityMethods.addAll(ReflectionUtils.getAnnotatedMethods(BlockListener.class, AllowPriorityOverride.class));
        priorityMethods.addAll(ReflectionUtils.getAnnotatedMethods(EntityListener.class, AllowPriorityOverride.class));
        priorityMethods.addAll(ReflectionUtils.getAnnotatedMethods(PistonListener.class, AllowPriorityOverride.class));
        ALLOWED_PRIORITY_OVERRIDE_EVENTS = ListenerManager.getEventClassMap(priorityMethods);
    }
}

