/*
 * Decompiled with CFR 0.152.
 */
package dev.frankheijden.insights.nms.current;

import ca.spottedleaf.concurrentutil.util.Priority;
import ca.spottedleaf.moonrise.patches.chunk_system.io.MoonriseRegionFileIO;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import dev.frankheijden.insights.nms.core.ChunkEntity;
import dev.frankheijden.insights.nms.core.InsightsNMS;
import java.io.IOException;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.DataPaletteBlock;
import net.minecraft.world.level.chunk.Strategy;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import org.bukkit.Chunk;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_21_R6.CraftChunk;
import org.bukkit.craftbukkit.v1_21_R6.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftMagicNumbers;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;

public class InsightsNMSImpl
extends InsightsNMS {
    @Override
    public void getLoadedChunkSections(Chunk chunk, Consumer<dev.frankheijden.insights.nms.core.ChunkSection> sectionConsumer) {
        ChunkSection[] levelChunkSections = ((CraftChunk)chunk).getHandle(ChunkStatus.n).d();
        for (int i = 0; i < levelChunkSections.length; ++i) {
            sectionConsumer.accept(new ChunkSectionImpl(levelChunkSections[i], i));
        }
    }

    @Override
    public void getUnloadedChunkSections(World world, int chunkX, int chunkZ, Consumer<dev.frankheijden.insights.nms.core.ChunkSection> sectionConsumer) {
        int i;
        WorldServer serverLevel = ((CraftWorld)world).getHandle();
        int sectionsCount = serverLevel.as();
        PlayerChunkMap chunkMap = serverLevel.n().a;
        ChunkCoordIntPair chunkPos = new ChunkCoordIntPair(chunkX, chunkZ);
        Optional tagOptional = (Optional)chunkMap.d(chunkPos).join();
        if (tagOptional.isEmpty()) {
            return;
        }
        NBTTagCompound tag = (NBTTagCompound)tagOptional.get();
        Optional optionalSectionsTagList = tag.o("sections");
        if (optionalSectionsTagList.isEmpty()) {
            logger.severe(String.format("Recoverable errors when loading section [%d, %d, %d]: %s", chunkX, 0, chunkZ, "Sections tag is missing"));
            return;
        }
        NBTTagList sectionsTagList = (NBTTagList)optionalSectionsTagList.get();
        int nonNullSectionCount = 0;
        for (i = 0; i < sectionsTagList.size(); ++i) {
            DataPaletteBlock blockStateContainer;
            Optional optionalSectionTag = sectionsTagList.a(i);
            if (optionalSectionTag.isEmpty()) {
                logger.severe(String.format("Recoverable errors when loading section [%d, %d, %d]: %s", chunkX, i, chunkZ, "Section tag is missing"));
                continue;
            }
            NBTTagCompound sectionTag = (NBTTagCompound)optionalSectionTag.get();
            Byte chunkSectionPart = (Byte)sectionTag.c("Y").orElseThrow();
            int sectionIndex = serverLevel.g((int)chunkSectionPart.byteValue());
            if (sectionIndex < 0 || sectionIndex >= sectionsCount) continue;
            Strategy strategy = serverLevel.ao().c();
            if (sectionTag.b("block_states")) {
                Codec blockStateCodec = DataPaletteBlock.codecRW((Codec)IBlockData.a, (Strategy)strategy, (Object)Blocks.a.m(), (Object[])new IBlockData[0]);
                DataResult dataResult = blockStateCodec.parse((DynamicOps)DynamicOpsNBT.a, (Object)((NBTBase)sectionTag.m("block_states").orElseThrow())).promotePartial(message -> logger.severe(String.format("Recoverable errors when loading section [%d, %d, %d]: %s", chunkX, chunkSectionPart, chunkZ, message)));
                try {
                    blockStateContainer = (DataPaletteBlock)dataResult.getOrThrow();
                }
                catch (IllegalStateException ex) {
                    logger.severe(ex.getMessage());
                    throw ex;
                }
            } else {
                blockStateContainer = new DataPaletteBlock((Object)Blocks.a.m(), strategy, (Object[])new IBlockData[0]);
            }
            ChunkSection chunkSection = new ChunkSection(blockStateContainer, null);
            sectionConsumer.accept(new ChunkSectionImpl(chunkSection, sectionIndex));
            ++nonNullSectionCount;
        }
        for (i = nonNullSectionCount; i < sectionsCount; ++i) {
            sectionConsumer.accept(null);
        }
    }

    @Override
    public void getLoadedChunkEntities(Chunk chunk, Consumer<ChunkEntity> entityConsumer) {
        for (Entity bukkitEntity : chunk.getEntities()) {
            net.minecraft.world.entity.Entity entity = ((CraftEntity)bukkitEntity).getHandle();
            entityConsumer.accept(new ChunkEntity(bukkitEntity.getType(), entity.dJ(), entity.dL(), entity.dP()));
        }
    }

    @Override
    public void getUnloadedChunkEntities(World world, int chunkX, int chunkZ, Consumer<ChunkEntity> entityConsumer) throws IOException {
        WorldServer serverLevel = ((CraftWorld)world).getHandle();
        NBTTagCompound tag = MoonriseRegionFileIO.loadData((WorldServer)serverLevel, (int)chunkX, (int)chunkZ, (MoonriseRegionFileIO.RegionFileType)MoonriseRegionFileIO.RegionFileType.ENTITY_DATA, (Priority)Priority.BLOCKING);
        if (tag == null) {
            return;
        }
        this.readChunkEntities((NBTTagList)tag.o("Entities").orElseThrow(), entityConsumer);
    }

    private void readChunkEntities(NBTTagList listTag, Consumer<ChunkEntity> entityConsumer) {
        for (NBTBase tag : listTag) {
            this.readChunkEntities((NBTTagCompound)tag, entityConsumer);
        }
    }

    private void readChunkEntities(NBTTagCompound nbt, Consumer<ChunkEntity> entityConsumer) {
        Optional typeOptional = EntityTypes.a((String)((String)nbt.i("id").orElseThrow()));
        if (typeOptional.isPresent()) {
            String entityTypeName = EntityTypes.a((EntityTypes)((EntityTypes)typeOptional.get())).a();
            NBTTagList posList = (NBTTagList)nbt.o("Pos").orElseThrow();
            entityConsumer.accept(new ChunkEntity(EntityType.fromName((String)entityTypeName), MathHelper.a((double)MathHelper.a((double)((Double)posList.k(0).orElseThrow()), (double)-3.0E7, (double)3.0E7)), MathHelper.a((double)MathHelper.a((double)((Double)posList.k(1).orElseThrow()), (double)-2.0E7, (double)2.0E7)), MathHelper.a((double)MathHelper.a((double)((Double)posList.k(2).orElseThrow()), (double)-3.0E7, (double)3.0E7))));
        }
        if (nbt.b("Passengers")) {
            this.readChunkEntities((NBTTagList)nbt.o("Passengers").orElseThrow(), entityConsumer);
        }
    }

    public static class ChunkSectionImpl
    implements dev.frankheijden.insights.nms.core.ChunkSection {
        private final ChunkSection chunkSection;
        private final int index;

        public ChunkSectionImpl(ChunkSection chunkSection, int index) {
            this.chunkSection = chunkSection;
            this.index = index;
        }

        @Override
        public int index() {
            return this.index;
        }

        @Override
        public boolean isNull() {
            return this.chunkSection == null;
        }

        @Override
        public Material blockAt(int x, int y, int z) {
            return CraftMagicNumbers.getMaterial((Block)this.chunkSection.a(x, y, z).b());
        }

        @Override
        public void countBlocks(BiConsumer<Material, Integer> consumer) {
            this.chunkSection.h().a((state, count) -> consumer.accept(CraftMagicNumbers.getMaterial((Block)state.b()), count));
        }
    }
}

