/*
 * Decompiled with CFR 0.152.
 */
package dev.frankheijden.insights.tasks;

import dev.frankheijden.insights.api.InsightsPlugin;
import dev.frankheijden.insights.api.concurrent.ScanOptions;
import dev.frankheijden.insights.api.concurrent.storage.WorldStorage;
import dev.frankheijden.insights.api.objects.chunk.ChunkLocation;
import dev.frankheijden.insights.api.tasks.InsightsAsyncTask;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class PlayerTrackerTask
extends InsightsAsyncTask {
    private final Map<ChunkLocation, Long> scanLocations = new ConcurrentHashMap<ChunkLocation, Long>();
    private static final Set<Integer> knownErrorStackTraceHashes = ConcurrentHashMap.newKeySet();

    public PlayerTrackerTask(InsightsPlugin plugin) {
        super(plugin);
    }

    @Override
    public void run() {
        WorldStorage worldStorage = this.plugin.getWorldStorage();
        HashSet<ChunkLocation> locations = new HashSet<ChunkLocation>();
        for (Map.Entry<UUID, Player> entry : this.plugin.getPlayerList()) {
            Location location = entry.getValue().getLocation();
            World world = location.getWorld();
            Set<Long> loadedChunks = worldStorage.getWorld(world.getUID()).getChunks();
            int chunkX = location.getBlockX() >> 4;
            int chunkZ = location.getBlockZ() >> 4;
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    ChunkLocation loc = new ChunkLocation(world, chunkX + x, chunkZ + z);
                    if (loadedChunks.contains(loc.getKey()) || this.scanLocations.containsKey(loc)) continue;
                    locations.add(loc);
                }
            }
        }
        if (locations.isEmpty()) {
            return;
        }
        this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> {
            long now = System.nanoTime();
            for (ChunkLocation loc : locations) {
                World world = loc.getWorld();
                if (!world.isChunkLoaded(loc.getX(), loc.getZ())) continue;
                this.scanLocations.put(loc, now);
                Chunk chunk = world.getChunkAt(loc.getX(), loc.getZ());
                this.plugin.getChunkContainerExecutor().submit(chunk, ScanOptions.all()).whenComplete((s, e) -> {
                    int hash;
                    if (s == null && !knownErrorStackTraceHashes.contains(hash = e.getStackTrace()[0].hashCode())) {
                        knownErrorStackTraceHashes.add(hash);
                        this.plugin.getLogger().log(Level.SEVERE, "Error occurred while scanning " + String.valueOf(loc) + " (future errors with the same stacktrace are suppressed)", (Throwable)e);
                    }
                    this.scanLocations.remove(loc);
                });
            }
        });
    }
}

