package com.github.kd_gaming1.packcore.command.packcore;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.context.CommandContext;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_124;
import net.minecraft.class_2561;

public class PackCoreCommand {

    public static void registerCommands(CommandDispatcher<FabricClientCommandSource> dispatcher) {
        dispatcher.register(ClientCommandManager.literal("packcore")
                .executes(PackCoreCommand::showQuickHelp)
                .then(HelpCommand.register())
                .then(WizardCommand.register())
                .then(MenuCommand.register())
                .then(GuideCommand.register())
                .then(ConfigManagerCommand.register())
                .then(StatusCommand.register())
                .then(PerformanceCommand.register())
                .then(TabDesignCommand.register())
        );
    }

    private static int showQuickHelp(CommandContext<FabricClientCommandSource> context) {
        var source = context.getSource();

        source.sendFeedback(class_2561.method_43470("PackCore Commands").method_27695(class_124.field_1065, class_124.field_1067));
        source.sendFeedback(class_2561.method_43470("Type ").method_27692(class_124.field_1080)
                .method_10852(class_2561.method_43470("/packcore help").method_27692(class_124.field_1060))
                .method_10852(class_2561.method_43470(" for full command list").method_27692(class_124.field_1080)));
        source.sendFeedback(class_2561.method_43470(""));
        source.sendFeedback(class_2561.method_43470("Quick Commands:").method_27692(class_124.field_1054));
        source.sendFeedback(class_2561.method_43470("  • ").method_27692(class_124.field_1080)
                .method_10852(class_2561.method_43470("/packcore wizard").method_27692(class_124.field_1060))
                .method_10852(class_2561.method_43470(" - Open setup wizard").method_27692(class_124.field_1080)));
        source.sendFeedback(class_2561.method_43470("  • ").method_27692(class_124.field_1080)
                .method_10852(class_2561.method_43470("/packcore menu toggle").method_27692(class_124.field_1060))
                .method_10852(class_2561.method_43470(" - Toggle custom menu").method_27692(class_124.field_1080)));
        source.sendFeedback(class_2561.method_43470("  • ").method_27692(class_124.field_1080)
                .method_10852(class_2561.method_43470("/packcore configmanager").method_27692(class_124.field_1060))
                .method_10852(class_2561.method_43470(" - Open config manager").method_27692(class_124.field_1080)));

        return 1;
    }
}