package com.github.kd_gaming1.packcore.command.packcore;

import com.github.kd_gaming1.packcore.PackCore;
import com.github.kd_gaming1.packcore.config.PackCoreConfig;
import com.github.kd_gaming1.packcore.config.storage.ConfigFileRepository;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_124;
import net.minecraft.class_2561;

public class StatusCommand {

    public static LiteralArgumentBuilder<FabricClientCommandSource> register() {
        return ClientCommandManager.literal("status").executes(StatusCommand::execute);
    }

    private static int execute(CommandContext<FabricClientCommandSource> context) {
        var source = context.getSource();
        var modpackInfo = PackCore.getModpackInfo();
        var currentConfig = ConfigFileRepository.getCurrentConfig();

        source.sendFeedback(class_2561.method_43470("=== PackCore Status ===").method_27692(class_124.field_1065));
        source.sendFeedback(class_2561.method_43470("Modpack: " + modpackInfo.getName() + " v" + modpackInfo.getVersion()));
        source.sendFeedback(class_2561.method_43470("Active Config: " + currentConfig.getName() + " v" + currentConfig.getVersion()));
        source.sendFeedback(class_2561.method_43470("Custom Menu: " + (PackCoreConfig.enableCustomMenu ? "Enabled" : "Disabled")));
        source.sendFeedback(class_2561.method_43470("Config Applied: " + (PackCoreConfig.defaultConfigSuccessfullyApplied ? "Yes" : "No")));

        return 1;
    }
}