package com.github.kd_gaming1.packcore.command.packcore;

import com.github.kd_gaming1.packcore.PackCore;
import com.github.kd_gaming1.packcore.ui.screen.wizard.pages.WelcomeWizardPage;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;

public class WizardCommand {

    public static LiteralArgumentBuilder<FabricClientCommandSource> register() {
        return ClientCommandManager.literal("wizard")
                .executes(WizardCommand::openWizard);
    }

    private static int openWizard(CommandContext<FabricClientCommandSource> context) {
        class_310 client = context.getSource().getClient();

        if (client == null) {
            context.getSource().sendError(class_2561.method_43470("Unable to access Minecraft client"));
            return 0;
        }

        context.getSource().sendFeedback(class_2561.method_43470("Opening setup wizard...")
                .method_27692(class_124.field_1060));

        client.method_63588(() -> {
            try {
                client.method_1507(new WelcomeWizardPage());
            } catch (Exception e) {
                PackCore.LOGGER.error("Failed to open wizard: {}", e.getMessage());
            }
        });

        return 1;
    }
}