package com.github.kd_gaming1.packcore.command.scamshield;

import com.github.kd_gaming1.packcore.PackCore;
import com.github.kd_gaming1.packcore.config.PackCoreConfig;
import com.github.kd_gaming1.packcore.scamshield.detector.types.ScamType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2561;
import java.util.List;

/**
 * Commands for controlling ScamShield system state.
 */
public class ScamShieldControlCommands {

    public static LiteralArgumentBuilder<FabricClientCommandSource> registerToggle() {
        return ClientCommandManager.literal("toggle").executes(ScamShieldControlCommands::toggleScamShield);
    }

    public static LiteralArgumentBuilder<FabricClientCommandSource> registerReload() {
        return ClientCommandManager.literal("reload").executes(ScamShieldControlCommands::reloadPatterns);
    }

    private static int toggleScamShield(CommandContext<FabricClientCommandSource> context) {
        PackCoreConfig.enableScamShield = !PackCoreConfig.enableScamShield;
        PackCoreConfig.write(PackCore.MOD_ID);

        String status = PackCoreConfig.enableScamShield ? "§aenabled" : "§cdisabled";
        context.getSource().sendFeedback(
                class_2561.method_43470("§e[ScamShield] §7System " + status)
        );
        return 1;
    }

    private static int reloadPatterns(CommandContext<FabricClientCommandSource> context) {
        context.getSource().sendFeedback(
                class_2561.method_43470("§e[ScamShield] §7Reloading pattern files and scanning for new scam types...")
        );

        try {
            int loadedCount = PackCore.getScamDetector().reloadScamTypes();

            context.getSource().sendFeedback(
                    class_2561.method_43470("§a[ScamShield] ✓ Reload complete!")
            );
            context.getSource().sendFeedback(
                    class_2561.method_43470("§7Loaded §f" + loadedCount + "§7 scam detectors")
            );
            context.getSource().sendFeedback(
                    class_2561.method_43470("§7━━━━━━━━━━━━━━━━━━━━━━━━━━━━")
            );

            // Show loaded scam types
            List<ScamType> scamTypes = PackCore.getScamDetector().getScamTypes();
            context.getSource().sendFeedback(
                    class_2561.method_43470("§e[Active Scam Detectors]")
            );

            for (ScamType scamType : scamTypes) {
                String status = scamType.isEnabled() ? "§a✓" : "§c✗";
                context.getSource().sendFeedback(
                        class_2561.method_43470("§7  " + status + " §f" + scamType.getDisplayName())
                );
            }

            context.getSource().sendFeedback(
                    class_2561.method_43470("§7━━━━━━━━━━━━━━━━━━━━━━━━━━━━")
            );
            context.getSource().sendFeedback(
                    class_2561.method_43470("§7Tip: Drop new §escamtype-*.json§7 files in the folder and reload!")
            );

            return 1;
        } catch (Exception e) {
            context.getSource().sendError(
                    class_2561.method_43470("§c[ScamShield] Failed to reload: " + e.getMessage())
            );
            return 0;
        }
    }
}