package com.github.kd_gaming1.packcore.command.scamshield;

import com.github.kd_gaming1.packcore.PackCore;
import com.github.kd_gaming1.packcore.config.PackCoreConfig;
import com.github.kd_gaming1.packcore.scamshield.ScamWarningMessageBuilder;
import com.github.kd_gaming1.packcore.scamshield.ScamShieldScreenIntegration;
import com.github.kd_gaming1.packcore.scamshield.detector.ConfidenceLevel;
import com.github.kd_gaming1.packcore.scamshield.detector.DetectionResult;
import com.github.kd_gaming1.packcore.scamshield.detector.ScamCategory;
import com.github.kd_gaming1.packcore.ui.screen.scamshield.ScamWarningScreen;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2561;
import net.minecraft.class_310;

/**
 * Commands for previewing ScamShield warnings and screens.
 */
public class ScamShieldPreviewCommands {

    public static LiteralArgumentBuilder<FabricClientCommandSource> register() {
        return ClientCommandManager.literal("preview")
                .then(registerLowPreview())
                .then(registerMediumPreview())
                .then(registerHighPreview())
                .then(ClientCommandManager.literal("screen")
                        .executes(ScamShieldPreviewCommands::previewWarningScreen)
                );
    }

    private static LiteralArgumentBuilder<FabricClientCommandSource> registerLowPreview() {
        return ClientCommandManager.literal("low")
                .then(ClientCommandManager.literal("phishing")
                        .executes(ctx -> previewWarning(ctx, ConfidenceLevel.LOW, ScamCategory.PHISHING))
                )
                .then(ClientCommandManager.literal("giveaway")
                        .executes(ctx -> previewWarning(ctx, ConfidenceLevel.LOW, ScamCategory.FAKE_REWARD))
                )
                .then(ClientCommandManager.literal("coop")
                        .executes(ctx -> previewWarning(ctx, ConfidenceLevel.LOW, ScamCategory.ACCOUNT_THEFT))
                )
                .then(ClientCommandManager.literal("generic")
                        .executes(ctx -> previewWarning(ctx, ConfidenceLevel.LOW, ScamCategory.CUSTOM))
                );
    }

    private static LiteralArgumentBuilder<FabricClientCommandSource> registerMediumPreview() {
        return ClientCommandManager.literal("medium")
                .then(ClientCommandManager.literal("phishing")
                        .executes(ctx -> previewWarning(ctx, ConfidenceLevel.MEDIUM, ScamCategory.PHISHING))
                )
                .then(ClientCommandManager.literal("giveaway")
                        .executes(ctx -> previewWarning(ctx, ConfidenceLevel.MEDIUM, ScamCategory.FAKE_REWARD))
                )
                .then(ClientCommandManager.literal("coop")
                        .executes(ctx -> previewWarning(ctx, ConfidenceLevel.MEDIUM, ScamCategory.ACCOUNT_THEFT))
                )
                .then(ClientCommandManager.literal("trade")
                        .executes(ctx -> previewWarning(ctx, ConfidenceLevel.MEDIUM, ScamCategory.TRADE_MANIPULATION))
                )
                .then(ClientCommandManager.literal("generic")
                        .executes(ctx -> previewWarning(ctx, ConfidenceLevel.MEDIUM, ScamCategory.CUSTOM))
                );
    }

    private static LiteralArgumentBuilder<FabricClientCommandSource> registerHighPreview() {
        return ClientCommandManager.literal("high")
                .then(ClientCommandManager.literal("phishing")
                        .executes(ctx -> previewWarning(ctx, ConfidenceLevel.HIGH, ScamCategory.PHISHING))
                )
                .then(ClientCommandManager.literal("giveaway")
                        .executes(ctx -> previewWarning(ctx, ConfidenceLevel.HIGH, ScamCategory.FAKE_REWARD))
                )
                .then(ClientCommandManager.literal("coop")
                        .executes(ctx -> previewWarning(ctx, ConfidenceLevel.HIGH, ScamCategory.ACCOUNT_THEFT))
                )
                .then(ClientCommandManager.literal("trade")
                        .executes(ctx -> previewWarning(ctx, ConfidenceLevel.HIGH, ScamCategory.TRADE_MANIPULATION))
                )
                .then(ClientCommandManager.literal("generic")
                        .executes(ctx -> previewWarning(ctx, ConfidenceLevel.HIGH, ScamCategory.CUSTOM))
                );
    }

    private static int previewWarning(CommandContext<FabricClientCommandSource> context,
                                      ConfidenceLevel level, ScamCategory category) {
        FabricClientCommandSource source = context.getSource();
        class_310 client = class_310.method_1551();

        if (client.field_1724 == null) {
            source.sendError(class_2561.method_43470("§c[ScamShield] Must be in-game to preview warnings"));
            return 0;
        }

        source.sendFeedback(class_2561.method_43470("§7━━━━━━━━━━━━━━━━━━━━━━━━━━━━"));
        source.sendFeedback(class_2561.method_43470("§e[Preview Mode] " + level.getDisplayName() + " Confidence - " + category.getDisplayName()));
        source.sendFeedback(class_2561.method_43470("§7━━━━━━━━━━━━━━━━━━━━━━━━━━━━"));
        source.sendFeedback(class_2561.method_43470(""));

        // Create a mock detection result
        DetectionResult.Builder builder = new DetectionResult.Builder(
                "Example scam message for preview",
                "PreviewScammer",
                PackCoreConfig.scamShieldTriggerThreshold
        );

        // Add score to match the confidence level
        builder.addScamTypeContribution(category.getScamTypeId(), level.getMinScore());

        DetectionResult mockResult = builder.build();

        // Build and send the warning message
        class_2561 warningMessage = ScamWarningMessageBuilder.buildWarningMessage(mockResult);
        client.field_1724.method_7353(warningMessage, false);

        source.sendFeedback(class_2561.method_43470(""));
        source.sendFeedback(class_2561.method_43470("§7━━━━━━━━━━━━━━━━━━━━━━━━━━━━"));
        source.sendFeedback(class_2561.method_43470("§7This is a preview. Real detections will look like this."));

        return 1;
    }

    private static int previewWarningScreen(CommandContext<FabricClientCommandSource> context) {
        FabricClientCommandSource source = context.getSource();
        class_310 client = class_310.method_1551();

        if (client.field_1724 == null) {
            source.sendError(class_2561.method_43470("§c[ScamShield] Must be in-game to preview screen"));
            return 0;
        }

        source.sendFeedback(class_2561.method_43470("§e[ScamShield] §7Opening warning screen preview..."));

        // Create a mock HIGH confidence detection
        DetectionResult.Builder builder = new DetectionResult.Builder(
                "join my discord to verify your account and get free rewards!",
                "PreviewScammer",
                PackCoreConfig.scamShieldTriggerThreshold
        );

        builder.addScamTypeContribution("discord_verify_scam", 150);
        builder.addScamTypeContribution("credential_fishing", 100);

        DetectionResult mockResult = builder.build();

        // Open the warning screen
        try {
            ScamWarningScreen.ScamWarning warning =
                    ScamShieldScreenIntegration.convertToWarning(mockResult);

            ScamWarningScreen warningScreen =
                    new ScamWarningScreen(warning, () -> {
                        source.sendFeedback(class_2561.method_43470("§a[ScamShield] Preview screen dismissed"));
                    });

            client.method_63588(() -> client.method_1507(warningScreen));

        } catch (Exception e) {
            source.sendError(class_2561.method_43470("§c[ScamShield] Failed to open preview screen: " + e.getMessage()));
            PackCore.LOGGER.error("[ScamShield] Preview screen error", e);
            return 0;
        }

        return 1;
    }
}