package com.github.kd_gaming1.packcore.command.scamshield;

import com.github.kd_gaming1.packcore.scamshield.ScamShieldWhitelist;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2561;

/**
 * Commands for managing the ScamShield whitelist.
 */
public class ScamShieldWhitelistCommands {

    public static LiteralArgumentBuilder<FabricClientCommandSource> register() {
        return ClientCommandManager.literal("whitelist")
                .then(ClientCommandManager.literal("add")
                        .then(ClientCommandManager.argument("player", StringArgumentType.word())
                                .executes(ScamShieldWhitelistCommands::whitelistAdd)
                        )
                )
                .then(ClientCommandManager.literal("remove")
                        .then(ClientCommandManager.argument("player", StringArgumentType.word())
                                .executes(ScamShieldWhitelistCommands::whitelistRemove)
                        )
                )
                .then(ClientCommandManager.literal("list")
                        .executes(ScamShieldWhitelistCommands::whitelistList)
                )
                .then(ClientCommandManager.literal("clear")
                        .executes(ScamShieldWhitelistCommands::whitelistClear)
                );
    }

    private static int whitelistAdd(CommandContext<FabricClientCommandSource> context) {
        String player = StringArgumentType.getString(context, "player");
        FabricClientCommandSource source = context.getSource();

        boolean added = ScamShieldWhitelist.getInstance().add(player);

        if (added) {
            source.sendFeedback(
                    class_2561.method_43470("§a[ScamShield] ✓ Added §f" + player + "§a to whitelist")
            );
            return 1;
        } else {
            source.sendError(
                    class_2561.method_43470("§c[ScamShield] Player already whitelisted")
            );
            return 0;
        }
    }

    private static int whitelistRemove(CommandContext<FabricClientCommandSource> context) {
        String player = StringArgumentType.getString(context, "player");
        FabricClientCommandSource source = context.getSource();

        boolean removed = ScamShieldWhitelist.getInstance().remove(player);

        if (removed) {
            source.sendFeedback(
                    class_2561.method_43470("§a[ScamShield] ✓ Removed §f" + player + "§a from whitelist")
            );
            return 1;
        } else {
            source.sendError(
                    class_2561.method_43470("§c[ScamShield] Player not in whitelist")
            );
            return 0;
        }
    }

    private static int whitelistList(CommandContext<FabricClientCommandSource> context) {
        FabricClientCommandSource source = context.getSource();
        var whitelist = ScamShieldWhitelist.getInstance().getWhitelistedPlayers();

        source.sendFeedback(class_2561.method_43470("§7━━━━━━━━━━━━━━━━━━━━━━━━━━━━"));
        source.sendFeedback(class_2561.method_43470("§e[ScamShield Whitelist]"));
        source.sendFeedback(class_2561.method_43470(""));

        if (whitelist.isEmpty()) {
            source.sendFeedback(class_2561.method_43470("§7No whitelisted players"));
        } else {
            source.sendFeedback(
                    class_2561.method_43470("§7Whitelisted Players: §f" + whitelist.size())
            );
            source.sendFeedback(class_2561.method_43470(""));
            whitelist.forEach(player -> {
                source.sendFeedback(class_2561.method_43470("§7  • §f" + player));
            });
        }

        source.sendFeedback(class_2561.method_43470("§7━━━━━━━━━━━━━━━━━━━━━━━━━━━━"));
        return 1;
    }

    private static int whitelistClear(CommandContext<FabricClientCommandSource> context) {
        ScamShieldWhitelist.getInstance().clear();
        context.getSource().sendFeedback(
                class_2561.method_43470("§a[ScamShield] ✓ Whitelist cleared")
        );
        return 1;
    }
}