package com.github.kd_gaming1.packcore.notification;

import com.github.kd_gaming1.packcore.PackCore;
import com.github.kd_gaming1.packcore.config.PackCoreConfig;
import com.github.kd_gaming1.packcore.ui.toast.PackCoreToast;
import com.github.kd_gaming1.packcore.util.update.UpdateResult;
import com.github.kd_gaming1.packcore.modpack.ModpackInfo;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_746;
import java.net.URI;
import java.util.HashSet;
import java.util.Set;

public class UpdateNotifier {
    private static final long MAIN_MENU_TOAST_COOLDOWN_MS = 300_000; // 5 minutes for main menu
    private static final Set<String> shownVersionsThisSession = new HashSet<>();
    private static long lastMainMenuToastTime = 0;
    private static boolean hasShownInGameNotificationThisSession = false;

    static {
        // Register event for in-game notifications
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> {
            if (!hasShownInGameNotificationThisSession) {
                checkAndShowInGameNotification();
            }
        });
    }

    public static boolean shouldShowMainMenuToast(String newVersion) {
        long now = System.currentTimeMillis();
        return !shownVersionsThisSession.contains(newVersion) &&
                (now - lastMainMenuToastTime > MAIN_MENU_TOAST_COOLDOWN_MS);
    }

    public static void showMainMenuToast(String currentVersion, String newVersion, String modpackName) {
        PackCoreToast.showUpdateAvailable(currentVersion, newVersion, modpackName);
        shownVersionsThisSession.add(newVersion);
        lastMainMenuToastTime = System.currentTimeMillis();
    }

    private static void checkAndShowInGameNotification() {
        ModpackInfo info = PackCore.getModpackInfo();
        if (info == null || !PackCoreConfig.enableUpdateNotifications) return;

        UpdateResult result = PackCore.getUpdateManager().checkForUpdates(info);
        if (result.isSuccess() && result.isUpdateAvailable()) {
            showInGameChatMessage(info.getVersion(), result.getVersionNumber(),
                    result.getModrinthUrl(), info.getName());
            hasShownInGameNotificationThisSession = true;
        }
    }

    private static void showInGameChatMessage(String currentVersion, String newVersion,
                                              String modrinthUrl, String modpackName) {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) return;

        try {
            URI uri = URI.create(modrinthUrl);
            class_2558 clickEvent = new class_2558.class_10608(uri);

            class_2561 updateMessage = class_2561.method_43470("[" + modpackName + "] ")
                    .method_27695(class_124.field_1065, class_124.field_1067)
                    .method_10852(class_2561.method_43470("Update available! ").method_27692(class_124.field_1054))
                    .method_10852(class_2561.method_43470(currentVersion + " → " + newVersion + " ").method_27692(class_124.field_1068))
                    .method_10852(class_2561.method_43470("[Click to view]").method_27695(class_124.field_1075, class_124.field_1073)
                            .method_27694(style -> style.method_10958(clickEvent)));

            player.method_7353(updateMessage, false);
        } catch (IllegalArgumentException e) {
            PackCore.LOGGER.error("Invalid Modrinth URL: {}", modrinthUrl, e);
        }
    }
}