/*
 * Decompiled with CFR 0.152.
 */
package com.github.kd_gaming1.packcore.config.update;

import com.github.kd_gaming1.packcore.config.backup.BackupManager;
import com.github.kd_gaming1.packcore.util.GsonUtils;
import com.github.kd_gaming1.packcore.util.io.zip.UnzipService;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigUpdateService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigUpdateService.class);
    private static final Gson GSON = GsonUtils.GSON;
    private static final String UPDATES_FOLDER = "packcore/updates";
    private static final String APPLIED_UPDATES_FILE = "packcore/applied_updates.json";
    private static final String UPDATE_MANIFEST_FILE = "update_manifest.json";

    public static void checkAndApplyUpdates(Path gameDir) {
        LOGGER.info("Checking for config updates...");
        Path updatesFolder = gameDir.resolve(UPDATES_FOLDER);
        if (!Files.exists(updatesFolder, new LinkOption[0])) {
            try {
                Files.createDirectories(updatesFolder, new FileAttribute[0]);
                LOGGER.info("Created updates folder: {}", (Object)updatesFolder);
                ConfigUpdateService.createReadmeFile(updatesFolder);
            }
            catch (IOException e) {
                LOGGER.error("Failed to create updates folder", (Throwable)e);
            }
            return;
        }
        AppliedUpdatesRecord appliedRecord = ConfigUpdateService.loadAppliedUpdates(gameDir);
        List<UpdatePackage> availableUpdates = ConfigUpdateService.scanForUpdates(updatesFolder);
        if (availableUpdates.isEmpty()) {
            LOGGER.info("No config updates found");
            return;
        }
        LOGGER.info("Found {} update package(s)", (Object)availableUpdates.size());
        List<UpdatePackage> pendingUpdates = availableUpdates.stream().filter(pkg -> !appliedRecord.hasApplied(pkg.manifest.updateId())).toList();
        if (pendingUpdates.isEmpty()) {
            LOGGER.info("All updates have already been applied");
            return;
        }
        LOGGER.info("Found {} pending update(s) to apply", (Object)pendingUpdates.size());
        boolean anyApplied = false;
        AppliedUpdatesRecord currentRecord = appliedRecord;
        for (UpdatePackage updatePkg : pendingUpdates) {
            LOGGER.info("Applying update: {} ({})", (Object)updatePkg.manifest.updateId(), (Object)updatePkg.manifest.description());
            boolean success = ConfigUpdateService.applyUpdate(gameDir, updatePkg);
            if (success) {
                currentRecord = currentRecord.withNewUpdate(updatePkg.manifest.updateId(), updatePkg.manifest.version());
                anyApplied = true;
                LOGGER.info("Successfully applied update: {}", (Object)updatePkg.manifest.updateId());
                ConfigUpdateService.archiveUpdate(updatePkg);
                continue;
            }
            LOGGER.error("Failed to apply update: {}", (Object)updatePkg.manifest.updateId());
        }
        if (anyApplied) {
            ConfigUpdateService.saveAppliedUpdates(gameDir, currentRecord);
            LOGGER.info("Config updates applied successfully. Last version: {}", (Object)currentRecord.lastAppliedVersion);
        }
    }

    private static List<UpdatePackage> scanForUpdates(Path updatesFolder) {
        ArrayList<UpdatePackage> updates = new ArrayList<UpdatePackage>();
        try (Stream<Path> files = Files.list(updatesFolder);){
            files.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.getFileName().toString().equals(UPDATE_MANIFEST_FILE)).forEach(manifestPath -> {
                try {
                    String json = Files.readString(manifestPath, StandardCharsets.UTF_8);
                    UpdateManifest manifest = (UpdateManifest)GSON.fromJson(json, UpdateManifest.class);
                    if (manifest == null || !manifest.isValid()) {
                        LOGGER.warn("Invalid manifest at: {}", manifestPath);
                        return;
                    }
                    Path configZip = manifestPath.getParent().resolve(manifest.configFileName());
                    if (!Files.exists(configZip, new LinkOption[0])) {
                        LOGGER.warn("Config file not found for manifest: {} (expected: {})", manifestPath, (Object)manifest.configFileName());
                        return;
                    }
                    updates.add(new UpdatePackage((Path)manifestPath, configZip, manifest));
                    LOGGER.debug("Found update package: {} at {}", (Object)manifest.updateId(), (Object)manifestPath.getParent());
                }
                catch (JsonSyntaxException | IOException e) {
                    LOGGER.error("Failed to read manifest: {}", manifestPath, (Object)e);
                }
            });
        }
        catch (IOException e) {
            LOGGER.error("Failed to scan updates folder", (Throwable)e);
        }
        return updates;
    }

    private static boolean applyUpdate(Path gameDir, UpdatePackage updatePkg) {
        try {
            UpdateManifest manifest = updatePkg.manifest;
            if (manifest.createBackup()) {
                LOGGER.info("Creating backup before applying update.. .");
                Path backup = BackupManager.createBackupAsync(gameDir, BackupManager.BackupType.AUTO, "Auto backup before update: " + manifest.updateId(), "Backup created before applying config update", msg -> LOGGER.debug("Backup progress: {}", msg)).join();
                if (backup != null) {
                    LOGGER.info("Backup created: {}", (Object)backup.getFileName());
                } else {
                    LOGGER.warn("Failed to create backup, but continuing with update");
                }
            }
            LOGGER.info("Extracting update configs from: {}", (Object)updatePkg.configZipPath.getFileName());
            UnzipService unzipper = new UnzipService();
            unzipper.unzip(updatePkg.configZipPath.toString(), gameDir.toString(), (bytesProcessed, totalBytes, percentage) -> {
                if (percentage % 25 == 0) {
                    LOGGER.info("Update extraction progress: {}%", (Object)percentage);
                }
            });
            LOGGER.info("Update configs extracted successfully");
            return true;
        }
        catch (IOException e) {
            LOGGER.error("Failed to apply update", (Throwable)e);
            return false;
        }
    }

    private static void archiveUpdate(UpdatePackage updatePkg) {
        try {
            Path archiveFolder = updatePkg.manifestPath.getParent().resolve("applied");
            Files.createDirectories(archiveFolder, new FileAttribute[0]);
            String timestamp = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMdd_HHmmss"));
            Path archiveSubfolder = archiveFolder.resolve(updatePkg.manifest.updateId() + "_" + timestamp);
            Files.createDirectories(archiveSubfolder, new FileAttribute[0]);
            Path archivedManifest = archiveSubfolder.resolve(updatePkg.manifestPath.getFileName());
            Files.move(updatePkg.manifestPath, archivedManifest, StandardCopyOption.REPLACE_EXISTING);
            Path archivedZip = archiveSubfolder.resolve(updatePkg.configZipPath.getFileName());
            Files.move(updatePkg.configZipPath, archivedZip, StandardCopyOption.REPLACE_EXISTING);
            LOGGER.info("Archived update to: {}", (Object)archiveSubfolder);
        }
        catch (IOException e) {
            LOGGER.warn("Failed to archive update package", (Throwable)e);
        }
    }

    private static AppliedUpdatesRecord loadAppliedUpdates(Path gameDir) {
        Path recordPath = gameDir.resolve(APPLIED_UPDATES_FILE);
        if (!Files.exists(recordPath, new LinkOption[0])) {
            return AppliedUpdatesRecord.empty();
        }
        try {
            String json = Files.readString(recordPath, StandardCharsets.UTF_8);
            AppliedUpdatesRecord record = (AppliedUpdatesRecord)GSON.fromJson(json, AppliedUpdatesRecord.class);
            return record != null ? record : AppliedUpdatesRecord.empty();
        }
        catch (JsonSyntaxException | IOException e) {
            LOGGER.error("Failed to load applied updates record", e);
            return AppliedUpdatesRecord.empty();
        }
    }

    private static void saveAppliedUpdates(Path gameDir, AppliedUpdatesRecord record) {
        Path recordPath = gameDir.resolve(APPLIED_UPDATES_FILE);
        try {
            Files.createDirectories(recordPath.getParent(), new FileAttribute[0]);
            String json = GSON.toJson((Object)record);
            Files.writeString(recordPath, (CharSequence)json, StandardCharsets.UTF_8, new OpenOption[0]);
            LOGGER.info("Saved applied updates record");
        }
        catch (IOException e) {
            LOGGER.error("Failed to save applied updates record", (Throwable)e);
        }
    }

    private static void createReadmeFile(Path updatesFolder) {
        Path readmePath = updatesFolder.resolve("README.txt");
        try {
            String content = "\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\nPackCore Automatic Config Updates Folder\n\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\n\n\ud83d\udce6 What is this folder?\n\nThis folder is used for automatic config updates when you\nrelease a modpack update. It allows you to ship config files\nfor new mods without overwriting users' existing configs.\n\n\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\n\ud83d\udd27 How to use (for modpack developers):\n\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\n\n1. Create your config update zip file\n   - Include ONLY the new/changed config files\n   - Example: config/newmod/settings.json\n\n2. Create update_manifest.json with this structure:\n   {\n     \"updateId\": \"1.2.0_newmod\",\n     \"version\": \"1.2.0\",\n     \"description\": \"Added NewMod configuration\",\n     \"configFileName\": \"newmod_config.zip\",\n     \"createBackup\": true,\n     \"affectedMods\": [\"newmod\"]\n   }\n\n3. Place both files in this folder for distribution\n\n4. When users update the modpack, configs apply automatically\n\n\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\n\ud83d\udccb Update Manifest Fields:\n\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\n\nupdateId:       Unique identifier (prevents re-applying)\nversion:        Modpack version (e.g., \"1.2.0\")\ndescription:    What this update contains\nconfigFileName: Name of the zip file to extract\ncreateBackup:   Whether to backup before applying\naffectedMods:   List of affected mod names\n\n\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\n\u26a0\ufe0f Important Notes:\n\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\n\n- Each updateId can only be applied once\n- Applied updates are moved to the 'applied' subfolder\n- Users on fresh installs get full configs (updates skipped)\n- Only existing users will receive these updates\n\n\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\n\ud83d\udcc2 Folder Structure After Updates:\n\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\n\npackcore/updates/\n\u251c\u2500\u2500 update_manifest.json       \u2190 Pending update\n\u251c\u2500\u2500 newmod_config.zip          \u2190 Pending update\n\u251c\u2500\u2500 README.txt                 \u2190 This file\n\u2514\u2500\u2500 applied/                   \u2190 Archive of applied updates\n    \u2514\u2500\u2500 1.2.0_newmod_20250101_120000/\n        \u251c\u2500\u2500 update_manifest.json\n        \u2514\u2500\u2500 newmod_config.zip\n\n\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\n";
            Files.writeString(readmePath, (CharSequence)content, new OpenOption[0]);
            LOGGER.info("Created updates README: {}", (Object)readmePath);
        }
        catch (IOException e) {
            LOGGER.error("Failed to create updates README", (Throwable)e);
        }
    }

    public static void forceUpdateCheck(Path gameDir) {
        LOGGER.info("Forcing update check...");
        ConfigUpdateService.checkAndApplyUpdates(gameDir);
    }

    public static List<String> getAppliedUpdateIds(Path gameDir) {
        AppliedUpdatesRecord record = ConfigUpdateService.loadAppliedUpdates(gameDir);
        return new ArrayList<String>(record.appliedUpdateIds);
    }

    public static void resetAppliedUpdates(Path gameDir) {
        Path recordPath = gameDir.resolve(APPLIED_UPDATES_FILE);
        try {
            Files.deleteIfExists(recordPath);
            LOGGER.warn("Reset applied updates record");
        }
        catch (IOException e) {
            LOGGER.error("Failed to reset applied updates", (Throwable)e);
        }
    }

    private record AppliedUpdatesRecord(List<String> appliedUpdateIds, String lastAppliedVersion, String lastAppliedDate) {
        public AppliedUpdatesRecord {
            appliedUpdateIds = appliedUpdateIds != null ? new ArrayList<String>(appliedUpdateIds) : new ArrayList();
        }

        public static AppliedUpdatesRecord empty() {
            return new AppliedUpdatesRecord(new ArrayList<String>(), null, null);
        }

        public boolean hasApplied(String updateId) {
            return this.appliedUpdateIds.contains(updateId);
        }

        public AppliedUpdatesRecord withNewUpdate(String updateId, String version) {
            ArrayList<String> newList = new ArrayList<String>(this.appliedUpdateIds);
            if (!newList.contains(updateId)) {
                newList.add(updateId);
            }
            String date = LocalDateTime.now().format(DateTimeFormatter.ISO_LOCAL_DATE_TIME);
            return new AppliedUpdatesRecord(newList, version, date);
        }
    }

    private record UpdatePackage(Path manifestPath, Path configZipPath, UpdateManifest manifest) {
    }

    public record UpdateManifest(String updateId, String version, String description, String configFileName, boolean createBackup, List<String> affectedMods) {
        public UpdateManifest {
            if (updateId == null || updateId.isBlank()) {
                throw new IllegalArgumentException("updateId cannot be null or blank");
            }
            if (configFileName == null || configFileName.isBlank()) {
                throw new IllegalArgumentException("configFileName cannot be null or blank");
            }
            affectedMods = affectedMods != null ? new ArrayList<String>(affectedMods) : new ArrayList();
        }

        public boolean isValid() {
            return this.updateId != null && !this.updateId.isBlank() && this.configFileName != null && !this.configFileName.isBlank();
        }
    }
}

