/*
 * Decompiled with CFR 0.152.
 */
package com.github.kd_gaming1.packcore.ui.screen.configmanager;

import com.github.kd_gaming1.packcore.PackCore;
import com.github.kd_gaming1.packcore.config.imports.ConfigImportService;
import com.github.kd_gaming1.packcore.config.model.ConfigMetadata;
import com.github.kd_gaming1.packcore.ui.screen.base.BasePackCoreScreen;
import com.github.kd_gaming1.packcore.ui.screen.components.ScreenUIComponents;
import com.github.kd_gaming1.packcore.ui.screen.configmanager.ConfigManagerScreen;
import com.github.kd_gaming1.packcore.ui.screen.configmanager.ExportConfigScreen;
import com.github.kd_gaming1.packcore.ui.theme.UITheme;
import com.github.kd_gaming1.packcore.util.task.ProgressListener;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.component.CheckboxComponent;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.core.VerticalAlignment;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;

public class ImportConfigScreen
extends BasePackCoreScreen {
    private ConfigImportService.ImportableFile selectedFile = null;
    private List<ConfigImportService.ImportableFile> availableFiles = List.of();
    private final Map<ConfigImportService.ImportableFile, FlowLayout> entryComponents = new HashMap<ConfigImportService.ImportableFile, FlowLayout>();
    private LabelComponent statusLabel;
    private FlowLayout fileListContainer;
    private FlowLayout previewContainer;
    private CheckboxComponent applyImmediatelyCheckbox;
    private CheckboxComponent deleteAfterImportCheckbox;
    private ButtonComponent importButton;
    private FlowLayout progressPanel;

    public ImportConfigScreen() {
        super((class_437)new ConfigManagerScreen());
    }

    @Override
    protected Component createTitleLabel() {
        return Components.label((class_2561)class_2561.method_43470((String)("Import Configuration - " + PackCore.getModpackInfo().getName())).method_27694(s -> s.method_27704(class_2960.method_60655((String)"packcore", (String)"gallaeciaforte")))).color(UITheme.color(-1));
    }

    @Override
    protected FlowLayout createMainContent() {
        FlowLayout mainContent = Containers.horizontalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.expand()).gap(8);
        mainContent.child((Component)this.createSidebar());
        mainContent.child((Component)this.createPreviewPanel());
        this.refreshFileList();
        return mainContent;
    }

    private FlowLayout createSidebar() {
        FlowLayout sidebar = (FlowLayout)ScreenUIComponents.createSidebar(40).padding(Insets.of((int)22, (int)18, (int)14, (int)14));
        FlowLayout sidebarContent = Containers.verticalFlow((Sizing)Sizing.fill((int)96), (Sizing)Sizing.content()).gap(8);
        sidebarContent.child((Component)this.createInstructionsSection());
        sidebarContent.child((Component)this.createFileListSection());
        sidebarContent.child((Component)this.createImportOptionsSection());
        sidebar.child(ScreenUIComponents.createScrollContainer(sidebarContent));
        return sidebar;
    }

    private FlowLayout createInstructionsSection() {
        FlowLayout section = ScreenUIComponents.createSection("How to Import", 0);
        LabelComponent instructions = (LabelComponent)Components.label((class_2561)class_2561.method_43470((String)"1. Click 'Open Imports Folder'\n2. Place your config .zip file there\n3. Click 'Refresh' to see it\n4. Select and import")).color(UITheme.color(-1)).horizontalSizing(Sizing.fill((int)95));
        section.child((Component)instructions);
        FlowLayout buttonRow = (FlowLayout)Containers.horizontalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).gap(4).horizontalAlignment(HorizontalAlignment.CENTER);
        buttonRow.child((Component)ScreenUIComponents.createButton("Open Folder", btn -> this.openImportsFolder(), 90, 20));
        buttonRow.child((Component)ScreenUIComponents.createButton("Refresh", btn -> this.refreshFileList(), 90, 20));
        section.child((Component)buttonRow);
        LabelComponent pathLabel = (LabelComponent)Components.label((class_2561)class_2561.method_43470((String)("Path: " + ConfigImportService.getImportsFolderPath()))).color(UITheme.color(-5195576)).horizontalSizing(Sizing.fill((int)95));
        section.child((Component)pathLabel);
        return section;
    }

    private FlowLayout createFileListSection() {
        FlowLayout section = ScreenUIComponents.createSection("Available Files", 60);
        this.fileListContainer = Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).gap(2);
        section.child(ScreenUIComponents.createScrollContainer(this.fileListContainer));
        return section;
    }

    private FlowLayout createImportOptionsSection() {
        FlowLayout section = ScreenUIComponents.createSection("Import Options", 0);
        this.statusLabel = Components.label((class_2561)class_2561.method_43470((String)"Select a file to import")).color(UITheme.color(-5195576));
        section.child((Component)this.statusLabel);
        this.progressPanel = Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content());
        section.child((Component)this.progressPanel);
        this.applyImmediatelyCheckbox = Components.checkbox((class_2561)class_2561.method_43470((String)"Apply Immediately"));
        this.applyImmediatelyCheckbox.checked(false);
        this.applyImmediatelyCheckbox.tooltip((class_2561)class_2561.method_43470((String)"If checked, the game will restart and apply this configuration"));
        section.child((Component)this.applyImmediatelyCheckbox);
        this.deleteAfterImportCheckbox = Components.checkbox((class_2561)class_2561.method_43470((String)"Delete After Import"));
        this.deleteAfterImportCheckbox.checked(true);
        this.deleteAfterImportCheckbox.tooltip((class_2561)class_2561.method_43470((String)"Remove the file from imports folder after successful import"));
        section.child((Component)this.deleteAfterImportCheckbox);
        this.importButton = ScreenUIComponents.createButton("Import", btn -> this.handleImportClick());
        this.importButton.active(false);
        section.child((Component)this.importButton);
        return section;
    }

    private FlowLayout createPreviewPanel() {
        this.previewContainer = ScreenUIComponents.createInfoPanel(60);
        this.showEmptyPreview();
        return this.previewContainer;
    }

    private void showEmptyPreview() {
        this.previewContainer.clearChildren();
        this.previewContainer.horizontalAlignment(HorizontalAlignment.CENTER);
        this.previewContainer.verticalAlignment(VerticalAlignment.CENTER);
        this.previewContainer.child((Component)Components.label((class_2561)class_2561.method_43470((String)"Configuration Preview").method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)))).color(UITheme.color(-18355)));
        this.previewContainer.child((Component)Components.label((class_2561)class_2561.method_43470((String)"Select a file to preview its contents")).color(UITheme.color(-5195576)));
    }

    private void openImportsFolder() {
        this.updateStatus("Opening folder...", -5195576);
        ((CompletableFuture)ConfigImportService.openImportsFolder().thenAccept(success -> class_310.method_1551().execute(() -> {
            if (success.booleanValue()) {
                this.updateStatus("Folder opened - place files there and click Refresh", -15681151);
            } else {
                this.updateStatus("Could not open folder - check game directory manually", -680437);
            }
        }))).exceptionally(throwable -> {
            class_310.method_1551().execute(() -> this.updateStatus("Error: " + throwable.getMessage(), -1096636));
            return null;
        });
    }

    private void refreshFileList() {
        this.updateStatus("Scanning for files...", -5195576);
        this.fileListContainer.clearChildren();
        this.entryComponents.clear();
        this.fileListContainer.child((Component)Components.label((class_2561)class_2561.method_43470((String)"Scanning imports folder...")).color(UITheme.color(-5195576)));
        ((CompletableFuture)ConfigImportService.scanImportsFolder().thenAccept(files -> class_310.method_1551().execute(() -> {
            this.availableFiles = files;
            this.fileListContainer.clearChildren();
            if (files.isEmpty()) {
                this.fileListContainer.child((Component)Components.label((class_2561)class_2561.method_43470((String)"No config files found\n\nPlace .zip files in the imports folder")).color(UITheme.color(-5195576)));
                this.updateStatus("No files found - add files and refresh", -5195576);
            } else {
                for (ConfigImportService.ImportableFile file : files) {
                    this.fileListContainer.child((Component)this.createFileEntry(file));
                }
                this.updateStatus("Found " + files.size() + " file(s)", -15681151);
            }
        }))).exceptionally(throwable -> {
            class_310.method_1551().execute(() -> {
                this.fileListContainer.clearChildren();
                this.fileListContainer.child((Component)Components.label((class_2561)class_2561.method_43470((String)("Error scanning folder: " + throwable.getMessage()))).color(UITheme.color(-1096636)));
                this.updateStatus("Error scanning folder", -1096636);
            });
            return null;
        });
    }

    private FlowLayout createFileEntry(ConfigImportService.ImportableFile file) {
        FlowLayout entry = ScreenUIComponents.createListEntry();
        Object displayName = file.getDisplayName();
        if (((String)displayName).length() > 35) {
            displayName = ((String)displayName).substring(0, 32) + "...";
        }
        entry.child((Component)Components.label((class_2561)class_2561.method_43470((String)displayName)).color(UITheme.color(-1)));
        FlowLayout infoRow = Containers.horizontalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).gap(6);
        if (file.isValid()) {
            infoRow.child((Component)Components.label((class_2561)class_2561.method_43470((String)"\u2713 Valid")).color(UITheme.color(-15681151)));
        } else {
            infoRow.child((Component)Components.label((class_2561)class_2561.method_43470((String)"\u2717 Invalid")).color(UITheme.color(-1096636)));
        }
        infoRow.child((Component)Components.label((class_2561)class_2561.method_43470((String)file.getFileSizeFormatted())).color(UITheme.color(-5195576)));
        entry.child((Component)infoRow);
        this.entryComponents.put(file, entry);
        if (file.isValid()) {
            ScreenUIComponents.applyHoverEffects(entry, () -> this.selectFile(file));
        } else {
            entry.tooltip((class_2561)class_2561.method_43470((String)file.validation().errorMessage()));
            entry.surface(Surface.flat((int)-528540387).and(Surface.outline((int)-1096636)));
        }
        return entry;
    }

    private void selectFile(ConfigImportService.ImportableFile file) {
        if (this.selectedFile != null && this.entryComponents.containsKey(this.selectedFile)) {
            ScreenUIComponents.applySelectedState(this.entryComponents.get(this.selectedFile), false);
        }
        this.selectedFile = file;
        if (this.entryComponents.containsKey(file)) {
            ScreenUIComponents.applySelectedState(this.entryComponents.get(file), true);
        }
        this.showPreview();
        this.importButton.active(file.isValid());
        this.updateStatus("Ready to import: " + file.getDisplayName(), -15681151);
    }

    private void showPreview() {
        if (this.selectedFile == null) {
            this.showEmptyPreview();
            return;
        }
        this.previewContainer.clearChildren();
        this.previewContainer.horizontalAlignment(HorizontalAlignment.LEFT);
        this.previewContainer.verticalAlignment(VerticalAlignment.TOP);
        if (!this.selectedFile.isValid()) {
            this.previewContainer.child((Component)ScreenUIComponents.createErrorCard("Invalid Configuration", this.selectedFile.validation().errorMessage()));
            return;
        }
        ConfigMetadata meta = this.selectedFile.metadata();
        if (meta == null) {
            this.previewContainer.child((Component)Components.label((class_2561)class_2561.method_43470((String)"Could not read metadata")).color(UITheme.color(-1096636)));
            return;
        }
        this.previewContainer.child((Component)Components.label((class_2561)class_2561.method_43470((String)meta.getName()).method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)))).color(UITheme.color(-18355)));
        FlowLayout infoBox = ScreenUIComponents.createInfoBox();
        infoBox.child((Component)ScreenUIComponents.createInfoRow("File:", this.selectedFile.fileName()));
        infoBox.child((Component)ScreenUIComponents.createInfoRow("Size:", this.selectedFile.getFileSizeFormatted()));
        infoBox.child((Component)ScreenUIComponents.createInfoRow("Version:", meta.getVersion()));
        infoBox.child((Component)ScreenUIComponents.createInfoRow("Author:", meta.getAuthor()));
        infoBox.child((Component)ScreenUIComponents.createInfoRow("Resolution:", meta.getTargetResolution()));
        if (meta.getCreatedDate() != null) {
            infoBox.child((Component)ScreenUIComponents.createInfoRow("Created:", ScreenUIComponents.formatTimestamp(meta.getCreatedDate())));
        }
        this.previewContainer.child((Component)infoBox);
        if (meta.getDescription() != null && !meta.getDescription().isEmpty()) {
            this.previewContainer.child((Component)Components.label((class_2561)class_2561.method_43470((String)"Description:").method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)))).color(UITheme.color(-18355)));
            this.previewContainer.child(Components.label((class_2561)class_2561.method_43470((String)meta.getDescription())).color(UITheme.color(-1)).sizing(Sizing.fill((int)95), Sizing.content()));
        }
        if (meta.getMods() != null && !meta.getMods().isEmpty()) {
            this.previewContainer.child(this.createModsList(meta.getMods()));
        }
        FlowLayout actionButtons = (FlowLayout)Containers.horizontalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).gap(8).horizontalAlignment(HorizontalAlignment.CENTER).margins(Insets.top((int)12));
        actionButtons.child((Component)ScreenUIComponents.createButton("Delete File", btn -> this.confirmDeleteFile(), 100, 20));
        this.previewContainer.child((Component)actionButtons);
    }

    private Component createModsList(List<String> mods) {
        FlowLayout container = Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).gap(4);
        container.child((Component)Components.label((class_2561)class_2561.method_43470((String)"Included Mods:").method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)))).color(UITheme.color(-18355)));
        FlowLayout modsContainer = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).gap(2).surface(Surface.flat((int)-1070978518).and(Surface.outline((int)-11184811))).padding(Insets.of((int)8));
        int displayCount = Math.min(10, mods.size());
        for (int i = 0; i < displayCount; ++i) {
            modsContainer.child((Component)Components.label((class_2561)class_2561.method_43470((String)("\u2022 " + mods.get(i)))).color(UITheme.color(-1)));
        }
        if (mods.size() > displayCount) {
            modsContainer.child((Component)Components.label((class_2561)class_2561.method_43470((String)("... and " + (mods.size() - displayCount) + " more"))).color(UITheme.color(-5195576)));
        }
        container.child(ScreenUIComponents.createScrollContainer(modsContainer).sizing(Sizing.fill((int)100), Sizing.fixed((int)150)));
        return container;
    }

    private void handleImportClick() {
        if (this.selectedFile == null || !this.selectedFile.isValid()) {
            return;
        }
        if (this.applyImmediatelyCheckbox.method_20372()) {
            this.showRestartWarningDialog();
        } else {
            this.performImport();
        }
    }

    private void showRestartWarningDialog() {
        FlowLayout dialog = ScreenUIComponents.createWarningDialog("Restart Required", null, 500);
        dialog.child((Component)Components.label((class_2561)class_2561.method_43470((String)("Configuration: " + this.selectedFile.getDisplayName())).method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)))).color(UITheme.color(-1)));
        FlowLayout warningBox = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).gap(4).surface(Surface.flat((int)-1070978518).and(Surface.outline((int)-680437))).padding(Insets.of((int)12));
        warningBox.child((Component)Components.label((class_2561)class_2561.method_43470((String)"This will:")).color(UITheme.color(-1)));
        warningBox.child((Component)Components.label((class_2561)class_2561.method_43470((String)"\u2022 Import and apply the configuration")).color(UITheme.color(-5195576)));
        warningBox.child((Component)Components.label((class_2561)class_2561.method_43470((String)"\u2022 Restart Minecraft automatically")).color(UITheme.color(-5195576)));
        warningBox.child((Component)Components.label((class_2561)class_2561.method_43470((String)"\u2022 Replace your current configuration")).color(UITheme.color(-5195576)));
        dialog.child((Component)warningBox);
        dialog.child((Component)ScreenUIComponents.createErrorCard("BACKUP RECOMMENDATION", "Please export your current configuration before proceeding. If you do not export a backup, you will lose your current configuration and cannot revert!"));
        dialog.child((Component)ScreenUIComponents.createButtonRow(ScreenUIComponents.createButton("Export First", btn -> {
            this.closeTopOverlay();
            class_310.method_1551().method_1507((class_437)new ExportConfigScreen());
        }), ScreenUIComponents.createButton("Import & Restart", btn -> {
            this.closeTopOverlay();
            this.performImport();
        }), ScreenUIComponents.createButton("Cancel", btn -> this.closeTopOverlay())));
        this.showOverlay(dialog, false);
    }

    private void performImport() {
        if (this.selectedFile == null || !this.selectedFile.isValid()) {
            return;
        }
        this.importButton.active(false);
        this.progressPanel.clearChildren();
        final boolean applyImmediately = this.applyImmediatelyCheckbox.method_20372();
        boolean deleteAfterImport = this.deleteAfterImportCheckbox.method_20372();
        ConfigImportService.importConfigAndCleanup(this.selectedFile.path(), applyImmediately, deleteAfterImport, new ProgressListener(){

            @Override
            public void onProgress(String message, int percentage) {
                class_310.method_1551().execute(() -> {
                    ImportConfigScreen.this.progressPanel.clearChildren();
                    ImportConfigScreen.this.progressPanel.child((Component)Components.label((class_2561)class_2561.method_43470((String)(message + " (" + percentage + "%)"))).color(UITheme.color(-18355)));
                });
            }

            @Override
            public void onComplete(boolean success, String message) {
                class_310.method_1551().execute(() -> {
                    ImportConfigScreen.this.progressPanel.clearChildren();
                    if (success) {
                        ImportConfigScreen.this.updateStatus("Success!", -15681151);
                        if (applyImmediately) {
                            ImportConfigScreen.this.progressPanel.child((Component)Components.label((class_2561)class_2561.method_43470((String)"Game will restart to apply configuration...")).color(UITheme.color(-15681151)));
                        } else {
                            ImportConfigScreen.this.progressPanel.child((Component)Components.label((class_2561)class_2561.method_43470((String)message)).color(UITheme.color(-15681151)));
                            ImportConfigScreen.this.refreshFileList();
                            ImportConfigScreen.this.selectedFile = null;
                            ImportConfigScreen.this.showEmptyPreview();
                            ImportConfigScreen.this.importButton.active(false);
                        }
                    } else {
                        ImportConfigScreen.this.updateStatus("Import failed", -1096636);
                        ImportConfigScreen.this.progressPanel.child((Component)Components.label((class_2561)class_2561.method_43470((String)message)).color(UITheme.color(-1096636)));
                        ImportConfigScreen.this.importButton.active(true);
                    }
                });
            }
        });
    }

    private void confirmDeleteFile() {
        if (this.selectedFile == null) {
            return;
        }
        FlowLayout dialog = ScreenUIComponents.createDialog("Delete File?", "Are you sure you want to delete:\n" + this.selectedFile.fileName() + "\n\nThis action cannot be undone.", 400);
        FlowLayout buttons = ScreenUIComponents.createButtonRow(ScreenUIComponents.createButton("Delete", btn -> {
            this.closeTopOverlay();
            this.deleteSelectedFile();
        }, 90, 20), ScreenUIComponents.createButton("Cancel", btn -> this.closeTopOverlay(), 90, 20));
        dialog.child((Component)buttons);
        this.showOverlay(dialog, false);
    }

    private void deleteSelectedFile() {
        if (this.selectedFile == null) {
            return;
        }
        boolean deleted = ConfigImportService.deleteImportFile(this.selectedFile.path());
        if (deleted) {
            this.updateStatus("File deleted", -15681151);
            this.selectedFile = null;
            this.showEmptyPreview();
            this.refreshFileList();
        } else {
            this.updateStatus("Failed to delete file", -1096636);
        }
    }

    private void updateStatus(String message, int color) {
        this.statusLabel.text((class_2561)class_2561.method_43470((String)message));
        this.statusLabel.color(UITheme.color(color));
    }
}

