/*
 * Decompiled with CFR 0.152.
 */
package com.github.kd_gaming1.packcore.ui.screen.wizard;

import com.github.kd_gaming1.packcore.PackCore;
import com.github.kd_gaming1.packcore.config.storage.ConfigFileRepository;
import com.github.kd_gaming1.packcore.modpack.ModpackInfo;
import com.github.kd_gaming1.packcore.ui.screen.wizard.WizardNavigator;
import com.github.kd_gaming1.packcore.ui.surface.effects.TextureSurfaces;
import io.wispforest.owo.ui.base.BaseComponent;
import io.wispforest.owo.ui.base.BaseOwoScreen;
import io.wispforest.owo.ui.component.BoxComponent;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.container.StackLayout;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.CursorStyle;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.OwoUIAdapter;
import io.wispforest.owo.ui.core.Positioning;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.core.VerticalAlignment;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseWizardPage
extends BaseOwoScreen<StackLayout> {
    protected static final int HEADER_HEIGHT = 35;
    protected static final int CONTENT_PADDING = BaseWizardPage.getScaledPadding();
    protected static final int PROGRESS_BAR_WIDTH = 125;
    protected ButtonComponent primaryButton;
    private boolean primaryButtonInitialActive = true;
    private StackLayout rootComponent;
    private final class_2960 backgroundTexture;
    private final WizardPageInfo pageInfo;
    private static final ModpackInfo info = PackCore.getModpackInfo();

    protected BaseWizardPage(@NotNull WizardPageInfo pageInfo, @Nullable class_2960 backgroundTexture) {
        super(pageInfo.title());
        this.pageInfo = pageInfo;
        this.backgroundTexture = backgroundTexture != null ? backgroundTexture : class_2960.method_60655((String)"packcore", (String)"textures/gui/wizard/welcome_bg.png");
    }

    @NotNull
    protected OwoUIAdapter<StackLayout> createAdapter() {
        return OwoUIAdapter.create((class_437)this, Containers::stack);
    }

    protected final void build(StackLayout rootComponent) {
        this.rootComponent = rootComponent;
        rootComponent.surface(TextureSurfaces.stretched(this.backgroundTexture, 1920, 1082));
        FlowLayout mainLayout = this.createMainLayout();
        mainLayout.child((Component)this.createHeader());
        if (this.shouldShowStatusInfo()) {
            mainLayout.child((Component)this.createStatusPanel());
        }
        FlowLayout contentContainer = this.createContentContainer();
        this.buildContent(contentContainer);
        mainLayout.child((Component)contentContainer);
        if (this.shouldShowRightPanel()) {
            FlowLayout contentContainerRight = this.createContentContainerRight();
            this.buildContentRight(contentContainerRight);
            mainLayout.child((Component)contentContainerRight);
        }
        mainLayout.child((Component)this.createFooter());
        rootComponent.child((Component)Containers.stack((Sizing)Sizing.fill((int)100), (Sizing)Sizing.fill((int)100)).child((Component)Components.box((Sizing)Sizing.fill((int)100), (Sizing)Sizing.fill((int)100)).color(Color.ofArgb((int)Integer.MIN_VALUE))).child((Component)mainLayout));
    }

    protected StackLayout getRootComponent() {
        return this.rootComponent;
    }

    private FlowLayout createMainLayout() {
        return (FlowLayout)Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.fill((int)100)).padding(Insets.of((int)CONTENT_PADDING));
    }

    private FlowLayout createHeader() {
        FlowLayout header = (FlowLayout)Containers.horizontalFlow((Sizing)Sizing.fill((int)this.getContentColumnWidthPercent()), (Sizing)Sizing.fixed((int)35)).padding(Insets.of((int)(CONTENT_PADDING - 6))).verticalAlignment(VerticalAlignment.CENTER);
        LabelComponent titleLabel = (LabelComponent)Components.label((class_2561)this.pageInfo.title.method_27661().method_27694(s -> s.method_27704(class_2960.method_60655((String)"packcore", (String)"gallaeciaforte")))).color(Color.ofRgb((int)-18355)).shadow(true).margins(Insets.of((int)0, (int)0, (int)4, (int)4));
        header.child((Component)titleLabel);
        FlowLayout progressIndicator = (FlowLayout)Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.fill((int)100)).gap(8).verticalAlignment(VerticalAlignment.CENTER);
        progressIndicator.child((Component)Components.label((class_2561)class_2561.method_43470((String)("| Step " + this.pageInfo.currentStep() + " of " + this.pageInfo.totalSteps())).method_27694(s -> s.method_27704(class_2960.method_60655((String)"packcore", (String)"gallaeciaforte")))).color(Color.ofRgb((int)-18355)).shadow(true));
        progressIndicator.child(this.createProgressBar());
        header.child((Component)progressIndicator);
        return header;
    }

    private Component createProgressBar() {
        int barHeight = 6;
        FlowLayout progressContainer = (FlowLayout)Containers.horizontalFlow((Sizing)Sizing.fixed((int)125), (Sizing)Sizing.fixed((int)barHeight)).surface(Surface.flat((int)0x60000000));
        int progressWidth = (int)(125.0 * ((double)this.pageInfo.currentStep() / (double)this.pageInfo.totalSteps()));
        BoxComponent progressFill = Components.box((Sizing)Sizing.fixed((int)progressWidth), (Sizing)Sizing.fill((int)100)).color(Color.ofRgb((int)-11890462));
        BaseComponent progressHighlight = Components.box((Sizing)Sizing.fixed((int)2), (Sizing)Sizing.fill((int)100)).color(Color.ofRgb((int)-18355)).positioning(Positioning.absolute((int)(progressWidth - 2), (int)0));
        return Containers.stack((Sizing)Sizing.fixed((int)125), (Sizing)Sizing.fixed((int)barHeight)).child((Component)progressContainer).child((Component)progressFill).child((Component)progressHighlight);
    }

    private FlowLayout createStatusPanel() {
        FlowLayout statusPanel = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.fill((int)38), (Sizing)Sizing.content()).gap(8).surface(TextureSurfaces.stretched(class_2960.method_60655((String)"packcore", (String)"textures/gui/wizard/small_info_box.png"), 722, 338)).padding(Insets.of((int)10)).verticalAlignment(VerticalAlignment.CENTER).positioning(Positioning.relative((int)100, (int)0));
        FlowLayout messageSection = Containers.verticalFlow((Sizing)Sizing.expand(), (Sizing)Sizing.content()).gap(4);
        FlowLayout headerRow = (FlowLayout)Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).gap(6).verticalAlignment(VerticalAlignment.CENTER);
        headerRow.child((Component)Components.label((class_2561)class_2561.method_43470((String)"\u2713 Configuration Successful").method_10862(class_2583.field_24360.method_10982(Boolean.TRUE))).color(Color.ofRgb((int)-1)));
        messageSection.child((Component)headerRow);
        LabelComponent detailLabel = Components.label((class_2561)class_2561.method_43470((String)"PackCore has automatically applied the config below based on your screen resolution.").method_10862(class_2583.field_24360)).color(Color.ofRgb((int)-5195576));
        detailLabel.horizontalSizing(Sizing.fill((int)100));
        messageSection.child((Component)detailLabel);
        LabelComponent infoLabel = (LabelComponent)Components.label((class_2561)class_2561.method_43470((String)("Applied configuration: " + ConfigFileRepository.getCurrentConfig().getDisplayName())).method_10862(class_2583.field_24360.method_10978(Boolean.TRUE))).color(Color.ofRgb((int)-5195576)).margins(Insets.of((int)2, (int)2, (int)2, (int)2));
        infoLabel.horizontalSizing(Sizing.fill((int)100));
        messageSection.child((Component)infoLabel.margins(Insets.top((int)2)));
        statusPanel.child((Component)messageSection);
        return statusPanel;
    }

    private FlowLayout createContentContainer() {
        return (FlowLayout)Containers.verticalFlow((Sizing)Sizing.fill((int)this.getContentColumnWidthPercent()), (Sizing)Sizing.expand()).gap(12).surface(TextureSurfaces.stretched(class_2960.method_60655((String)"packcore", (String)"textures/gui/wizard/info_box.png"), 1142, 934)).padding(Insets.of((int)(CONTENT_PADDING + 10), (int)(CONTENT_PADDING + 10), (int)(CONTENT_PADDING + 4), (int)(CONTENT_PADDING + 4))).horizontalAlignment(HorizontalAlignment.CENTER).margins(Insets.of((int)0, (int)28, (int)0, (int)0));
    }

    private FlowLayout createContentContainerRight() {
        return (FlowLayout)Containers.verticalFlow((Sizing)Sizing.fill((int)this.getContentColumnWidthRightPercent()), (Sizing)Sizing.fill((int)100)).gap(12).surface(TextureSurfaces.stretched(class_2960.method_60655((String)"packcore", (String)"textures/gui/wizard/box.png"), 607, 755)).padding(Insets.of((int)(CONTENT_PADDING + 10), (int)(CONTENT_PADDING + 10), (int)(CONTENT_PADDING + 4), (int)(CONTENT_PADDING + 4))).horizontalAlignment(HorizontalAlignment.CENTER).positioning(Positioning.relative((int)100, (int)0)).margins(Insets.of((int)0, (int)28, (int)0, (int)0));
    }

    private FlowLayout createFooter() {
        FlowLayout footer = (FlowLayout)Containers.horizontalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).padding(Insets.of((int)(CONTENT_PADDING - 8), (int)(CONTENT_PADDING - 8), (int)CONTENT_PADDING, (int)CONTENT_PADDING)).verticalAlignment(VerticalAlignment.CENTER).positioning(Positioning.relative((int)0, (int)100));
        FlowLayout buttonContainer = (FlowLayout)Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).gap(12).positioning(Positioning.relative((int)100, (int)50));
        if (this.hasPreviousPage()) {
            ButtonComponent backButton = (ButtonComponent)Components.button((class_2561)class_2561.method_43470((String)"Back"), button -> this.onBackPressed()).renderer(ButtonComponent.Renderer.texture((class_2960)class_2960.method_60655((String)"packcore", (String)"textures/gui/wizard/previous.png"), (int)0, (int)0, (int)100, (int)60)).horizontalSizing(Sizing.fixed((int)100)).verticalSizing(Sizing.fixed((int)20));
            buttonContainer.child((Component)backButton);
        }
        if (this.isSkippable()) {
            ButtonComponent skipButton = (ButtonComponent)Components.button((class_2561)class_2561.method_43470((String)"Skip"), button -> this.onSkipPressed()).renderer(ButtonComponent.Renderer.texture((class_2960)class_2960.method_60655((String)"packcore", (String)"textures/gui/wizard/continue.png"), (int)0, (int)0, (int)100, (int)60)).horizontalSizing(Sizing.fixed((int)100)).verticalSizing(Sizing.fixed((int)20));
            buttonContainer.child((Component)skipButton);
        }
        ButtonComponent primaryButton = this.createPrimaryButton();
        buttonContainer.child((Component)primaryButton);
        FlowLayout linkButtonContainer = (FlowLayout)Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).gap(8).margins(Insets.of((int)0, (int)0, (int)4, (int)0));
        ButtonComponent discord = (ButtonComponent)Components.button((class_2561)class_2561.method_43473(), button -> class_156.method_668().method_670(info.getDiscord())).renderer(ButtonComponent.Renderer.texture((class_2960)class_2960.method_60655((String)"packcore", (String)"textures/gui/menu/discord_icon.png"), (int)0, (int)0, (int)22, (int)22)).horizontalSizing(Sizing.fixed((int)22)).verticalSizing(Sizing.fixed((int)22));
        ButtonComponent modrinth = (ButtonComponent)Components.button((class_2561)class_2561.method_43473(), button -> class_156.method_668().method_670(info.getWebsite())).renderer(ButtonComponent.Renderer.texture((class_2960)class_2960.method_60655((String)"packcore", (String)"textures/gui/menu/modrinth_icon.png"), (int)0, (int)0, (int)22, (int)22)).horizontalSizing(Sizing.fixed((int)22)).verticalSizing(Sizing.fixed((int)22));
        ButtonComponent github = (ButtonComponent)Components.button((class_2561)class_2561.method_43473(), button -> class_156.method_668().method_670(info.getIssueTracker())).renderer(ButtonComponent.Renderer.texture((class_2960)class_2960.method_60655((String)"packcore", (String)"textures/gui/menu/github_icon.png"), (int)0, (int)0, (int)22, (int)22)).horizontalSizing(Sizing.fixed((int)22)).verticalSizing(Sizing.fixed((int)22));
        linkButtonContainer.child((Component)discord);
        linkButtonContainer.child((Component)modrinth);
        linkButtonContainer.child((Component)github);
        footer.child((Component)linkButtonContainer);
        footer.child((Component)buttonContainer);
        return footer;
    }

    protected void updatePrimaryButtonState(boolean enabled) {
        if (this.primaryButton != null) {
            this.primaryButton.field_22763 = enabled;
        } else {
            this.primaryButtonInitialActive = enabled;
        }
    }

    private ButtonComponent createPrimaryButton() {
        String buttonText = this.isLastPage() ? "Finish" : "Continue";
        this.primaryButton = (ButtonComponent)Components.button((class_2561)class_2561.method_43470((String)buttonText), button -> this.onContinuePressed()).renderer(ButtonComponent.Renderer.texture((class_2960)class_2960.method_60655((String)"packcore", (String)"textures/gui/wizard/continue.png"), (int)0, (int)0, (int)100, (int)60)).horizontalSizing(Sizing.fixed((int)100)).verticalSizing(Sizing.fixed((int)20));
        this.primaryButton.field_22763 = this.primaryButtonInitialActive;
        return this.primaryButton;
    }

    private static int getScaledPadding() {
        int screenWidth = class_310.method_1551().method_22683().method_4486();
        return screenWidth < 900 ? 8 : (screenWidth > 1400 ? 20 : 15);
    }

    protected FlowLayout createSelectionCard(boolean selected) {
        int borderColor = selected ? -15681151 : 0x40FFFFFF;
        return (FlowLayout)Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).gap(6).surface(Surface.outline((int)borderColor)).padding(Insets.of((int)12)).cursorStyle(CursorStyle.HAND);
    }

    protected abstract void buildContent(FlowLayout var1);

    protected abstract void buildContentRight(FlowLayout var1);

    protected abstract void onContinuePressed();

    protected void onBackPressed() {
        if (this.hasPreviousPage()) {
            class_310.method_1551().method_1507(WizardNavigator.createWizardPage(this.pageInfo.currentStep() - 1));
        }
    }

    protected void onSkipPressed() {
        this.onContinuePressed();
    }

    protected boolean hasPreviousPage() {
        return this.pageInfo.currentStep() >= 1;
    }

    protected boolean isLastPage() {
        return this.pageInfo.currentStep() >= this.pageInfo.totalSteps();
    }

    protected boolean isSkippable() {
        return false;
    }

    protected boolean shouldShowStatusInfo() {
        return true;
    }

    protected boolean shouldShowRightPanel() {
        return false;
    }

    protected int getContentColumnWidthPercent() {
        return 60;
    }

    protected int getContentColumnWidthRightPercent() {
        return 40;
    }

    public record WizardPageInfo(class_2561 title, int currentStep, int totalSteps) {
    }
}

