/*
 * Decompiled with CFR 0.152.
 */
package com.github.kd_gaming1.packcore;

import com.github.kd_gaming1.packcore.commands.PackCoreCommand;
import com.github.kd_gaming1.packcore.config.PackCoreConfig;
import com.github.kd_gaming1.packcore.gui.help.introduction.IntroductionScreenPage;
import com.github.kd_gaming1.packcore.gui.titlescreen.fancy.FancyMainMenuScreen;
import com.github.kd_gaming1.packcore.util.api.UpdateCacheManager;
import com.github.kd_gaming1.packcore.util.config.BobbyConfigModifier;
import com.github.kd_gaming1.packcore.util.modpack.ModpackInfo;
import com.mojang.brigadier.CommandDispatcher;
import eu.midnightdust.lib.config.MidnightConfig;
import java.nio.file.Path;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_437;
import net.minecraft.class_442;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackCore
implements ClientModInitializer {
    public static final String MOD_ID = "packcore";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"packcore");
    private static ModpackInfo modpackInfo;
    private static UpdateCacheManager updateManager;
    private static final Path packcoreDir;

    public void onInitializeClient() {
        LOGGER.info("PackCore initialized!");
        try {
            modpackInfo = ModpackInfo.loadFromFile(packcoreDir);
            updateManager = new UpdateCacheManager();
            LOGGER.info("Loaded modpack info for: {}", (Object)modpackInfo.getName());
        }
        catch (Exception e) {
            LOGGER.error("Failed to load modpack info: {}", (Object)e.getMessage());
        }
        MidnightConfig.init((String)MOD_ID, PackCoreConfig.class);
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> PackCoreCommand.registerCommands((CommandDispatcher<FabricClientCommandSource>)dispatcher));
        if (PackCoreConfig.enableCustomMenu) {
            ScreenEvents.AFTER_INIT.register((client, screen, scaledWidth, scaledHeight) -> {
                if (screen instanceof class_442) {
                    client.execute(() -> client.method_1507((class_437)(PackCoreConfig.haveShownWelcomeWizard ? new FancyMainMenuScreen() : new IntroductionScreenPage())));
                }
            });
        }
        if (!PackCoreConfig.haveSetBobbyConfig) {
            BobbyConfigModifier.enableDynamicMultiWorld();
            PackCoreConfig.haveSetBobbyConfig = true;
            PackCoreConfig.write((String)MOD_ID);
        }
    }

    public static ModpackInfo getModpackInfo() {
        return modpackInfo;
    }

    public static UpdateCacheManager getUpdateManager() {
        return updateManager;
    }

    static {
        packcoreDir = FabricLoader.getInstance().getGameDir().resolve(MOD_ID);
    }
}

