/*
 * Decompiled with CFR 0.152.
 */
package com.github.kd_gaming1.packcore.commands;

import com.github.kd_gaming1.packcore.PackCore;
import com.github.kd_gaming1.packcore.config.PackCoreConfig;
import com.github.kd_gaming1.packcore.gui.configscreen.ModpackConfigMenuScreen;
import com.github.kd_gaming1.packcore.gui.help.guide.BaseGuidePage;
import com.github.kd_gaming1.packcore.util.ConfigFileUtils;
import com.github.kd_gaming1.packcore.util.ConfigMetadata;
import com.github.kd_gaming1.packcore.util.config.PerformanceProfileUtil;
import com.github.kd_gaming1.packcore.util.config.TabDesignUtil;
import com.github.kd_gaming1.packcore.util.modpack.ModpackInfo;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;

public class PackCoreCommand {
    public static void registerCommands(CommandDispatcher<FabricClientCommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"packcore").then(ClientCommandManager.literal((String)"guide").executes(PackCoreCommand::openGuide))).then(ClientCommandManager.literal((String)"configmanager").executes(PackCoreCommand::openConfig))).then(ClientCommandManager.literal((String)"status").executes(context -> {
            FabricClientCommandSource source = (FabricClientCommandSource)context.getSource();
            ModpackInfo modpackInfo = PackCore.getModpackInfo();
            ConfigMetadata currentConfig = ConfigFileUtils.getCurrentConfig();
            source.sendFeedback((class_2561)class_2561.method_43470((String)"=== PackCore Status ===").method_27692(class_124.field_1065));
            source.sendFeedback((class_2561)class_2561.method_43470((String)("Modpack: " + modpackInfo.getName() + " v" + modpackInfo.getVersion())));
            source.sendFeedback((class_2561)class_2561.method_43470((String)("Active Config: " + currentConfig.getName() + " v" + currentConfig.getVersion())));
            source.sendFeedback((class_2561)class_2561.method_43470((String)("Custom Menu: " + (PackCoreConfig.enableCustomMenu ? "Enabled" : "Disabled"))));
            source.sendFeedback((class_2561)class_2561.method_43470((String)("Config Applied: " + (PackCoreConfig.defaultConfigSuccessfullyApplied ? "Yes" : "No"))));
            return 1;
        }))).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"performance").then(ClientCommandManager.literal((String)"list").executes(PackCoreCommand::listPerformanceProfiles))).then(ClientCommandManager.literal((String)"apply").then(ClientCommandManager.argument((String)"profile", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> {
            builder.suggest("performance");
            builder.suggest("balanced");
            builder.suggest("quality");
            builder.suggest("shaders");
            return builder.buildFuture();
        }).executes(PackCoreCommand::applyPerformanceProfile))))).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"tabdesign").then(ClientCommandManager.literal((String)"list").executes(PackCoreCommand::listTabDesigns))).then(ClientCommandManager.literal((String)"apply").then(ClientCommandManager.argument((String)"design", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> {
            builder.suggest("skyhanni");
            builder.suggest("skyblocker");
            return builder.buildFuture();
        }).executes(PackCoreCommand::applyTabDesign)))));
    }

    private static int openGuide(CommandContext<FabricClientCommandSource> context) {
        class_310 client = ((FabricClientCommandSource)context.getSource()).getClient();
        if (client == null) {
            ((FabricClientCommandSource)context.getSource()).sendError((class_2561)class_2561.method_43470((String)"Unable to access Minecraft client"));
            return 0;
        }
        client.method_63588(() -> {
            try {
                client.method_1507((class_437)new BaseGuidePage());
            }
            catch (Exception e) {
                PackCore.LOGGER.error("Failed to open guide: {}", (Object)e.getMessage());
            }
        });
        return 1;
    }

    private static int openConfig(CommandContext<FabricClientCommandSource> context) {
        class_310 client = ((FabricClientCommandSource)context.getSource()).getClient();
        if (client == null) {
            ((FabricClientCommandSource)context.getSource()).sendError((class_2561)class_2561.method_43470((String)"Unable to access Minecraft client"));
            return 0;
        }
        client.method_63588(() -> {
            try {
                client.method_1507((class_437)new ModpackConfigMenuScreen());
            }
            catch (Exception e) {
                PackCore.LOGGER.error("Failed to open config: {}", (Object)e.getMessage());
            }
        });
        return 1;
    }

    private static int applyPerformanceProfile(CommandContext<FabricClientCommandSource> context) {
        PerformanceProfileUtil.PerformanceProfile profile;
        String profileName;
        switch (profileName = StringArgumentType.getString(context, (String)"profile").toLowerCase()) {
            case "performance": {
                profile = PerformanceProfileUtil.PerformanceProfile.PERFORMANCE;
                break;
            }
            case "balanced": {
                profile = PerformanceProfileUtil.PerformanceProfile.BALANCED;
                break;
            }
            case "quality": {
                profile = PerformanceProfileUtil.PerformanceProfile.QUALITY;
                break;
            }
            case "shaders": {
                profile = PerformanceProfileUtil.PerformanceProfile.SHADERS;
                break;
            }
            default: {
                ((FabricClientCommandSource)context.getSource()).sendError((class_2561)class_2561.method_43470((String)("Unknown performance profile: " + profileName)).method_27692(class_124.field_1061));
                ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Available profiles: performance, balanced, quality, shaders").method_27692(class_124.field_1054));
                return 0;
            }
        }
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("Applying performance profile: " + profile.getDisplayName() + "...")).method_27692(class_124.field_1054));
        CompletableFuture.runAsync(() -> {
            try {
                PerformanceProfileUtil.ProfileResult result = PerformanceProfileUtil.applyPerformanceProfile(profile);
                class_310.method_1551().execute(() -> {
                    if (result.isFullySuccessful()) {
                        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("\u2713 Performance profile '" + profile.getDisplayName() + "' applied successfully!")).method_27692(class_124.field_1060));
                        if (result.isVanillaApplied()) {
                            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"  \u2713 Minecraft settings applied").method_27692(class_124.field_1080));
                        }
                        if (result.isSodiumAvailable() && result.isSodiumApplied()) {
                            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"  \u2713 Sodium settings applied").method_27692(class_124.field_1080));
                        }
                        if (result.isIrisAvailable() && result.isIrisApplied()) {
                            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"  \u2713 Iris/Shader settings applied").method_27692(class_124.field_1080));
                        }
                    } else {
                        ((FabricClientCommandSource)context.getSource()).sendError((class_2561)class_2561.method_43470((String)"\u26a0 Performance profile applied with some issues:").method_27692(class_124.field_1054));
                        if (!result.isVanillaApplied()) {
                            ((FabricClientCommandSource)context.getSource()).sendError((class_2561)class_2561.method_43470((String)"  \u2717 Failed to apply Minecraft settings").method_27692(class_124.field_1061));
                        }
                        if (result.isSodiumAvailable() && !result.isSodiumApplied()) {
                            ((FabricClientCommandSource)context.getSource()).sendError((class_2561)class_2561.method_43470((String)"  \u2717 Failed to apply Sodium settings").method_27692(class_124.field_1061));
                        }
                        if (result.isIrisAvailable() && !result.isIrisApplied()) {
                            ((FabricClientCommandSource)context.getSource()).sendError((class_2561)class_2561.method_43470((String)"  \u2717 Failed to apply Iris/Shader settings").method_27692(class_124.field_1061));
                        }
                    }
                });
            }
            catch (Exception e) {
                class_310.method_1551().execute(() -> ((FabricClientCommandSource)context.getSource()).sendError((class_2561)class_2561.method_43470((String)("\u2717 Failed to apply performance profile: " + e.getMessage())).method_27692(class_124.field_1061)));
            }
        });
        return 1;
    }

    private static int listPerformanceProfiles(CommandContext<FabricClientCommandSource> context) {
        PerformanceProfileUtil.SystemAvailability availability = PerformanceProfileUtil.getSystemAvailability();
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"=== PackCore Performance Profiles ===").method_27692(class_124.field_1065));
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Available Systems:").method_27692(class_124.field_1054));
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"  \u2022 Minecraft: \u2713").method_27692(class_124.field_1060));
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("  \u2022 Sodium: " + (availability.sodiumAvailable() ? "\u2713" : "\u2717"))).method_27692(availability.sodiumAvailable() ? class_124.field_1060 : class_124.field_1061));
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("  \u2022 Iris/Shaders: " + (availability.irisAvailable() ? "\u2713" : "\u2717"))).method_27692(availability.irisAvailable() ? class_124.field_1060 : class_124.field_1061));
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)""));
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Available Profiles:").method_27692(class_124.field_1054));
        for (PerformanceProfileUtil.PerformanceProfile profile : PerformanceProfileUtil.PerformanceProfile.values()) {
            String command = "/packcore performance apply " + profile.name().toLowerCase();
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("  \u2022 " + profile.getDisplayName() + " - " + profile.getDescription())).method_27692(class_124.field_1068));
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("    Command: " + command)).method_27692(class_124.field_1080));
        }
        return 1;
    }

    private static int applyTabDesign(CommandContext<FabricClientCommandSource> context) {
        String designName = StringArgumentType.getString(context, (String)"design").toLowerCase();
        if (!designName.equals("skyhanni") && !designName.equals("skyblocker")) {
            ((FabricClientCommandSource)context.getSource()).sendError((class_2561)class_2561.method_43470((String)("Unknown tab design: " + designName)).method_27692(class_124.field_1061));
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Available designs: skyhanni, skyblocker").method_27692(class_124.field_1054));
            return 0;
        }
        TabDesignUtil.TabDesignAvailability availability = TabDesignUtil.getAvailability();
        if (designName.equals("skyhanni") && !availability.isSkyHanniAvailable()) {
            ((FabricClientCommandSource)context.getSource()).sendError((class_2561)class_2561.method_43470((String)"\u2717 SkyHanni mod is not installed!").method_27692(class_124.field_1061));
            return 0;
        }
        if (designName.equals("skyblocker") && !availability.isSkyblockerAvailable()) {
            ((FabricClientCommandSource)context.getSource()).sendError((class_2561)class_2561.method_43470((String)"\u2717 Skyblocker mod is not installed!").method_27692(class_124.field_1061));
            return 0;
        }
        String displayName = designName.equals("skyhanni") ? "SkyHanni Compact" : "Skyblocker Fancy";
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("Applying tab design: " + displayName + "...")).method_27692(class_124.field_1054));
        CompletableFuture.runAsync(() -> {
            try {
                boolean success = TabDesignUtil.applyTabDesign(designName);
                class_310.method_1551().execute(() -> {
                    if (success) {
                        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("\u2713 Tab design '" + displayName + "' applied successfully!")).method_27692(class_124.field_1060));
                        if (designName.equals("skyhanni")) {
                            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"  \u2139 SkyHanni Compact tab list is now active").method_27692(class_124.field_1080));
                        } else {
                            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"  \u2139 Skyblocker Fancy tab HUD is now active").method_27692(class_124.field_1080));
                        }
                    } else {
                        ((FabricClientCommandSource)context.getSource()).sendError((class_2561)class_2561.method_43470((String)"\u26a0 Failed to apply tab design").method_27692(class_124.field_1054));
                        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"  The mod may not be loaded properly").method_27692(class_124.field_1080));
                    }
                });
            }
            catch (Exception e) {
                class_310.method_1551().execute(() -> ((FabricClientCommandSource)context.getSource()).sendError((class_2561)class_2561.method_43470((String)("\u2717 Failed to apply tab design: " + e.getMessage())).method_27692(class_124.field_1061)));
            }
        });
        return 1;
    }

    private static int listTabDesigns(CommandContext<FabricClientCommandSource> context) {
        TabDesignUtil.TabDesignAvailability availability = TabDesignUtil.getAvailability();
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"=== PackCore Tab Designs ===").method_27692(class_124.field_1065));
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Available Mods:").method_27692(class_124.field_1054));
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("  \u2022 SkyHanni: " + (availability.isSkyHanniAvailable() ? "\u2713" : "\u2717"))).method_27692(availability.isSkyHanniAvailable() ? class_124.field_1060 : class_124.field_1061));
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("  \u2022 Skyblocker: " + (availability.isSkyblockerAvailable() ? "\u2713" : "\u2717"))).method_27692(availability.isSkyblockerAvailable() ? class_124.field_1060 : class_124.field_1061));
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)""));
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Available Designs:").method_27692(class_124.field_1054));
        if (availability.isSkyHanniAvailable()) {
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"  \u2022 SkyHanni Compact - Minimalist compact tab list").method_27692(class_124.field_1068));
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"    Command: /packcore tabdesign apply skyhanni").method_27692(class_124.field_1080));
        }
        if (availability.isSkyblockerAvailable()) {
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"  \u2022 Skyblocker Fancy - Feature-rich tab HUD").method_27692(class_124.field_1068));
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"    Command: /packcore tabdesign apply skyblocker").method_27692(class_124.field_1080));
        }
        if (!availability.isSkyHanniAvailable() && !availability.isSkyblockerAvailable()) {
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"  \u26a0 No compatible tab design mods found").method_27692(class_124.field_1061));
        }
        return 1;
    }
}

