/*
 * Decompiled with CFR 0.152.
 */
package com.github.kd_gaming1.packcore.gui.configscreen;

import com.github.kd_gaming1.packcore.gui.configscreen.BackupManagementScreen;
import com.github.kd_gaming1.packcore.gui.configscreen.ConfigExportScreen;
import com.github.kd_gaming1.packcore.gui.configscreen.ConfigImportScreen;
import com.github.kd_gaming1.packcore.gui.ui.UITheme;
import com.github.kd_gaming1.packcore.gui.util.UiSurfaces;
import com.github.kd_gaming1.packcore.util.ConfigApplicationManager;
import com.github.kd_gaming1.packcore.util.ConfigFileUtils;
import com.github.kd_gaming1.packcore.util.ConfigMetadata;
import io.wispforest.owo.ui.base.BaseOwoScreen;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.container.OverlayContainer;
import io.wispforest.owo.ui.container.ScrollContainer;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.OwoUIAdapter;
import io.wispforest.owo.ui.core.Positioning;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.core.VerticalAlignment;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModpackConfigMenuScreen
extends BaseOwoScreen<FlowLayout> {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"packcore");
    private ConfigFileUtils.ConfigFile selectedConfig = null;
    private FlowLayout infoPanel;
    private OverlayContainer<FlowLayout> confirmationPopup = null;
    private final Map<ConfigFileUtils.ConfigFile, FlowLayout> entryComponents = new HashMap<ConfigFileUtils.ConfigFile, FlowLayout>();

    @NotNull
    protected OwoUIAdapter<FlowLayout> createAdapter() {
        return OwoUIAdapter.create((class_437)this, Containers::verticalFlow);
    }

    protected void build(FlowLayout rootComponent) {
        rootComponent.surface(UiSurfaces.stretched(class_2960.method_60655((String)"packcore", (String)"textures/gui/wizard/welcome_bg.png"), 1920, 1082));
        rootComponent.padding(Insets.of((int)8));
        rootComponent.child((Component)this.createHeader());
        rootComponent.child((Component)this.createMainContent());
    }

    private FlowLayout createHeader() {
        FlowLayout header = Containers.horizontalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.fixed((int)50));
        header.gap(8);
        header.verticalAlignment(VerticalAlignment.CENTER);
        header.child((Component)Components.texture((class_2960)class_2960.method_60655((String)"packcore", (String)"textures/gui/assets/sbe_logo.png"), (int)0, (int)0, (int)40, (int)40, (int)40, (int)40));
        header.child((Component)Components.label((class_2561)class_2561.method_43470((String)"Configuration Manager").method_27694(s -> s.method_27704(class_2960.method_60655((String)"packcore", (String)"gallaeciaforte")))).color(UITheme.color(0xFFFFFF)));
        ConfigMetadata currentMeta = ConfigFileUtils.getCurrentConfig();
        FlowLayout currentConfigInfo = Containers.verticalFlow((Sizing)Sizing.expand(), (Sizing)Sizing.content());
        currentConfigInfo.gap(2);
        currentConfigInfo.horizontalAlignment(HorizontalAlignment.RIGHT);
        currentConfigInfo.child((Component)Components.label((class_2561)class_2561.method_43470((String)("Active: " + currentMeta.getName())).method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)))).color(UITheme.color(-10496)));
        currentConfigInfo.child((Component)Components.label((class_2561)class_2561.method_43470((String)("v" + currentMeta.getVersion() + " | " + currentMeta.getTargetResolution()))).color(UITheme.color(0xB9BBBE)));
        header.child((Component)currentConfigInfo);
        header.child(Components.button((class_2561)class_2561.method_43470((String)"Close"), btn -> class_310.method_1551().method_1507(null)).renderer(ButtonComponent.Renderer.texture((class_2960)class_2960.method_60655((String)"packcore", (String)"textures/gui/wizard/previous.png"), (int)0, (int)0, (int)90, (int)57)).sizing(Sizing.fixed((int)90), Sizing.fixed((int)19)));
        return header;
    }

    private FlowLayout createMainContent() {
        FlowLayout mainContent = Containers.horizontalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.expand());
        mainContent.gap(8);
        mainContent.child((Component)this.createSidebar());
        mainContent.child((Component)this.createInfoPanel());
        return mainContent;
    }

    private FlowLayout createSidebar() {
        FlowLayout sidebar = Containers.verticalFlow((Sizing)Sizing.fill((int)35), (Sizing)Sizing.expand());
        sidebar.gap(8);
        sidebar.surface(UiSurfaces.stretched(class_2960.method_60655((String)"packcore", (String)"textures/gui/menu/notif_box.png"), 607, 755));
        sidebar.padding(Insets.of((int)12));
        int guiScale = (Integer)class_310.method_1551().field_1690.method_42474().method_41753();
        int padding = guiScale <= 2 ? 16 : 8;
        Component infoLabel = Components.label((class_2561)class_2561.method_43470((String)"Manage your modpack configurations. Select a config to view details or apply it.")).color(UITheme.color(0xFFFFFF)).sizing(Sizing.fill((int)95), Sizing.content());
        FlowLayout infoContainer = Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content());
        infoContainer.padding(Insets.of((int)padding, (int)0, (int)padding, (int)0));
        infoContainer.child(infoLabel);
        sidebar.child((Component)infoContainer);
        sidebar.child((Component)this.createConfigSection("Official Configs", ConfigFileUtils.getOfficialConfigs(), true));
        sidebar.child((Component)this.createConfigSection("Custom Configs", ConfigFileUtils.getCustomConfigs(), false));
        FlowLayout buttonRow = Containers.ltrTextFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content());
        buttonRow.gap(4);
        buttonRow.horizontalAlignment(HorizontalAlignment.CENTER);
        buttonRow.child(Components.button((class_2561)class_2561.method_43470((String)"Import"), btn -> class_310.method_1551().method_1507((class_437)new ConfigImportScreen())).renderer(ButtonComponent.Renderer.texture((class_2960)class_2960.method_60655((String)"packcore", (String)"textures/gui/wizard/button.png"), (int)0, (int)0, (int)90, (int)57)).sizing(Sizing.fixed((int)90), Sizing.fixed((int)19)).margins(Insets.bottom((int)4)));
        buttonRow.child(Components.button((class_2561)class_2561.method_43470((String)"Export"), btn -> class_310.method_1551().method_1507((class_437)new ConfigExportScreen())).renderer(ButtonComponent.Renderer.texture((class_2960)class_2960.method_60655((String)"packcore", (String)"textures/gui/wizard/button.png"), (int)0, (int)0, (int)90, (int)57)).sizing(Sizing.fixed((int)90), Sizing.fixed((int)19)).margins(Insets.bottom((int)4)));
        buttonRow.child(Components.button((class_2561)class_2561.method_43470((String)"Backup"), btn -> class_310.method_1551().method_1507((class_437)new BackupManagementScreen())).renderer(ButtonComponent.Renderer.texture((class_2960)class_2960.method_60655((String)"packcore", (String)"textures/gui/wizard/button.png"), (int)0, (int)0, (int)90, (int)57)).sizing(Sizing.fixed((int)90), Sizing.fixed((int)19)).margins(Insets.bottom((int)4)));
        sidebar.child((Component)buttonRow);
        return sidebar;
    }

    private FlowLayout createConfigSection(String title, List<ConfigFileUtils.ConfigFile> configs, boolean official) {
        FlowLayout section = Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.expand((int)(official ? 45 : 50)));
        section.gap(4);
        section.surface(Surface.flat((int)-1072031206).and(Surface.outline((int)-10496)));
        section.padding(Insets.of((int)8));
        section.child((Component)Components.label((class_2561)class_2561.method_43470((String)title).method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)))).color(UITheme.color(0xFFFFFF)));
        FlowLayout listContent = Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content());
        listContent.gap(2);
        if (configs.isEmpty()) {
            listContent.child((Component)Components.label((class_2561)class_2561.method_43470((String)"No configs found")).color(UITheme.color(0xB9BBBE)));
        } else {
            for (ConfigFileUtils.ConfigFile config : configs) {
                listContent.child((Component)this.createConfigEntry(config));
            }
        }
        ScrollContainer scrollContainer = Containers.verticalScroll((Sizing)Sizing.fill((int)100), (Sizing)Sizing.expand(), (Component)listContent);
        scrollContainer.scrollbar(ScrollContainer.Scrollbar.vanilla());
        section.child((Component)scrollContainer);
        return section;
    }

    private FlowLayout createConfigEntry(ConfigFileUtils.ConfigFile config) {
        FlowLayout entry = Containers.verticalFlow((Sizing)Sizing.fill((int)95), (Sizing)Sizing.content());
        entry.gap(2);
        entry.surface(Surface.flat((int)-1070978518).and(Surface.outline((int)-11184811)));
        entry.padding(Insets.of((int)6));
        String version = "v" + config.metadata().getVersion();
        String configName = config.getDisplayName().endsWith(version) ? config.getDisplayName().replaceAll(version, "") : config.getDisplayName();
        entry.child((Component)Components.label((class_2561)class_2561.method_43470((String)configName)).color(UITheme.color(0xFFFFFF)));
        FlowLayout badges = Containers.horizontalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content());
        badges.gap(4);
        badges.child((Component)Components.label((class_2561)class_2561.method_43470((String)(config.official() ? "Official" : "Custom"))).color(UITheme.color(config.official() ? -11353062 : -348908)));
        badges.child((Component)Components.label((class_2561)class_2561.method_43470((String)version)).color(UITheme.color(0xB9BBBE)));
        entry.child((Component)badges);
        this.entryComponents.put(config, entry);
        entry.mouseDown().subscribe((mouseX, mouseY, button) -> {
            this.selectConfig(config);
            return true;
        });
        entry.mouseEnter().subscribe(() -> {
            if (this.selectedConfig != config) {
                entry.surface(Surface.flat((int)-1069925830).and(Surface.outline((int)-10496)));
            }
        });
        entry.mouseLeave().subscribe(() -> {
            if (this.selectedConfig != config) {
                entry.surface(Surface.flat((int)-1070978518).and(Surface.outline((int)-11184811)));
            }
        });
        return entry;
    }

    private FlowLayout createInfoPanel() {
        this.infoPanel = Containers.verticalFlow((Sizing)Sizing.fill((int)65), (Sizing)Sizing.expand());
        this.infoPanel.gap(8);
        this.infoPanel.surface(UiSurfaces.stretched(class_2960.method_60655((String)"packcore", (String)"textures/gui/menu/info_box.png"), 1142, 934));
        this.infoPanel.padding(Insets.of((int)14));
        this.showEmptyState();
        return this.infoPanel;
    }

    private void showEmptyState() {
        this.infoPanel.clearChildren();
        this.infoPanel.horizontalAlignment(HorizontalAlignment.CENTER);
        this.infoPanel.verticalAlignment(VerticalAlignment.CENTER);
        this.infoPanel.child((Component)Components.label((class_2561)class_2561.method_43470((String)"Select a configuration to view details")).color(UITheme.color(0xB9BBBE)));
    }

    private void selectConfig(ConfigFileUtils.ConfigFile config) {
        if (this.selectedConfig != null && this.entryComponents.containsKey(this.selectedConfig)) {
            FlowLayout previousEntry = this.entryComponents.get(this.selectedConfig);
            previousEntry.surface(Surface.flat((int)-1070978518).and(Surface.outline((int)-11184811)));
        }
        this.selectedConfig = config;
        if (this.entryComponents.containsKey(config)) {
            FlowLayout currentEntry = this.entryComponents.get(config);
            currentEntry.surface(Surface.flat((int)-1070978518).and(Surface.outline((int)-10496)));
        }
        this.showConfigDetails();
    }

    private void showConfigDetails() {
        if (this.selectedConfig == null) {
            return;
        }
        this.infoPanel.clearChildren();
        this.infoPanel.horizontalAlignment(HorizontalAlignment.LEFT);
        this.infoPanel.verticalAlignment(VerticalAlignment.TOP);
        ConfigMetadata meta = this.selectedConfig.metadata();
        int guiScale = (Integer)class_310.method_1551().field_1690.method_42474().method_41753();
        int padding = guiScale <= 2 ? 6 : 0;
        this.infoPanel.child((Component)Components.label((class_2561)class_2561.method_43470((String)meta.getName()).method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)))).color(UITheme.color(-10496)).margins(Insets.of((int)padding, (int)0, (int)0, (int)0)));
        FlowLayout infoBox = Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content());
        infoBox.gap(4);
        infoBox.surface(Surface.flat((int)-1072031206).and(Surface.outline((int)-11184811)));
        infoBox.padding(Insets.of((int)8));
        infoBox.child((Component)this.createInfoRow("Version:", meta.getVersion()));
        infoBox.child((Component)this.createInfoRow("Author:", meta.getAuthor()));
        infoBox.child((Component)this.createInfoRow("Resolution:", meta.getTargetResolution()));
        infoBox.child((Component)this.createInfoRow("Source:", meta.getSource()));
        if (meta.getCreatedDate() != null && !meta.getCreatedDate().isEmpty()) {
            infoBox.child((Component)this.createInfoRow("Created:", this.formatDate(meta.getCreatedDate())));
        }
        this.infoPanel.child((Component)infoBox);
        if (meta.getDescription() != null && !meta.getDescription().isEmpty()) {
            this.infoPanel.child((Component)Components.label((class_2561)class_2561.method_43470((String)"Description:").method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)))).color(UITheme.color(-10496)));
            this.infoPanel.child(Components.label((class_2561)class_2561.method_43470((String)meta.getDescription())).color(UITheme.color(0xFFFFFF)).sizing(Sizing.fill((int)95), Sizing.content()));
        }
        if (meta.getMods() != null && !meta.getMods().isEmpty()) {
            this.infoPanel.child((Component)Components.label((class_2561)class_2561.method_43470((String)"Included Mods:").method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)))).color(UITheme.color(-10496)));
            FlowLayout modsContainer = Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content());
            modsContainer.gap(2);
            int displayCount = Math.min(15, meta.getMods().size());
            for (int i = 0; i < displayCount; ++i) {
                modsContainer.child((Component)Components.label((class_2561)class_2561.method_43470((String)("\u2022 " + meta.getMods().get(i)))).color(UITheme.color(0xFFFFFF)));
            }
            if (meta.getMods().size() > displayCount) {
                modsContainer.child((Component)Components.label((class_2561)class_2561.method_43470((String)("... and " + (meta.getMods().size() - displayCount) + " more"))).color(UITheme.color(0xB9BBBE)));
            }
            ScrollContainer scrollableMods = Containers.verticalScroll((Sizing)Sizing.fill((int)100), (Sizing)Sizing.expand(), (Component)modsContainer);
            scrollableMods.scrollbar(ScrollContainer.Scrollbar.vanilla());
            this.infoPanel.child((Component)scrollableMods);
        }
        FlowLayout buttonPanel = Containers.horizontalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content());
        buttonPanel.gap(8);
        buttonPanel.horizontalAlignment(HorizontalAlignment.CENTER);
        buttonPanel.child(Components.button((class_2561)class_2561.method_43470((String)"Apply Config"), btn -> this.showConfirmationPopup()).renderer(ButtonComponent.Renderer.texture((class_2960)class_2960.method_60655((String)"packcore", (String)"textures/gui/wizard/button.png"), (int)0, (int)0, (int)100, (int)60)).sizing(Sizing.fixed((int)100), Sizing.fixed((int)20)));
        if (!this.selectedConfig.official()) {
            buttonPanel.child(Components.button((class_2561)class_2561.method_43470((String)"Delete"), btn -> this.deleteConfig()).renderer(ButtonComponent.Renderer.texture((class_2960)class_2960.method_60655((String)"packcore", (String)"textures/gui/wizard/button.png"), (int)0, (int)0, (int)100, (int)60)).sizing(Sizing.fixed((int)100), Sizing.fixed((int)20)));
        }
        this.infoPanel.child((Component)buttonPanel);
    }

    private FlowLayout createInfoRow(String label, String value) {
        return ModpackConfigMenuScreen.getHorizontalFlowLayout(label, value);
    }

    @NotNull
    static FlowLayout getHorizontalFlowLayout(String label, String value) {
        FlowLayout row = Containers.horizontalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content());
        row.gap(8);
        row.child(Components.label((class_2561)class_2561.method_43470((String)label)).color(UITheme.color(0xB9BBBE)).sizing(Sizing.fixed((int)80), Sizing.content()));
        row.child((Component)Components.label((class_2561)class_2561.method_43470((String)value)).color(UITheme.color(0xFFFFFF)));
        return row;
    }

    private String formatDate(String isoDate) {
        try {
            return isoDate.replace('T', ' ').substring(0, Math.min(isoDate.length(), 19));
        }
        catch (Exception e) {
            return isoDate;
        }
    }

    private void showConfirmationPopup() {
        if (this.selectedConfig == null) {
            return;
        }
        FlowLayout popup = Containers.verticalFlow((Sizing)Sizing.fixed((int)400), (Sizing)Sizing.content());
        popup.gap(8);
        popup.surface(Surface.flat((int)-1072031206).and(Surface.outline((int)-10496)));
        popup.padding(Insets.of((int)16));
        popup.child((Component)Components.label((class_2561)class_2561.method_43470((String)"Apply Configuration?").method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)))).color(UITheme.color(-10496)));
        popup.child((Component)Components.label((class_2561)class_2561.method_43470((String)("This will restart the game and apply:\n" + this.selectedConfig.getDisplayName()))).color(UITheme.color(0xFFFFFF)));
        popup.child((Component)Components.label((class_2561)class_2561.method_43470((String)"\u26a0 Current configurations will be backed up automatically.")).color(UITheme.color(-348908)));
        FlowLayout buttons = Containers.horizontalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content());
        buttons.gap(8);
        buttons.horizontalAlignment(HorizontalAlignment.CENTER);
        buttons.child(Components.button((class_2561)class_2561.method_43470((String)"Apply"), btn -> this.applyConfig()).renderer(ButtonComponent.Renderer.texture((class_2960)class_2960.method_60655((String)"packcore", (String)"textures/gui/wizard/button.png"), (int)0, (int)0, (int)90, (int)60)).sizing(Sizing.fixed((int)90), Sizing.fixed((int)20)));
        buttons.child(Components.button((class_2561)class_2561.method_43470((String)"Cancel"), btn -> this.closePopup()).renderer(ButtonComponent.Renderer.texture((class_2960)class_2960.method_60655((String)"packcore", (String)"textures/gui/wizard/button.png"), (int)0, (int)0, (int)90, (int)60)).sizing(Sizing.fixed((int)90), Sizing.fixed((int)20)));
        popup.child((Component)buttons);
        this.confirmationPopup = Containers.overlay((Component)popup);
        this.confirmationPopup.positioning(Positioning.relative((int)50, (int)40));
        this.confirmationPopup.zIndex(10);
        ((FlowLayout)this.uiAdapter.rootComponent).child(this.confirmationPopup);
    }

    private void applyConfig() {
        if (this.selectedConfig == null) {
            return;
        }
        this.closePopup();
        try {
            ConfigApplicationManager.scheduleConfigApplication(this.selectedConfig);
            if (class_310.method_1551().field_1724 != null) {
                class_310.method_1551().field_1724.method_7353((class_2561)class_2561.method_43470((String)("Applying: " + this.selectedConfig.getDisplayName() + " - Restarting...")), false);
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to apply config", (Throwable)e);
        }
    }

    private void deleteConfig() {
        if (this.selectedConfig == null || this.selectedConfig.official()) {
            return;
        }
        if (ConfigFileUtils.deleteConfig(this.selectedConfig)) {
            this.selectedConfig = null;
            this.build((FlowLayout)this.uiAdapter.rootComponent);
        }
    }

    private void closePopup() {
        if (this.confirmationPopup != null) {
            ((FlowLayout)this.uiAdapter.rootComponent).removeChild(this.confirmationPopup);
            this.confirmationPopup = null;
        }
    }
}

