/*
 * Decompiled with CFR 0.152.
 */
package com.github.kd_gaming1.packcore.gui.help.introduction;

import com.github.kd_gaming1.packcore.PackCore;
import com.github.kd_gaming1.packcore.gui.help.BaseWizardPage;
import com.github.kd_gaming1.packcore.gui.help.WizardDataManager;
import com.github.kd_gaming1.packcore.gui.help.WizardNavigator;
import com.github.kd_gaming1.packcore.gui.util.UiSurfaces;
import com.github.kd_gaming1.packcore.util.modpack.ModpackInfo;
import io.wispforest.owo.ops.TextOps;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.CursorStyle;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.core.VerticalAlignment;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_5250;

public class IntroductionScreenPageTwo
extends BaseWizardPage {
    private final ModpackInfo modpackInfo = PackCore.getModpackInfo();
    private String selectedDesign = "None";
    private LabelComponent selectionLabel;
    private FlowLayout classicImageContainer;
    private FlowLayout modernImageContainer;

    public IntroductionScreenPageTwo() {
        super(new BaseWizardPage.WizardPageInfo((class_2561)class_2561.method_43470((String)"Tab design"), 2, 5), class_2960.method_60655((String)"packcore", (String)"textures/gui/wizard/welcome_bg.png"));
        String savedDesign = WizardDataManager.getInstance().getTabDesign();
        if (!savedDesign.isEmpty()) {
            this.selectedDesign = savedDesign;
        }
    }

    @Override
    protected void buildContent(FlowLayout contentContainer) {
        contentContainer.surface(UiSurfaces.stretched(class_2960.method_60655((String)"packcore", (String)"textures/gui/wizard/frame.png"), 1920, 1080));
        contentContainer.padding(Insets.of((int)24, (int)20, (int)18, (int)18));
        contentContainer.child((Component)this.createWelcomeHeader());
        contentContainer.child((Component)this.createSelectionLabel());
        contentContainer.child((Component)this.createImagesChoiceSection());
    }

    @Override
    protected void buildContentRight(FlowLayout contentContainerRight) {
    }

    private FlowLayout createWelcomeHeader() {
        FlowLayout header = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).gap(6).margins(Insets.of((int)0, (int)0, (int)36, (int)36));
        class_5250 welcomeText = TextOps.concat((class_2561)TextOps.withColor((String)"Choose your preferred tab design to use in-game when playing with ", (int)0xFFFFFF), (class_2561)class_2561.method_43470((String)this.modpackInfo.getName()).method_10862(class_2583.field_24360.method_36139(-10496).method_10982(Boolean.TRUE)));
        LabelComponent welcomeTitle = Components.label((class_2561)welcomeText);
        LabelComponent subtitle = (LabelComponent)Components.label((class_2561)class_2561.method_43470((String)"The pack has two mods that change the tab list: SkyHanni and Skyblocker. You can not use both at the same time, so decide which one you like best\u2014and select it. (Tip: Click the image)").method_10862(class_2583.field_24360.method_10977(class_124.field_1080).method_10978(Boolean.TRUE))).color(Color.ofRgb((int)0xB9BBBE)).margins(Insets.of((int)2, (int)0, (int)0, (int)0)).sizing(Sizing.expand(), Sizing.content());
        header.child((Component)welcomeTitle).child((Component)subtitle);
        return header;
    }

    private LabelComponent createSelectionLabel() {
        this.selectionLabel = Components.label((class_2561)TextOps.withColor((String)("Selected TabList: " + this.selectedDesign), (int)-10496).method_10862(class_2583.field_24360.method_10982(Boolean.TRUE)));
        return this.selectionLabel;
    }

    private FlowLayout createImagesChoiceSection() {
        FlowLayout modernImageContainer;
        FlowLayout classicImageContainer;
        FlowLayout choicesRow = (FlowLayout)Containers.horizontalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.expand()).gap(12).horizontalAlignment(HorizontalAlignment.CENTER).verticalAlignment(VerticalAlignment.CENTER);
        FlowLayout classicWrapper = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.fill((int)48), (Sizing)Sizing.expand()).verticalAlignment(VerticalAlignment.CENTER).horizontalAlignment(HorizontalAlignment.CENTER).margins(Insets.of((int)8)).cursorStyle(CursorStyle.HAND);
        classicWrapper.child((Component)Components.label((class_2561)TextOps.withColor((String)"SkyHanni Compact Tab", (int)0xFFFFFF).method_10862(class_2583.field_24360.method_10982(Boolean.TRUE))).margins(Insets.of((int)4, (int)4, (int)2, (int)4)));
        this.classicImageContainer = classicImageContainer = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.expand()).verticalAlignment(VerticalAlignment.CENTER).horizontalAlignment(HorizontalAlignment.CENTER).surface(UiSurfaces.scaledContain(class_2960.method_60655((String)"packcore", (String)"textures/gui/wizard/skyhanni_tab.png"), 2560, 1441)).margins(Insets.of((int)4)).cursorStyle(CursorStyle.HAND);
        classicImageContainer.mouseDown().subscribe((mouseX, mouseY, button) -> {
            this.selectDesign("SkyHanni");
            return true;
        });
        classicWrapper.child((Component)classicImageContainer);
        FlowLayout modernWrapper = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.fill((int)48), (Sizing)Sizing.expand()).verticalAlignment(VerticalAlignment.CENTER).horizontalAlignment(HorizontalAlignment.CENTER).margins(Insets.of((int)8)).cursorStyle(CursorStyle.HAND);
        modernWrapper.child((Component)Components.label((class_2561)TextOps.withColor((String)"Skyblocker Fancy TabList", (int)0xFFFFFF).method_10862(class_2583.field_24360.method_10982(Boolean.TRUE))).margins(Insets.of((int)4, (int)4, (int)2, (int)4)));
        this.modernImageContainer = modernImageContainer = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.expand()).verticalAlignment(VerticalAlignment.CENTER).horizontalAlignment(HorizontalAlignment.CENTER).surface(UiSurfaces.scaledContain(class_2960.method_60655((String)"packcore", (String)"textures/gui/wizard/skyblocker_tab.png"), 2560, 1441)).margins(Insets.of((int)4)).cursorStyle(CursorStyle.HAND);
        modernImageContainer.mouseDown().subscribe((mouseX, mouseY, button) -> {
            this.selectDesign("Skyblocker");
            return true;
        });
        modernWrapper.child((Component)modernImageContainer);
        choicesRow.child((Component)classicWrapper);
        choicesRow.child((Component)modernWrapper);
        return choicesRow;
    }

    private void selectDesign(String design) {
        this.selectedDesign = design;
        WizardDataManager.getInstance().setTabDesign(design);
        if (this.selectionLabel != null) {
            this.selectionLabel.text((class_2561)TextOps.withColor((String)("Selected TabList: " + this.selectedDesign), (int)-10496).method_10862(class_2583.field_24360.method_10982(Boolean.TRUE)));
        }
        if (this.classicImageContainer != null && this.modernImageContainer != null) {
            if ("SkyHanni".equals(design)) {
                this.classicImageContainer.surface(Surface.outline((int)Color.GREEN.argb()).and(UiSurfaces.scaledContain(class_2960.method_60655((String)"packcore", (String)"textures/gui/wizard/skyhanni_tab.png"), 2560, 1441)));
                this.modernImageContainer.surface(UiSurfaces.scaledContain(class_2960.method_60655((String)"packcore", (String)"textures/gui/wizard/skyblocker_tab.png"), 2560, 1441));
            } else if ("Skyblocker".equals(design)) {
                this.modernImageContainer.surface(Surface.outline((int)Color.GREEN.argb()).and(UiSurfaces.scaledContain(class_2960.method_60655((String)"packcore", (String)"textures/gui/wizard/skyblocker_tab.png"), 2560, 1441)));
                this.classicImageContainer.surface(UiSurfaces.scaledContain(class_2960.method_60655((String)"packcore", (String)"textures/gui/wizard/skyhanni_tab.png"), 2560, 1441));
            }
        }
    }

    @Override
    protected void onContinuePressed() {
        this.field_22787.method_1507(WizardNavigator.createWizardPage(3));
    }

    @Override
    protected int getContentColumnWidthPercent() {
        return 100;
    }

    @Override
    protected boolean shouldShowStatusInfo() {
        return false;
    }
}

