/*
 * Decompiled with CFR 0.152.
 */
package com.github.kd_gaming1.packcore.gui.titlescreen.fancy;

import com.github.kd_gaming1.packcore.PackCore;
import com.github.kd_gaming1.packcore.config.PackCoreConfig;
import com.github.kd_gaming1.packcore.gui.configscreen.ModpackConfigMenuScreen;
import com.github.kd_gaming1.packcore.gui.help.guide.BaseGuidePage;
import com.github.kd_gaming1.packcore.gui.util.UiSurfaces;
import com.github.kd_gaming1.packcore.util.api.UpdateCacheManager;
import com.github.kd_gaming1.packcore.util.api.UpdateCheckResult;
import com.github.kd_gaming1.packcore.util.modpack.ModpackInfo;
import com.github.kd_gaming1.packcore.util.notification.UpdateNotificationManager;
import io.wispforest.lavendermd.MarkdownFeature;
import io.wispforest.lavendermd.MarkdownProcessor;
import io.wispforest.lavendermd.compiler.OwoUICompiler;
import io.wispforest.lavendermd.feature.BasicFormattingFeature;
import io.wispforest.lavendermd.feature.BlockQuoteFeature;
import io.wispforest.lavendermd.feature.ColorFeature;
import io.wispforest.lavendermd.feature.ImageFeature;
import io.wispforest.lavendermd.feature.LinkFeature;
import io.wispforest.lavendermd.feature.ListFeature;
import io.wispforest.owo.ui.base.BaseOwoScreen;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.component.TextureComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.container.ScrollContainer;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.OwoUIAdapter;
import io.wispforest.owo.ui.core.ParentComponent;
import io.wispforest.owo.ui.core.Positioning;
import io.wispforest.owo.ui.core.Sizing;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_412;
import net.minecraft.class_429;
import net.minecraft.class_437;
import net.minecraft.class_500;
import net.minecraft.class_526;
import net.minecraft.class_639;
import net.minecraft.class_642;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FancyMainMenuScreen
extends BaseOwoScreen<FlowLayout> {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"packcore");
    private final class_2960 backgroundTexture = class_2960.method_60655((String)"packcore", (String)"textures/gui/title/main_menu_background.png");
    private static final ModpackInfo info = PackCore.getModpackInfo();
    private String ChangeLogInfoText;
    private static final boolean updateNotificationEnabled = info != null && PackCoreConfig.showUpdateNotificationsOnTitleScreen && PackCoreConfig.enableUpdateNotifications;
    private boolean updateAvailable;
    private String currentVersion;
    private String newVersion;
    private String changelog;
    private String modrinthUrl;
    private String modrinthName;
    private boolean showChangelog = false;
    private FlowLayout mainButtonLayout;
    private FlowLayout changelogLayout;
    private static final MarkdownProcessor<ParentComponent> MARKDOWN_PROCESSOR = new MarkdownProcessor(OwoUICompiler::new, new MarkdownFeature[]{new BasicFormattingFeature(), new ColorFeature(), new LinkFeature(), new ListFeature(), new BlockQuoteFeature(), new ImageFeature()});
    private static final Map<String, ParentComponent> COMPONENT_CACHE = new ConcurrentHashMap<String, ParentComponent>();

    @NotNull
    protected OwoUIAdapter<FlowLayout> createAdapter() {
        return OwoUIAdapter.create((class_437)this, Containers::verticalFlow);
    }

    protected void build(FlowLayout rootComponent) {
        rootComponent.surface(UiSurfaces.stretched(this.backgroundTexture, 1920, 1082));
        rootComponent.child((Component)this.createMainButtonAndTitle()).horizontalAlignment(HorizontalAlignment.CENTER);
        rootComponent.child((Component)this.createSocialButtons().positioning(Positioning.relative((int)0, (int)100)));
        rootComponent.child((Component)this.createSeeWhatIsNewButtons().positioning(Positioning.relative((int)100, (int)0)));
        rootComponent.child((Component)this.createModpackButtons().positioning(Positioning.relative((int)100, (int)100)));
        this.changelogLayout = (FlowLayout)this.createChangelogFiled().positioning(Positioning.relative((int)50, (int)75));
    }

    public void method_25426() {
        UpdateCheckResult result = this.checkForUpdates();
        if (result.isSuccess() && result.isUpdateAvailable() && updateNotificationEnabled && UpdateNotificationManager.shouldShowMainMenuToast(result.getVersionNumber())) {
            UpdateNotificationManager.showMainMenuToast(this.currentVersion, this.newVersion, this.modrinthName);
        }
        if (!result.isSuccess()) {
            LOGGER.warn("Update check failed, but don't spam user: {}", (Object)result.getErrorMessage());
        }
        super.method_25426();
    }

    private FlowLayout createMainButtonAndTitle() {
        FlowLayout buttonAndTitle = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.fixed((int)320), (Sizing)Sizing.fill((int)100)).gap(4).padding(Insets.of((int)4)).margins(Insets.of((int)4, (int)4, (int)4, (int)4));
        TextureComponent title = (TextureComponent)Components.texture((class_2960)class_2960.method_60655((String)"packcore", (String)"textures/gui/title/title.png"), (int)0, (int)0, (int)1476, (int)157, (int)1476, (int)157).margins(Insets.top((int)8)).horizontalSizing(Sizing.fixed((int)312)).verticalSizing(Sizing.fixed((int)34));
        this.mainButtonLayout = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).gap(8).horizontalAlignment(HorizontalAlignment.CENTER).padding(Insets.of((int)8)).margins(Insets.top((int)12));
        this.mainButtonLayout.child((Component)this.createHypixelButton()).child((Component)this.createSingleplayerButton()).child((Component)this.createMultiplayerButton()).child((Component)this.createModsButton()).child((Component)this.createOptionsButton()).child((Component)this.createQuitButton());
        buttonAndTitle.child((Component)title);
        buttonAndTitle.child((Component)this.mainButtonLayout);
        return buttonAndTitle;
    }

    private FlowLayout createSocialButtons() {
        FlowLayout buttonLayout = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).gap(6).horizontalAlignment(HorizontalAlignment.LEFT).padding(Insets.of((int)4));
        buttonLayout.child((Component)this.createDiscordButton()).child((Component)this.createModrinthButton()).child((Component)this.createGitHubButton()).child((Component)this.createInfo());
        return buttonLayout;
    }

    private FlowLayout createSeeWhatIsNewButtons() {
        FlowLayout buttonLayout = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).gap(6).horizontalAlignment(HorizontalAlignment.RIGHT).padding(Insets.of((int)4));
        buttonLayout.child((Component)this.createSeeWhatIsNewButton());
        return buttonLayout;
    }

    private FlowLayout createModpackButtons() {
        FlowLayout buttonLayout = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).gap(6).horizontalAlignment(HorizontalAlignment.RIGHT).padding(Insets.of((int)4));
        buttonLayout.child((Component)this.createModpackButton()).child((Component)this.createHelpUpdateButton());
        return buttonLayout;
    }

    private FlowLayout createChangelogFiled() {
        FlowLayout mainLayout = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.fill((int)65), (Sizing)Sizing.fill((int)75)).gap(4).horizontalAlignment(HorizontalAlignment.CENTER).padding(Insets.of((int)4)).surface(UiSurfaces.stretched(class_2960.method_60655((String)"packcore", (String)"textures/gui/menu/info_box.png"), 1142, 934)).margins(Insets.of((int)4, (int)4, (int)4, (int)4));
        FlowLayout changelogInfo = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).gap(2).padding(Insets.of((int)6, (int)0, (int)8, (int)8)).horizontalAlignment(HorizontalAlignment.CENTER);
        this.ChangeLogInfoText = this.currentVersion.equals(this.newVersion) ? "You are up to date! See change log for current version below:" : (FancyMainMenuScreen.compareVersions(this.currentVersion, this.newVersion) < 0 ? "A new version is available! See what's new below:" : "You are using a newer or unknown version.");
        LabelComponent changelogLabel = Components.label((class_2561)class_2561.method_43470((String)this.ChangeLogInfoText).method_27694(s -> s.method_27704(class_2960.method_60655((String)"packcore", (String)"gallaeciaforte")))).shadow(false);
        FlowLayout divider = (FlowLayout)Containers.horizontalFlow((Sizing)Sizing.fill((int)98), (Sizing)Sizing.fill((int)8)).surface(UiSurfaces.scaledContain(class_2960.method_60655((String)"packcore", (String)"textures/gui/menu/divider.png"), 2401, 96));
        this.changelog = this.changelog + "\n---\n\nNeed help **updating**? Click the button below.\n";
        ParentComponent markdownComponent = COMPONENT_CACHE.computeIfAbsent((String)this.changelog, arg_0 -> MARKDOWN_PROCESSOR.process(arg_0));
        markdownComponent.horizontalSizing(Sizing.fill((int)98));
        markdownComponent.padding(Insets.of((int)0, (int)4, (int)4, (int)4));
        ScrollContainer scrollContainer = Containers.verticalScroll((Sizing)Sizing.fill((int)98), (Sizing)Sizing.expand(), (Component)((FlowLayout)markdownComponent));
        scrollContainer.scrollbar(ScrollContainer.Scrollbar.vanilla());
        scrollContainer.margins(Insets.bottom((int)10));
        changelogInfo.child((Component)changelogLabel);
        changelogInfo.child((Component)divider);
        mainLayout.child((Component)changelogInfo);
        mainLayout.child((Component)scrollContainer);
        return mainLayout;
    }

    private ButtonComponent createHypixelButton() {
        return (ButtonComponent)Components.button((class_2561)class_2561.method_43470((String)"Join Hypixel").method_27694(s -> s.method_27704(class_2960.method_60655((String)"packcore", (String)"gallaeciaforte"))), button -> {
            class_310 client = class_310.method_1551();
            class_642 serverInfo = new class_642("Hypixel", PackCoreConfig.serverAddressForQuickJoinButton, class_642.class_8678.field_45611);
            class_412.method_36877((class_437)this, (class_310)client, (class_639)class_639.method_2950((String)PackCoreConfig.serverAddressForQuickJoinButton), (class_642)serverInfo, (boolean)false, null);
        }).renderer(ButtonComponent.Renderer.texture((class_2960)class_2960.method_60655((String)"packcore", (String)"textures/gui/menu/blank_button.png"), (int)0, (int)0, (int)200, (int)66)).horizontalSizing(Sizing.fixed((int)200)).verticalSizing(Sizing.fixed((int)22));
    }

    private ButtonComponent createSingleplayerButton() {
        return (ButtonComponent)Components.button((class_2561)class_2561.method_43470((String)"SINGLEPLAYER").method_27694(s -> s.method_27704(class_2960.method_60655((String)"packcore", (String)"gallaeciaforte"))), button -> class_310.method_1551().method_1507((class_437)new class_526((class_437)this))).renderer(ButtonComponent.Renderer.texture((class_2960)class_2960.method_60655((String)"packcore", (String)"textures/gui/menu/blank_button.png"), (int)0, (int)0, (int)200, (int)66)).horizontalSizing(Sizing.fixed((int)200)).verticalSizing(Sizing.fixed((int)22));
    }

    private ButtonComponent createMultiplayerButton() {
        return (ButtonComponent)Components.button((class_2561)class_2561.method_43470((String)"Multiplayer").method_27694(s -> s.method_27704(class_2960.method_60655((String)"packcore", (String)"gallaeciaforte"))), button -> class_310.method_1551().method_1507((class_437)new class_500((class_437)this))).renderer(ButtonComponent.Renderer.texture((class_2960)class_2960.method_60655((String)"packcore", (String)"textures/gui/menu/blank_button.png"), (int)0, (int)0, (int)200, (int)66)).horizontalSizing(Sizing.fixed((int)200)).verticalSizing(Sizing.fixed((int)22));
    }

    private ButtonComponent createModsButton() {
        return (ButtonComponent)Components.button((class_2561)class_2561.method_43470((String)"MODS").method_27694(s -> s.method_27704(class_2960.method_60655((String)"packcore", (String)"gallaeciaforte"))), button -> {
            try {
                Class<?> modMenuClass = Class.forName("com.terraformersmc.modmenu.gui.ModsScreen");
                class_310 client = class_310.method_1551();
                class_437 modsScreen = (class_437)modMenuClass.getConstructor(class_437.class).newInstance(client.field_1755);
                client.method_1507(modsScreen);
            }
            catch (Exception e) {
                LOGGER.error("Failed to open ModMenu screen", (Throwable)e);
            }
        }).renderer(ButtonComponent.Renderer.texture((class_2960)class_2960.method_60655((String)"packcore", (String)"textures/gui/menu/blank_button.png"), (int)0, (int)0, (int)200, (int)66)).horizontalSizing(Sizing.fixed((int)200)).verticalSizing(Sizing.fixed((int)22));
    }

    private ButtonComponent createOptionsButton() {
        return (ButtonComponent)Components.button((class_2561)class_2561.method_43470((String)"OPTIONS").method_27694(s -> s.method_27704(class_2960.method_60655((String)"packcore", (String)"gallaeciaforte"))), button -> {
            class_310 client = class_310.method_1551();
            client.method_1507((class_437)new class_429((class_437)this, client.field_1690));
        }).renderer(ButtonComponent.Renderer.texture((class_2960)class_2960.method_60655((String)"packcore", (String)"textures/gui/menu/blank_button.png"), (int)0, (int)0, (int)200, (int)66)).horizontalSizing(Sizing.fixed((int)200)).verticalSizing(Sizing.fixed((int)22));
    }

    private ButtonComponent createQuitButton() {
        return (ButtonComponent)Components.button((class_2561)class_2561.method_43470((String)"QUIT").method_27694(s -> s.method_27704(class_2960.method_60655((String)"packcore", (String)"gallaeciaforte"))), button -> class_310.method_1551().method_1592()).renderer(ButtonComponent.Renderer.texture((class_2960)class_2960.method_60655((String)"packcore", (String)"textures/gui/menu/blank_button.png"), (int)0, (int)0, (int)200, (int)66)).horizontalSizing(Sizing.fixed((int)200)).verticalSizing(Sizing.fixed((int)22));
    }

    private ButtonComponent createDiscordButton() {
        return (ButtonComponent)Components.button((class_2561)class_2561.method_43473(), button -> class_156.method_668().method_670(info.getDiscord())).renderer(ButtonComponent.Renderer.texture((class_2960)class_2960.method_60655((String)"packcore", (String)"textures/gui/menu/discord_icon.png"), (int)0, (int)0, (int)22, (int)22)).horizontalSizing(Sizing.fixed((int)22)).verticalSizing(Sizing.fixed((int)22)).tooltip((class_2561)class_2561.method_43470((String)"Join our Discord server"));
    }

    private ButtonComponent createModrinthButton() {
        return (ButtonComponent)Components.button((class_2561)class_2561.method_43473(), button -> class_156.method_668().method_670(info.getWebsite())).renderer(ButtonComponent.Renderer.texture((class_2960)class_2960.method_60655((String)"packcore", (String)"textures/gui/menu/modrinth_icon.png"), (int)0, (int)0, (int)22, (int)22)).horizontalSizing(Sizing.fixed((int)22)).verticalSizing(Sizing.fixed((int)22)).tooltip((class_2561)class_2561.method_43470((String)"Visit the modrinth page"));
    }

    private ButtonComponent createGitHubButton() {
        return (ButtonComponent)Components.button((class_2561)class_2561.method_43473(), button -> class_156.method_668().method_670(info.getIssueTracker())).renderer(ButtonComponent.Renderer.texture((class_2960)class_2960.method_60655((String)"packcore", (String)"textures/gui/menu/github_icon.png"), (int)0, (int)0, (int)22, (int)22)).horizontalSizing(Sizing.fixed((int)22)).verticalSizing(Sizing.fixed((int)22)).tooltip((class_2561)class_2561.method_43470((String)"Report an issue"));
    }

    private FlowLayout createInfo() {
        FlowLayout mainLayout = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).gap(4).horizontalAlignment(HorizontalAlignment.LEFT);
        LabelComponent versionLabel = Components.label((class_2561)class_2561.method_43470((String)("Pack Version: " + this.currentVersion)).method_27694(s -> s.method_27704(class_2960.method_60655((String)"packcore", (String)"gallaeciaforte")))).color(Color.ofArgb((int)196864));
        mainLayout.child((Component)versionLabel);
        if (this.updateAvailable) {
            LabelComponent updateAvailableLabel = Components.label((class_2561)class_2561.method_43470((String)("Update Available: " + this.newVersion)).method_27694(s -> s.method_27704(class_2960.method_60655((String)"packcore", (String)"gallaeciaforte")))).color(Color.ofArgb((int)196864));
            mainLayout.child((Component)updateAvailableLabel);
        }
        return mainLayout;
    }

    private ButtonComponent createSeeWhatIsNewButton() {
        return (ButtonComponent)Components.button((class_2561)class_2561.method_43473(), button -> this.toggleChangelog()).renderer(ButtonComponent.Renderer.texture((class_2960)class_2960.method_60655((String)"packcore", (String)"textures/gui/menu/update_icon.png"), (int)0, (int)0, (int)22, (int)22)).horizontalSizing(Sizing.fixed((int)22)).verticalSizing(Sizing.fixed((int)22)).tooltip((class_2561)class_2561.method_43470((String)"See what's new"));
    }

    private ButtonComponent createHelpUpdateButton() {
        return (ButtonComponent)Components.button((class_2561)class_2561.method_43473(), button -> this.field_22787.method_1507((class_437)new BaseGuidePage())).renderer(ButtonComponent.Renderer.texture((class_2960)class_2960.method_60655((String)"packcore", (String)"textures/gui/menu/guide_icon.png"), (int)0, (int)0, (int)22, (int)22)).horizontalSizing(Sizing.fixed((int)22)).verticalSizing(Sizing.fixed((int)22)).tooltip((class_2561)class_2561.method_43470((String)"See Guides on how to use the modpack"));
    }

    private ButtonComponent createModpackButton() {
        return (ButtonComponent)Components.button((class_2561)class_2561.method_43473(), button -> this.field_22787.method_1507((class_437)new ModpackConfigMenuScreen())).renderer(ButtonComponent.Renderer.texture((class_2960)class_2960.method_60655((String)"packcore", (String)"textures/gui/menu/settings_icon.png"), (int)0, (int)0, (int)22, (int)22)).horizontalSizing(Sizing.fixed((int)22)).verticalSizing(Sizing.fixed((int)22)).tooltip((class_2561)class_2561.method_43470((String)"Modpack Settings import/export your config"));
    }

    private void toggleChangelog() {
        boolean bl = this.showChangelog = !this.showChangelog;
        if (this.showChangelog) {
            this.mainButtonLayout.remove();
            ((FlowLayout)this.uiAdapter.rootComponent).child((Component)this.changelogLayout);
        } else {
            this.changelogLayout.remove();
            FlowLayout buttonAndTitle = (FlowLayout)((FlowLayout)this.uiAdapter.rootComponent).children().getFirst();
            buttonAndTitle.child((Component)this.mainButtonLayout);
        }
    }

    public UpdateCheckResult checkForUpdates() {
        UpdateCacheManager updateManager = PackCore.getUpdateManager();
        ModpackInfo info = PackCore.getModpackInfo();
        if (updateManager == null || info == null) {
            LOGGER.error("Update system not initialized properly");
            return UpdateCheckResult.error("Update system not initialized properly");
        }
        if (info.isConfigurationValid()) {
            this.updateAvailable = false;
            this.currentVersion = "";
            this.newVersion = "";
            this.changelog = "";
            this.modrinthUrl = "";
            this.modrinthName = "";
            LOGGER.warn("Skipping update check - configuration not properly set up: {}", (Object)info.getValidationError());
            return UpdateCheckResult.error("Configuration not properly set up: " + info.getValidationError());
        }
        UpdateCheckResult result = updateManager.checkForUpdates(info);
        if (!result.isSuccess()) {
            LOGGER.error("Update check failed: {}", (Object)result.getErrorMessage());
            return result;
        }
        this.updateAvailable = result.isUpdateAvailable();
        this.currentVersion = info.getVersion();
        this.newVersion = result.getVersionNumber();
        this.changelog = result.getChangelog();
        this.modrinthUrl = result.getModrinthUrl();
        this.modrinthName = info.getName();
        return result;
    }

    public static int compareVersions(String v1, String v2) {
        String[] parts1 = v1.replaceAll("[^0-9.]", "").split("\\.");
        String[] parts2 = v2.replaceAll("[^0-9.]", "").split("\\.");
        int maxLength = Math.max(parts1.length, parts2.length);
        for (int i = 0; i < maxLength; ++i) {
            int p2;
            int p1 = i < parts1.length ? Integer.parseInt(parts1[i]) : 0;
            int n = p2 = i < parts2.length ? Integer.parseInt(parts2[i]) : 0;
            if (p1 == p2) continue;
            return p1 - p2;
        }
        return 0;
    }
}

