/*
 * Decompiled with CFR 0.152.
 */
package com.github.kd_gaming1.packcore.util;

import com.github.kd_gaming1.packcore.util.PackCoreFileManager;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.loader.api.FabricLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarkdownFileUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"packcore");
    private static final Path runDir = FabricLoader.getInstance().getGameDir();
    private static final Path INFO_HELP_DIR = runDir.resolve("packcore/info_help");

    public static String readMarkdownFile(String fileName) {
        return MarkdownFileUtil.readMarkdownFile(fileName, MarkdownFileUtil.getDefaultContent(fileName));
    }

    public static String readMarkdownFile(String fileName, String fallbackContent) {
        MarkdownFileUtil.ensureDirectoryExists();
        Path filePath = INFO_HELP_DIR.resolve(fileName);
        if (!Files.exists(filePath, new LinkOption[0])) {
            LOGGER.warn("Could not find {}, using fallback content", (Object)fileName);
            return MarkdownFileUtil.createMissingFileContent(fileName, fallbackContent);
        }
        try {
            return Files.readString(filePath);
        }
        catch (IOException e) {
            LOGGER.error("Failed to read markdown file: {}", (Object)fileName, (Object)e);
            return MarkdownFileUtil.createErrorContent(fileName, e.getMessage());
        }
    }

    private static void ensureDirectoryExists() {
        try {
            if (!Files.exists(INFO_HELP_DIR, new LinkOption[0])) {
                Files.createDirectories(INFO_HELP_DIR, new FileAttribute[0]);
                LOGGER.info("Created directory: {}", (Object)INFO_HELP_DIR);
            }
        }
        catch (IOException e) {
            LOGGER.error("Failed to create directory: {}", (Object)INFO_HELP_DIR, (Object)e);
        }
    }

    private static String createMissingFileContent(String fileName, String fallbackContent) {
        return "# Missing File: %s\n\n> **File not found** in the `packcore/info_help` folder.\n>\n> Expected location: `%s`\n\n## Default Content:\n\n%s\n\n---\n\n> **To fix this:** Create the file `%s` in your game directory at `packcore/info_help/%s`\n".formatted(fileName, INFO_HELP_DIR.resolve(fileName), fallbackContent, fileName, fileName);
    }

    private static String createErrorContent(String fileName, String errorMessage) {
        return "# Error Loading: %s\n\n> **Error occurred** while reading the file.\n\n**Error message:** %s\n\n---\n\n> **To fix this:** Check that the file `packcore/info_help/%s` exists and is readable.\n".formatted(fileName, errorMessage, fileName);
    }

    private static String getDefaultContent(String fileName) {
        return switch (fileName.toLowerCase()) {
            case "welcome.md" -> "# Welcome\n\nWelcome to PackCore! This is the default welcome content.\n";
            case "resourcepacks.md" -> "# Resource Packs\n\nInformation about available resource packs will be shown here.\n";
            default -> "# %s\n\nThis is placeholder content for %s.\n".formatted(fileName.replace(".md", ""), fileName);
        };
    }

    public static String readMarkdownFileSafe(String directory, String fileName, String fallbackContent) {
        return PackCoreFileManager.getMarkdownContentSafe(directory, fileName, fallbackContent);
    }
}

