/*
 * Decompiled with CFR 0.152.
 */
package com.github.kd_gaming1.packcore.util.config;

import com.github.kd_gaming1.packcore.util.config.PerformanceProfileUtil;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_4063;
import net.minecraft.class_4066;
import net.minecraft.class_5365;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinecraftIntegration {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"packcore");

    public static boolean applyProfile(PerformanceProfileUtil.PerformanceProfile profile) {
        try {
            class_315 options = MinecraftIntegration.getValidatedOptions();
            if (options == null) {
                return false;
            }
            switch (profile) {
                case PERFORMANCE: {
                    MinecraftIntegration.applyPerformanceSettings(options);
                    break;
                }
                case BALANCED: {
                    MinecraftIntegration.applyBalancedSettings(options);
                    break;
                }
                case QUALITY: 
                case SHADERS: {
                    MinecraftIntegration.applyQualitySettings(options);
                    break;
                }
                default: {
                    LOGGER.warn("Unknown profile: {}", (Object)profile);
                    return false;
                }
            }
            options.method_1640();
            LOGGER.debug("Minecraft profile '{}' applied successfully", (Object)profile.name());
            return true;
        }
        catch (Exception e) {
            LOGGER.error("Failed to apply Minecraft profile", (Throwable)e);
            return false;
        }
    }

    public static boolean restoreDefaults() {
        try {
            class_315 options = MinecraftIntegration.getValidatedOptions();
            if (options == null) {
                return false;
            }
            options.method_42534().method_41748((Object)class_5365.field_25428);
            options.method_42503().method_41748((Object)12);
            options.method_42510().method_41748((Object)12);
            options.method_42517().method_41748((Object)1.0);
            options.method_42524().method_41748((Object)120);
            options.method_42433().method_41748((Object)false);
            options.method_41805().method_41748((Object)2);
            options.method_42435().method_41748((Object)true);
            options.method_42528().method_41748((Object)class_4063.field_18164);
            options.method_41792().method_41748((Object)true);
            options.method_1640();
            LOGGER.debug("Minecraft default settings restored");
            return true;
        }
        catch (Exception e) {
            LOGGER.error("Failed to restore Minecraft defaults", (Throwable)e);
            return false;
        }
    }

    private static class_315 getValidatedOptions() {
        class_310 client = class_310.method_1551();
        if (client == null) {
            LOGGER.warn("MinecraftClient is null, cannot apply profile");
            return null;
        }
        class_315 options = client.field_1690;
        if (options == null) {
            LOGGER.warn("GameOptions is null, cannot apply profile");
            return null;
        }
        return options;
    }

    private static void applyPerformanceSettings(class_315 options) {
        options.method_41792().method_41748((Object)true);
        options.method_41805().method_41748((Object)2);
        options.method_42433().method_41748((Object)false);
        options.method_42517().method_41748((Object)1.0);
        options.method_42435().method_41748((Object)false);
        options.method_42534().method_41748((Object)class_5365.field_25427);
        options.method_42524().method_41748((Object)260);
        options.method_42563().method_41748((Object)2);
        options.method_42475().method_41748((Object)class_4066.field_18199);
        options.method_42528().method_41748((Object)class_4063.field_18163);
        options.method_42503().method_41748((Object)10);
        options.method_42510().method_41748((Object)10);
        LOGGER.debug("Applied Minecraft performance settings");
    }

    private static void applyBalancedSettings(class_315 options) {
        options.method_41792().method_41748((Object)true);
        options.method_41805().method_41748((Object)2);
        options.method_42433().method_41748((Object)false);
        options.method_42517().method_41748((Object)1.0);
        options.method_42435().method_41748((Object)true);
        options.method_42534().method_41748((Object)class_5365.field_25428);
        options.method_42524().method_41748((Object)260);
        options.method_42563().method_41748((Object)4);
        options.method_42475().method_41748((Object)class_4066.field_18197);
        options.method_42528().method_41748((Object)class_4063.field_18164);
        options.method_42503().method_41748((Object)14);
        options.method_42510().method_41748((Object)12);
        LOGGER.debug("Applied Minecraft balanced settings");
    }

    private static void applyQualitySettings(class_315 options) {
        options.method_41792().method_41748((Object)true);
        options.method_41805().method_41748((Object)2);
        options.method_42433().method_41748((Object)false);
        options.method_42517().method_41748((Object)1.25);
        options.method_42435().method_41748((Object)true);
        options.method_42534().method_41748((Object)class_5365.field_25429);
        options.method_42524().method_41748((Object)260);
        options.method_42563().method_41748((Object)4);
        options.method_42475().method_41748((Object)class_4066.field_18197);
        options.method_42528().method_41748((Object)class_4063.field_18164);
        options.method_42503().method_41748((Object)16);
        options.method_42510().method_41748((Object)12);
        LOGGER.debug("Applied Minecraft quality settings");
    }
}

