/*
 * Decompiled with CFR 0.152.
 */
package com.github.kd_gaming1.packcore.util.config;

import com.github.kd_gaming1.packcore.util.config.IrisIntegration;
import com.github.kd_gaming1.packcore.util.config.MinecraftIntegration;
import com.github.kd_gaming1.packcore.util.config.SodiumIntegration;
import java.util.Objects;
import net.fabricmc.loader.api.FabricLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerformanceProfileUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"packcore");
    private static final String SODIUM_MOD_ID = "sodium";
    private static final String IRIS_MOD_ID = "iris";

    public static ProfileResult applyPerformanceProfile(PerformanceProfile profile) {
        LOGGER.info("Applying performance profile: {}", (Object)profile.getDisplayName());
        ProfileResult result = new ProfileResult();
        result.setSodiumApplied(PerformanceProfileUtil.applySystemProfile(() -> SodiumIntegration.applyProfile(profile), "Sodium", PerformanceProfileUtil.isSodiumAvailable()));
        result.setVanillaApplied(PerformanceProfileUtil.applySystemProfile(() -> MinecraftIntegration.applyProfile(profile), "Vanilla Minecraft", true));
        result.setIrisApplied(PerformanceProfileUtil.applySystemProfile(() -> PerformanceProfileUtil.applyIrisSettings(profile), "Iris shader", PerformanceProfileUtil.isIrisAvailable() || profile == PerformanceProfile.SHADERS));
        return result;
    }

    private static boolean applySystemProfile(SystemProfileApplier applier, String systemName, boolean shouldApply) {
        if (!shouldApply) {
            LOGGER.debug("{} not available, skipping profile", (Object)systemName);
            return true;
        }
        try {
            boolean success = applier.apply();
            if (success) {
                LOGGER.info("{} profile applied successfully", (Object)systemName);
            } else {
                LOGGER.warn("Failed to apply {} profile", (Object)systemName);
            }
            return success;
        }
        catch (Throwable t) {
            LOGGER.error("Error applying {} profile", (Object)systemName, (Object)t);
            return false;
        }
    }

    private static boolean applyIrisSettings(PerformanceProfile profile) {
        if (!PerformanceProfileUtil.isIrisAvailable() && profile == PerformanceProfile.SHADERS) {
            LOGGER.warn("Shaders profile selected but Iris is not available");
            return false;
        }
        if (Objects.requireNonNull(profile) == PerformanceProfile.SHADERS) {
            return IrisIntegration.setShaderPack("ComplementaryUnbound");
        }
        return IrisIntegration.disableShaders();
    }

    public static ProfileResult restoreDefaults() {
        LOGGER.info("Restoring default settings");
        ProfileResult result = new ProfileResult();
        result.setSodiumApplied(PerformanceProfileUtil.applySystemProfile(SodiumIntegration::restoreDefaults, "Sodium", PerformanceProfileUtil.isSodiumAvailable()));
        result.setVanillaApplied(PerformanceProfileUtil.applySystemProfile(MinecraftIntegration::restoreDefaults, "Vanilla", true));
        result.setIrisApplied(PerformanceProfileUtil.applySystemProfile(IrisIntegration::disableShaders, "Iris", PerformanceProfileUtil.isIrisAvailable()));
        return result;
    }

    public static SystemAvailability getSystemAvailability() {
        return new SystemAvailability(PerformanceProfileUtil.isSodiumAvailable(), true, PerformanceProfileUtil.isIrisAvailable());
    }

    private static boolean isSodiumAvailable() {
        return FabricLoader.getInstance().isModLoaded(SODIUM_MOD_ID);
    }

    private static boolean isIrisAvailable() {
        return FabricLoader.getInstance().isModLoaded(IRIS_MOD_ID);
    }

    public static enum PerformanceProfile {
        PERFORMANCE("Maximum Performance", "Optimized for highest FPS"),
        BALANCED("Balanced", "Good balance between performance and quality"),
        QUALITY("Best Quality", "Optimized for visual quality"),
        SHADERS("Shaders", "Ultimate visual experience with shaders enabled");

        private final String displayName;
        private final String description;

        private PerformanceProfile(String displayName, String description) {
            this.displayName = displayName;
            this.description = description;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getDescription() {
            return this.description;
        }
    }

    public static class ProfileResult {
        private boolean sodiumApplied = false;
        private boolean vanillaApplied = false;
        private boolean irisApplied = false;
        private final boolean sodiumAvailable = this.isSodiumAvailable();
        private final boolean irisAvailable = this.isIrisAvailable();

        public boolean isSodiumApplied() {
            return this.sodiumApplied;
        }

        public boolean isVanillaApplied() {
            return this.vanillaApplied;
        }

        public boolean isIrisApplied() {
            return this.irisApplied;
        }

        public boolean isSodiumAvailable() {
            return this.sodiumAvailable;
        }

        public boolean isIrisAvailable() {
            return this.irisAvailable;
        }

        void setSodiumApplied(boolean applied) {
            this.sodiumApplied = applied;
        }

        void setVanillaApplied(boolean applied) {
            this.vanillaApplied = applied;
        }

        void setIrisApplied(boolean applied) {
            this.irisApplied = applied;
        }

        public boolean isFullySuccessful() {
            return !(!this.vanillaApplied || this.sodiumAvailable && !this.sodiumApplied || this.irisAvailable && !this.irisApplied);
        }

        public boolean hasAnyFailures() {
            return !this.vanillaApplied || this.sodiumAvailable && !this.sodiumApplied || this.irisAvailable && !this.irisApplied;
        }
    }

    @FunctionalInterface
    private static interface SystemProfileApplier {
        public boolean apply() throws Exception;
    }

    public record SystemAvailability(boolean sodiumAvailable, boolean vanillaAvailable, boolean irisAvailable) {
        public boolean hasAnySystem() {
            return this.sodiumAvailable || this.vanillaAvailable || this.irisAvailable;
        }
    }
}

