/*
 * Decompiled with CFR 0.152.
 */
package com.github.kd_gaming1.packcore.util.copysystem;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipFiles {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZipFiles.class);

    public void zipDirectory(File dir, String zipFilePath, ProgressCallback progressCallback) {
        Path base = dir.toPath();
        try (Stream<Path> walk = Files.walk(base, new FileVisitOption[0]);){
            long totalSize = walk.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).mapToLong(p -> {
                try {
                    return Files.size(p);
                }
                catch (IOException e) {
                    return 0L;
                }
            }).sum();
            long[] processed = new long[]{0L};
            try (FileOutputStream fos = new FileOutputStream(zipFilePath);
                 BufferedOutputStream bos = new BufferedOutputStream(fos);
                 ZipOutputStream zos = new ZipOutputStream(bos);){
                byte[] buffer = new byte[8192];
                try (Stream<Path> files = Files.walk(base, new FileVisitOption[0]);){
                    files.forEach(path -> {
                        block11: {
                            try {
                                Path rel = base.relativize((Path)path);
                                Object entryName = rel.toString().replace(File.separatorChar, '/');
                                if (Files.isDirectory(path, new LinkOption[0])) {
                                    if (!((String)entryName).endsWith("/")) {
                                        entryName = (String)entryName + "/";
                                    }
                                    ZipEntry dirEntry = new ZipEntry((String)entryName);
                                    zos.putNextEntry(dirEntry);
                                    zos.closeEntry();
                                    break block11;
                                }
                                ZipEntry ze = new ZipEntry((String)entryName);
                                zos.putNextEntry(ze);
                                try (InputStream in = Files.newInputStream(path, new OpenOption[0]);){
                                    int len;
                                    while ((len = in.read(buffer)) > 0) {
                                        zos.write(buffer, 0, len);
                                        processed[0] = processed[0] + (long)len;
                                        if (progressCallback == null || totalSize <= 0L) continue;
                                        int percentage = (int)(processed[0] * 100L / totalSize);
                                        progressCallback.onProgress(processed[0], totalSize, percentage);
                                    }
                                }
                                zos.closeEntry();
                            }
                            catch (IOException e) {
                                LOGGER.error("Failed zipping path: {}", path, (Object)e);
                            }
                        }
                    });
                }
            }
        }
        catch (IOException e) {
            LOGGER.error("Failed to zip files", (Throwable)e);
        }
    }

    public static void zipSingleFile(File file, String zipFileName, ProgressCallback progressCallback) {
        try {
            long totalSize = file.length();
            long processed = 0L;
            try (FileOutputStream fos = new FileOutputStream(zipFileName);
                 ZipOutputStream zos = new ZipOutputStream(new BufferedOutputStream(fos));
                 FileInputStream fis = new FileInputStream(file);){
                int len;
                ZipEntry ze = new ZipEntry(file.getName());
                zos.putNextEntry(ze);
                byte[] buffer = new byte[8192];
                while ((len = fis.read(buffer)) > 0) {
                    zos.write(buffer, 0, len);
                    processed += (long)len;
                    if (progressCallback == null || totalSize <= 0L) continue;
                    int percentage = (int)(processed * 100L / totalSize);
                    progressCallback.onProgress(processed, totalSize, percentage);
                }
                zos.closeEntry();
                LOGGER.info("{} is zipped to {}", (Object)file.getCanonicalPath(), (Object)zipFileName);
            }
        }
        catch (IOException e) {
            LOGGER.error("Failed to zip file", (Throwable)e);
        }
    }

    public static interface ProgressCallback {
        public void onProgress(long var1, long var3, int var5);
    }
}

