/*
 * Decompiled with CFR 0.152.
 */
package com.github.kd_gaming1.packcore.util.modpack;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import net.fabricmc.loader.api.FabricLoader;

public class ModpackInfo {
    @SerializedName(value="_comment")
    private String comment = "Edit the values below for your modpack. Remove this _comment field when done.";
    @SerializedName(value="mod_name")
    private String modName = "YOUR_MODPACK_NAME_HERE";
    @SerializedName(value="mod_version")
    private String modVersion = "1.0.0";
    @SerializedName(value="minecraft_version")
    private String minecraftVersion = "1.21.+";
    @SerializedName(value="author")
    private String author = "YOUR_NAME_HERE";
    @SerializedName(value="description")
    private String description = "A brief description of your modpack";
    @SerializedName(value="modrinth_project_id")
    private String modrinthProjectId = "YOUR_PROJECT_ID_FROM_MODRINTH_URL";
    @SerializedName(value="update_channel")
    private String updateChannel = "release";
    @SerializedName(value="website")
    private String website = "https://your-website.com";
    @SerializedName(value="discord")
    private String discord = "https://discord.gg/your-invite";
    @SerializedName(value="issue_tracker")
    private String issueTracker = "https://github.com/yourname/yourmod/issues";
    @SerializedName(value="wiki")
    private String wiki = "https://your-wiki-url.com";
    private static final String CONFIG_FILE_NAME = "modpack-info.json";
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private static final Path runDir = FabricLoader.getInstance().getGameDir();
    private static final Path packcoreDir = runDir.resolve("packcore");
    private transient Path configDirectory;

    public void saveToFile(Path packcoreDir) throws IOException {
        Path filePath = packcoreDir.resolve(CONFIG_FILE_NAME);
        try (FileWriter writer = new FileWriter(filePath.toFile());){
            gson.toJson((Object)this, (Appendable)writer);
        }
    }

    public static ModpackInfo loadFromFile(Path packcoreDir) throws IOException {
        Path filePath = packcoreDir.resolve(CONFIG_FILE_NAME);
        if (!Files.exists(filePath, new LinkOption[0])) {
            ModpackInfo defaultInfo = new ModpackInfo();
            defaultInfo.setConfigDirectory(packcoreDir);
            defaultInfo.saveToFile(packcoreDir);
            return defaultInfo;
        }
        try (FileReader reader = new FileReader(filePath.toFile());){
            ModpackInfo info = (ModpackInfo)gson.fromJson((Reader)reader, ModpackInfo.class);
            info.setConfigDirectory(packcoreDir);
            ModpackInfo modpackInfo = info;
            return modpackInfo;
        }
    }

    public void setConfigDirectory(Path configDir) {
        this.configDirectory = configDir;
    }

    private void autoSave() {
        if (this.configDirectory != null) {
            try {
                this.saveToFile(this.configDirectory);
            }
            catch (IOException e) {
                System.err.println("Failed to auto-save modpack info: " + e.getMessage());
            }
        }
    }

    public boolean isConfigurationValid() {
        return this.modrinthProjectId.equals("YOUR_PROJECT_ID_FROM_MODRINTH_URL") || this.modrinthProjectId.trim().isEmpty() || this.modName.equals("YOUR_MODPACK_NAME_HERE") || this.author.equals("YOUR_NAME_HERE");
    }

    public String getValidationError() {
        if (this.modrinthProjectId.equals("YOUR_PROJECT_ID_FROM_MODRINTH_URL")) {
            return "Modrinth project ID is not configured. Please set a valid project ID.";
        }
        if (this.modrinthProjectId.trim().isEmpty()) {
            return "Modrinth project ID is empty.";
        }
        if (this.modName.equals("YOUR_MODPACK_NAME_HERE")) {
            return "Mod name is not configured.";
        }
        if (this.author.equals("YOUR_NAME_HERE")) {
            return "Author is not configured.";
        }
        return null;
    }

    public String getName() {
        return this.modName;
    }

    public String getVersion() {
        return this.modVersion;
    }

    public String getMinecraftVersion() {
        return this.minecraftVersion;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getDescription() {
        return this.description;
    }

    public String getModrinthProjectId() {
        return this.modrinthProjectId;
    }

    public String getUpdateChannel() {
        return this.updateChannel;
    }

    public String getWebsite() {
        return this.website;
    }

    public String getDiscord() {
        return this.discord;
    }

    public String getIssueTracker() {
        return this.issueTracker;
    }

    public String getWiki() {
        return this.wiki;
    }

    public void setName(String name) {
        this.modName = name;
        this.autoSave();
    }

    public void setVersion(String version) {
        this.modVersion = version;
        this.autoSave();
    }

    public void setMinecraftVersion(String version) {
        this.minecraftVersion = version;
        this.autoSave();
    }

    public void setAuthor(String author) {
        this.author = author;
        this.autoSave();
    }

    public void setDescription(String description) {
        this.description = description;
        this.autoSave();
    }

    public void setModrinthProjectId(String id) {
        this.modrinthProjectId = id;
        this.autoSave();
    }

    public void setUpdateChannel(String channel) {
        this.updateChannel = channel;
        this.autoSave();
    }

    public void setWebsite(String website) {
        this.website = website;
        this.autoSave();
    }

    public void setDiscord(String discord) {
        this.discord = discord;
        this.autoSave();
    }

    public void setIssueTracker(String tracker) {
        this.issueTracker = tracker;
        this.autoSave();
    }

    public void setWiki(String wiki) {
        this.wiki = wiki;
        this.autoSave();
    }
}

