/*
 * Decompiled with CFR 0.152.
 */
package com.github.kd_gaming1.packcore.gui.configscreen;

import com.github.kd_gaming1.packcore.PackCore;
import com.github.kd_gaming1.packcore.gui.configscreen.BackupManagementScreen;
import com.github.kd_gaming1.packcore.gui.configscreen.ConfigExportScreen;
import com.github.kd_gaming1.packcore.gui.configscreen.ModpackConfigMenuScreen;
import com.github.kd_gaming1.packcore.gui.ui.UITheme;
import com.github.kd_gaming1.packcore.gui.util.UiSurfaces;
import com.github.kd_gaming1.packcore.util.ConfigImportManager;
import com.github.kd_gaming1.packcore.util.ConfigMetadata;
import com.github.kd_gaming1.packcore.util.ImportCallback;
import io.wispforest.owo.ui.base.BaseOwoScreen;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.component.CheckboxComponent;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.container.OverlayContainer;
import io.wispforest.owo.ui.container.ScrollContainer;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.OwoUIAdapter;
import io.wispforest.owo.ui.core.Positioning;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.core.VerticalAlignment;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigImportScreen
extends BaseOwoScreen<FlowLayout> {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"packcore");
    private Path selectedFile = null;
    private ConfigMetadata previewMetadata = null;
    private LabelComponent selectedFileLabel;
    private LabelComponent statusLabel;
    private FlowLayout previewContainer;
    private CheckboxComponent applyImmediatelyCheckbox;
    private ButtonComponent importButton;
    private FlowLayout progressPanel;
    private FlowLayout rootComponent;
    private OverlayContainer<FlowLayout> currentOverlay = null;

    @NotNull
    protected OwoUIAdapter<FlowLayout> createAdapter() {
        return OwoUIAdapter.create((class_437)this, Containers::verticalFlow);
    }

    protected void build(FlowLayout rootComponent) {
        this.rootComponent = rootComponent;
        rootComponent.surface(UiSurfaces.stretched(class_2960.method_60655((String)"packcore", (String)"textures/gui/wizard/welcome_bg.png"), 1920, 1082));
        rootComponent.padding(Insets.of((int)8));
        rootComponent.child((Component)this.createHeader());
        rootComponent.child((Component)this.createContent());
    }

    private FlowLayout createHeader() {
        FlowLayout header = Containers.horizontalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.fixed((int)50));
        header.gap(8);
        header.verticalAlignment(VerticalAlignment.CENTER);
        header.child((Component)Components.texture((class_2960)class_2960.method_60655((String)"packcore", (String)"textures/gui/assets/sbe_logo.png"), (int)0, (int)0, (int)40, (int)40, (int)40, (int)40));
        header.child((Component)Components.label((class_2561)class_2561.method_43470((String)("Import Configuration - " + PackCore.getModpackInfo().getName())).method_27694(s -> s.method_27704(class_2960.method_60655((String)"packcore", (String)"gallaeciaforte")))).color(UITheme.color(0xFFFFFF)));
        return BackupManagementScreen.getFlowLayout(header);
    }

    private FlowLayout createContent() {
        FlowLayout content = Containers.horizontalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.expand());
        content.gap(8);
        content.child((Component)this.createSidebar());
        content.child((Component)this.createPreviewPanel());
        return content;
    }

    private FlowLayout createSidebar() {
        FlowLayout sidebar = Containers.verticalFlow((Sizing)Sizing.fill((int)35), (Sizing)Sizing.expand());
        sidebar.surface(UiSurfaces.stretched(class_2960.method_60655((String)"packcore", (String)"textures/gui/menu/notif_box.png"), 607, 755));
        sidebar.padding(Insets.of((int)12));
        FlowLayout scrollContent = Containers.verticalFlow((Sizing)Sizing.fill((int)98), (Sizing)Sizing.content());
        scrollContent.gap(8);
        FlowLayout instructionsContainer = Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content());
        instructionsContainer.padding(Insets.of((int)8));
        instructionsContainer.child((Component)Components.label((class_2561)class_2561.method_43470((String)"Select a configuration ZIP file to import into your modpack.")).color(UITheme.color(0xFFFFFF)));
        scrollContent.child((Component)instructionsContainer);
        FlowLayout fileSection = Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content());
        fileSection.gap(6);
        fileSection.surface(Surface.flat((int)-1072031206).and(Surface.outline((int)-10496)));
        fileSection.padding(Insets.of((int)8));
        fileSection.horizontalAlignment(HorizontalAlignment.CENTER);
        fileSection.child((Component)Components.label((class_2561)class_2561.method_43470((String)"Select File").method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)))).color(UITheme.color(-10496)));
        fileSection.child(Components.button((class_2561)class_2561.method_43470((String)"Browse Files"), btn -> this.selectConfigFile()).renderer(ButtonComponent.Renderer.texture((class_2960)class_2960.method_60655((String)"packcore", (String)"textures/gui/wizard/button.png"), (int)0, (int)0, (int)120, (int)63)).sizing(Sizing.fixed((int)120), Sizing.fixed((int)21)));
        this.selectedFileLabel = Components.label((class_2561)class_2561.method_43470((String)"No file selected")).color(UITheme.color(0xB9BBBE));
        fileSection.child((Component)this.selectedFileLabel);
        scrollContent.child((Component)fileSection);
        FlowLayout statusSection = Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content());
        statusSection.gap(6);
        statusSection.surface(Surface.flat((int)-1072031206).and(Surface.outline((int)-10496)));
        statusSection.padding(Insets.of((int)8));
        statusSection.child((Component)Components.label((class_2561)class_2561.method_43470((String)"Status").method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)))).color(UITheme.color(-10496)));
        this.statusLabel = Components.label((class_2561)class_2561.method_43470((String)"Ready")).color(UITheme.color(0xB9BBBE));
        statusSection.child((Component)this.statusLabel);
        this.progressPanel = Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content());
        statusSection.child((Component)this.progressPanel);
        scrollContent.child((Component)statusSection);
        FlowLayout optionsSection = Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content());
        optionsSection.gap(6);
        optionsSection.surface(Surface.flat((int)-1072031206).and(Surface.outline((int)-10496)));
        optionsSection.padding(Insets.of((int)8));
        optionsSection.child((Component)Components.label((class_2561)class_2561.method_43470((String)"Import Options").method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)))).color(UITheme.color(-10496)));
        this.applyImmediatelyCheckbox = Components.checkbox((class_2561)class_2561.method_43470((String)"Apply Immediately"));
        this.applyImmediatelyCheckbox.checked(false);
        this.applyImmediatelyCheckbox.tooltip((class_2561)class_2561.method_43470((String)"If checked, the game will restart and apply this configuration"));
        optionsSection.child((Component)this.applyImmediatelyCheckbox);
        this.importButton = (ButtonComponent)Components.button((class_2561)class_2561.method_43470((String)"Import"), btn -> this.handleImportClick()).renderer(ButtonComponent.Renderer.texture((class_2960)class_2960.method_60655((String)"packcore", (String)"textures/gui/wizard/button.png"), (int)0, (int)0, (int)100, (int)60)).sizing(Sizing.fixed((int)100), Sizing.fixed((int)20));
        this.importButton.active(false);
        optionsSection.child((Component)this.importButton);
        scrollContent.child((Component)optionsSection);
        ScrollContainer scrollContainer = Containers.verticalScroll((Sizing)Sizing.fill((int)98), (Sizing)Sizing.expand(), (Component)scrollContent);
        scrollContainer.scrollbar(ScrollContainer.Scrollbar.vanilla());
        sidebar.child((Component)scrollContainer);
        return sidebar;
    }

    private FlowLayout createPreviewPanel() {
        this.previewContainer = Containers.verticalFlow((Sizing)Sizing.fill((int)65), (Sizing)Sizing.expand());
        this.previewContainer.gap(8);
        this.previewContainer.surface(UiSurfaces.stretched(class_2960.method_60655((String)"packcore", (String)"textures/gui/menu/info_box.png"), 1142, 934));
        this.previewContainer.padding(Insets.of((int)14));
        this.showEmptyState();
        return this.previewContainer;
    }

    private void showEmptyState() {
        this.previewContainer.clearChildren();
        this.previewContainer.horizontalAlignment(HorizontalAlignment.CENTER);
        this.previewContainer.verticalAlignment(VerticalAlignment.CENTER);
        this.previewContainer.child((Component)Components.label((class_2561)class_2561.method_43470((String)"Configuration Preview").method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)))).color(UITheme.color(-10496)));
        this.previewContainer.child((Component)Components.label((class_2561)class_2561.method_43470((String)"Select a file to preview its contents")).color(UITheme.color(0xB9BBBE)));
    }

    private void selectConfigFile() {
        this.statusLabel.text((class_2561)class_2561.method_43470((String)"Opening file browser..."));
        ((CompletableFuture)ConfigImportManager.selectConfigFile().thenAccept(path -> class_310.method_1551().execute(() -> {
            if (path != null) {
                this.selectedFile = path;
                this.selectedFileLabel.text((class_2561)class_2561.method_43470((String)path.getFileName().toString()));
                this.selectedFileLabel.color(UITheme.color(0xFFFFFF));
                this.previewFile();
            } else {
                this.statusLabel.text((class_2561)class_2561.method_43470((String)"Selection cancelled"));
            }
        }))).exceptionally(throwable -> {
            class_310.method_1551().execute(() -> {
                this.statusLabel.text((class_2561)class_2561.method_43470((String)("Error: " + throwable.getMessage())));
                this.statusLabel.color(UITheme.color(-45745));
            });
            return null;
        });
    }

    private void previewFile() {
        if (this.selectedFile == null) {
            return;
        }
        this.statusLabel.text((class_2561)class_2561.method_43470((String)"Reading metadata..."));
        this.previewMetadata = ConfigImportManager.previewConfig(this.selectedFile);
        if (this.previewMetadata != null) {
            this.showPreview();
            this.importButton.active(true);
            this.statusLabel.text((class_2561)class_2561.method_43470((String)"Ready to import"));
            this.statusLabel.color(UITheme.color(-11353062));
        } else {
            this.statusLabel.text((class_2561)class_2561.method_43470((String)"Could not read file"));
            this.statusLabel.color(UITheme.color(-45745));
            this.importButton.active(false);
        }
    }

    private void showPreview() {
        if (this.previewMetadata == null) {
            return;
        }
        this.previewContainer.clearChildren();
        this.previewContainer.horizontalAlignment(HorizontalAlignment.LEFT);
        this.previewContainer.verticalAlignment(VerticalAlignment.TOP);
        this.previewContainer.child((Component)Components.label((class_2561)class_2561.method_43470((String)this.previewMetadata.getName()).method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)))).color(UITheme.color(-10496)));
        FlowLayout infoBox = Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content());
        infoBox.gap(4);
        infoBox.surface(Surface.flat((int)-1072031206).and(Surface.outline((int)-11184811)));
        infoBox.padding(Insets.of((int)8));
        infoBox.child((Component)this.createInfoRow("Version:", this.previewMetadata.getVersion()));
        infoBox.child((Component)this.createInfoRow("Author:", this.previewMetadata.getAuthor()));
        infoBox.child((Component)this.createInfoRow("Resolution:", this.previewMetadata.getTargetResolution()));
        if (this.previewMetadata.getCreatedDate() != null && !this.previewMetadata.getCreatedDate().isEmpty()) {
            infoBox.child((Component)this.createInfoRow("Created:", this.formatDate(this.previewMetadata.getCreatedDate())));
        }
        this.previewContainer.child((Component)infoBox);
        if (this.previewMetadata.getDescription() != null && !this.previewMetadata.getDescription().isEmpty()) {
            this.previewContainer.child((Component)Components.label((class_2561)class_2561.method_43470((String)"Description:").method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)))).color(UITheme.color(-10496)));
            this.previewContainer.child(Components.label((class_2561)class_2561.method_43470((String)this.previewMetadata.getDescription())).color(UITheme.color(0xFFFFFF)).sizing(Sizing.fill((int)95), Sizing.content()));
        }
        if (this.previewMetadata.getMods() != null && !this.previewMetadata.getMods().isEmpty()) {
            this.previewContainer.child((Component)Components.label((class_2561)class_2561.method_43470((String)"Included Mods:").method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)))).color(UITheme.color(-10496)));
            FlowLayout modsContainer = Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content());
            modsContainer.gap(2);
            modsContainer.surface(Surface.flat((int)-1070978518).and(Surface.outline((int)-11184811)));
            modsContainer.padding(Insets.of((int)8));
            int displayCount = Math.min(10, this.previewMetadata.getMods().size());
            for (int i = 0; i < displayCount; ++i) {
                modsContainer.child((Component)Components.label((class_2561)class_2561.method_43470((String)("\u2022 " + this.previewMetadata.getMods().get(i)))).color(UITheme.color(0xFFFFFF)));
            }
            if (this.previewMetadata.getMods().size() > displayCount) {
                modsContainer.child((Component)Components.label((class_2561)class_2561.method_43470((String)("... and " + (this.previewMetadata.getMods().size() - displayCount) + " more"))).color(UITheme.color(0xB9BBBE)));
            }
            ScrollContainer scrollableMods = Containers.verticalScroll((Sizing)Sizing.fill((int)100), (Sizing)Sizing.fixed((int)150), (Component)modsContainer);
            scrollableMods.scrollbar(ScrollContainer.Scrollbar.vanilla());
            this.previewContainer.child((Component)scrollableMods);
        }
    }

    private FlowLayout createInfoRow(String label, String value) {
        return ModpackConfigMenuScreen.getHorizontalFlowLayout(label, value);
    }

    private String formatDate(String isoDate) {
        try {
            return isoDate.replace('T', ' ').substring(0, Math.min(isoDate.length(), 19));
        }
        catch (Exception e) {
            return isoDate;
        }
    }

    private void handleImportClick() {
        if (this.selectedFile == null || this.previewMetadata == null) {
            return;
        }
        if (this.applyImmediatelyCheckbox.method_20372()) {
            this.showRestartWarningDialog();
        } else {
            this.performImport();
        }
    }

    private void showRestartWarningDialog() {
        if (this.selectedFile == null || this.previewMetadata == null) {
            return;
        }
        FlowLayout popup = Containers.verticalFlow((Sizing)Sizing.fixed((int)500), (Sizing)Sizing.content());
        popup.gap(12);
        popup.surface(Surface.flat((int)-1072031206).and(Surface.outline((int)-348908)));
        popup.padding(Insets.of((int)20));
        FlowLayout headerRow = Containers.horizontalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content());
        headerRow.gap(8);
        headerRow.verticalAlignment(VerticalAlignment.CENTER);
        headerRow.child(Components.label((class_2561)class_2561.method_43470((String)"\u26a0")).color(UITheme.color(-348908)).sizing(Sizing.fixed((int)24), Sizing.content()));
        headerRow.child((Component)Components.label((class_2561)class_2561.method_43470((String)"Restart Required").method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)))).color(UITheme.color(-348908)));
        popup.child((Component)headerRow);
        popup.child((Component)Components.label((class_2561)class_2561.method_43470((String)("Configuration: " + this.previewMetadata.getName())).method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)))).color(UITheme.color(0xFFFFFF)));
        FlowLayout warningBox = Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content());
        warningBox.gap(4);
        warningBox.surface(Surface.flat((int)-1070978518).and(Surface.outline((int)-348908)));
        warningBox.padding(Insets.of((int)12));
        warningBox.child((Component)Components.label((class_2561)class_2561.method_43470((String)"This will:")).color(UITheme.color(0xFFFFFF)));
        warningBox.child((Component)Components.label((class_2561)class_2561.method_43470((String)"\u2022 Import and apply the configuration")).color(UITheme.color(0xB9BBBE)));
        warningBox.child((Component)Components.label((class_2561)class_2561.method_43470((String)"\u2022 Restart Minecraft automatically")).color(UITheme.color(0xB9BBBE)));
        warningBox.child((Component)Components.label((class_2561)class_2561.method_43470((String)"\u2022 Replace your current configuration")).color(UITheme.color(0xB9BBBE)));
        popup.child((Component)warningBox);
        FlowLayout backupNotice = Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content());
        backupNotice.gap(4);
        backupNotice.surface(Surface.flat((int)-1067706601).and(Surface.outline((int)-45745)));
        backupNotice.padding(Insets.of((int)12));
        backupNotice.child((Component)Components.label((class_2561)class_2561.method_43470((String)"\u26a0 BACKUP RECOMMENDATION").method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)))).color(UITheme.color(-45745)));
        backupNotice.child(Components.label((class_2561)class_2561.method_43470((String)"Please export your current configuration before proceeding. If you do not export a backup, you will lose your current configuration and cannot revert!")).color(UITheme.color(0xFFFFFF)).sizing(Sizing.fill((int)95), Sizing.content()));
        popup.child((Component)backupNotice);
        FlowLayout buttons = Containers.horizontalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content());
        buttons.gap(12);
        buttons.horizontalAlignment(HorizontalAlignment.CENTER);
        buttons.child(Components.button((class_2561)class_2561.method_43470((String)"Export First"), btn -> {
            this.closeConfirmationDialog();
            class_310.method_1551().method_1507((class_437)new ConfigExportScreen());
        }).renderer(ButtonComponent.Renderer.texture((class_2960)class_2960.method_60655((String)"packcore", (String)"textures/gui/wizard/button.png"), (int)0, (int)0, (int)100, (int)60)).sizing(Sizing.fixed((int)100), Sizing.fixed((int)20)));
        buttons.child(Components.button((class_2561)class_2561.method_43470((String)"Import & Restart"), btn -> {
            this.closeConfirmationDialog();
            this.performImport();
        }).renderer(ButtonComponent.Renderer.texture((class_2960)class_2960.method_60655((String)"packcore", (String)"textures/gui/wizard/button.png"), (int)0, (int)0, (int)100, (int)60)).sizing(Sizing.fixed((int)100), Sizing.fixed((int)20)));
        buttons.child(Components.button((class_2561)class_2561.method_43470((String)"Cancel"), btn -> this.closeConfirmationDialog()).renderer(ButtonComponent.Renderer.texture((class_2960)class_2960.method_60655((String)"packcore", (String)"textures/gui/wizard/button.png"), (int)0, (int)0, (int)100, (int)60)).sizing(Sizing.fixed((int)100), Sizing.fixed((int)20)));
        popup.child((Component)buttons);
        this.currentOverlay = Containers.overlay((Component)popup);
        this.currentOverlay.positioning(Positioning.relative((int)50, (int)40));
        this.currentOverlay.zIndex(15);
        this.rootComponent.child(this.currentOverlay);
    }

    private void closeConfirmationDialog() {
        if (this.currentOverlay != null) {
            this.rootComponent.removeChild(this.currentOverlay);
            this.currentOverlay = null;
        }
    }

    private void performImport() {
        if (this.selectedFile == null || this.previewMetadata == null) {
            return;
        }
        this.importButton.active(false);
        this.progressPanel.clearChildren();
        final boolean applyImmediately = this.applyImmediatelyCheckbox.method_20372();
        ConfigImportManager.importConfig(this.selectedFile, applyImmediately, new ImportCallback(){

            @Override
            public void onProgress(String message, int percentage) {
                class_310.method_1551().execute(() -> {
                    ConfigImportScreen.this.progressPanel.clearChildren();
                    ConfigImportScreen.this.progressPanel.child((Component)Components.label((class_2561)class_2561.method_43470((String)(message + " (" + percentage + "%)"))).color(UITheme.color(-10496)));
                });
            }

            @Override
            public void onComplete(boolean success, String message) {
                class_310.method_1551().execute(() -> {
                    ConfigImportScreen.this.progressPanel.clearChildren();
                    if (success) {
                        ConfigImportScreen.this.statusLabel.text((class_2561)class_2561.method_43470((String)"Success!"));
                        ConfigImportScreen.this.statusLabel.color(UITheme.color(-11353062));
                        if (applyImmediately) {
                            ConfigImportScreen.this.progressPanel.child((Component)Components.label((class_2561)class_2561.method_43470((String)"Game will restart to apply configuration...")).color(UITheme.color(-11353062)));
                        } else {
                            ConfigImportScreen.this.progressPanel.child((Component)Components.label((class_2561)class_2561.method_43470((String)message)).color(UITheme.color(-11353062)));
                            ConfigImportScreen.this.importButton.active(true);
                        }
                    } else {
                        ConfigImportScreen.this.statusLabel.text((class_2561)class_2561.method_43470((String)"Import failed"));
                        ConfigImportScreen.this.statusLabel.color(UITheme.color(-45745));
                        ConfigImportScreen.this.progressPanel.child((Component)Components.label((class_2561)class_2561.method_43470((String)message)).color(UITheme.color(-45745)));
                        ConfigImportScreen.this.importButton.active(true);
                    }
                });
            }
        });
    }
}

