/*
 * Decompiled with CFR 0.152.
 */
package com.github.kd_gaming1.packcore.gui.help;

import com.github.kd_gaming1.packcore.PackCore;
import com.github.kd_gaming1.packcore.config.PackCoreConfig;
import com.github.kd_gaming1.packcore.gui.help.WizardNavigator;
import com.github.kd_gaming1.packcore.gui.util.UiSurfaces;
import com.github.kd_gaming1.packcore.util.ConfigFileUtils;
import com.github.kd_gaming1.packcore.util.modpack.ModpackInfo;
import io.wispforest.owo.ops.TextOps;
import io.wispforest.owo.ui.base.BaseOwoScreen;
import io.wispforest.owo.ui.component.BoxComponent;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.container.OverlayContainer;
import io.wispforest.owo.ui.container.StackLayout;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.OwoUIAdapter;
import io.wispforest.owo.ui.core.Positioning;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.core.VerticalAlignment;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseWizardPage
extends BaseOwoScreen<StackLayout> {
    protected static final int OVERLAY_DARK = Integer.MIN_VALUE;
    protected static final int PANEL_BACKGROUND = -1072031206;
    protected static final int ACCENT_GOLD = -10496;
    protected static final int TEXT_WHITE = 0xFFFFFF;
    protected static final int TEXT_SECONDARY = 0xB9BBBE;
    protected static final int STATUS_SUCCESS_BG = -1070772202;
    protected static final int STATUS_SUCCESS_BORDER = -11353062;
    protected static final int STATUS_WARNING_BG = -1067699433;
    protected static final int STATUS_WARNING_BORDER = -348908;
    protected static final int HEADER_HEIGHT = 35;
    protected static final int CONTENT_PADDING = BaseWizardPage.getScaledPadding();
    protected static final int PROGRESS_BAR_WIDTH = 125;
    protected ButtonComponent primaryButton;
    private boolean primaryButtonInitialActive = true;
    private boolean wizardFailed;
    private StackLayout confirmOverlay;
    private final class_2960 backgroundTexture;
    private final WizardPageInfo pageInfo;
    private static final ModpackInfo info = PackCore.getModpackInfo();

    protected BaseWizardPage(@NotNull WizardPageInfo pageInfo, @Nullable class_2960 backgroundTexture) {
        super(pageInfo.title());
        this.pageInfo = pageInfo;
        this.backgroundTexture = backgroundTexture != null ? backgroundTexture : class_2960.method_60655((String)"packcore", (String)"textures/gui/wizard/welcome_bg.png");
    }

    @NotNull
    protected OwoUIAdapter<StackLayout> createAdapter() {
        return OwoUIAdapter.create((class_437)this, Containers::stack);
    }

    protected final void build(StackLayout rootComponent) {
        rootComponent.surface(UiSurfaces.stretched(this.backgroundTexture, 1920, 1082));
        FlowLayout mainLayout = this.createMainLayout();
        mainLayout.child((Component)this.createHeader());
        if (this.shouldShowStatusInfo()) {
            mainLayout.child((Component)this.createStatusPanel());
        }
        FlowLayout contentContainer = this.createContentContainer();
        this.buildContent(contentContainer);
        mainLayout.child((Component)contentContainer);
        if (this.shouldShowRightPanel()) {
            FlowLayout contentContainerRight = this.createContentContainerRight();
            this.buildContentRight(contentContainerRight);
            mainLayout.child((Component)contentContainerRight);
        }
        mainLayout.child((Component)this.createFooter());
        rootComponent.child((Component)Containers.stack((Sizing)Sizing.fill((int)100), (Sizing)Sizing.fill((int)100)).child((Component)Components.box((Sizing)Sizing.fill((int)100), (Sizing)Sizing.fill((int)100)).color(Color.ofArgb((int)Integer.MIN_VALUE))).child((Component)mainLayout));
        this.confirmOverlay = rootComponent;
    }

    private FlowLayout createMainLayout() {
        return (FlowLayout)Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.fill((int)100)).padding(Insets.of((int)CONTENT_PADDING));
    }

    private FlowLayout createHeader() {
        FlowLayout header = (FlowLayout)Containers.horizontalFlow((Sizing)Sizing.fill((int)this.getContentColumnWidthPercent()), (Sizing)Sizing.fixed((int)35)).padding(Insets.of((int)(CONTENT_PADDING - 6))).verticalAlignment(VerticalAlignment.CENTER);
        LabelComponent titleLabel = (LabelComponent)Components.label((class_2561)this.pageInfo.title.method_27661().method_27694(s -> s.method_27704(class_2960.method_60655((String)"packcore", (String)"gallaeciaforte")))).color(Color.ofRgb((int)-10496)).shadow(true).margins(Insets.of((int)0, (int)0, (int)4, (int)4));
        header.child((Component)titleLabel);
        FlowLayout progressIndicator = (FlowLayout)Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.fill((int)100)).gap(8).verticalAlignment(VerticalAlignment.CENTER);
        progressIndicator.child((Component)Components.label((class_2561)TextOps.withColor((String)("Step " + this.pageInfo.currentStep() + " of " + this.pageInfo.totalSteps()), (int)-10496)));
        progressIndicator.child(this.createProgressBar());
        header.child((Component)progressIndicator);
        return header;
    }

    private Component createProgressBar() {
        FlowLayout progressContainer = (FlowLayout)Containers.horizontalFlow((Sizing)Sizing.fixed((int)125), (Sizing)Sizing.fixed((int)4)).surface(Surface.flat((int)0x40FFFFFF));
        int progressWidth = (int)(125.0 * ((double)this.pageInfo.currentStep() / (double)this.pageInfo.totalSteps()));
        BoxComponent progressFill = Components.box((Sizing)Sizing.fixed((int)progressWidth), (Sizing)Sizing.fill((int)100)).color(Color.ofRgb((int)-10496));
        return Containers.stack((Sizing)Sizing.fixed((int)125), (Sizing)Sizing.fixed((int)4)).child((Component)progressContainer).child((Component)progressFill);
    }

    private FlowLayout createStatusPanel() {
        StatusInfo status = this.getStatusInfo();
        FlowLayout statusPanel = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.fill((int)38), (Sizing)Sizing.content()).gap(8).surface(UiSurfaces.stretched(class_2960.method_60655((String)"packcore", (String)"textures/gui/wizard/small_info_box.png"), 722, 338)).padding(Insets.of((int)10)).verticalAlignment(VerticalAlignment.CENTER).positioning(Positioning.relative((int)100, (int)0));
        FlowLayout messageSection = Containers.verticalFlow((Sizing)Sizing.expand(), (Sizing)Sizing.content()).gap(4);
        FlowLayout headerRow = (FlowLayout)Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).gap(6).verticalAlignment(VerticalAlignment.CENTER);
        headerRow.child((Component)Components.label((class_2561)class_2561.method_43470((String)(status.icon + " " + status.title)).method_10862(class_2583.field_24360.method_10982(Boolean.TRUE))).color(Color.ofRgb((int)0xFFFFFF)));
        messageSection.child((Component)headerRow);
        LabelComponent detailLabel = Components.label((class_2561)class_2561.method_43470((String)status.message).method_10862(class_2583.field_24360)).color(Color.ofRgb((int)0xB9BBBE));
        detailLabel.horizontalSizing(Sizing.fill((int)100));
        messageSection.child((Component)detailLabel);
        if (status.additionalInfo != null) {
            LabelComponent infoLabel = (LabelComponent)Components.label((class_2561)class_2561.method_43470((String)status.additionalInfo).method_10862(class_2583.field_24360.method_10978(Boolean.TRUE))).color(Color.ofRgb((int)0xB9BBBE)).margins(Insets.of((int)2, (int)2, (int)2, (int)2));
            infoLabel.horizontalSizing(Sizing.fill((int)100));
            messageSection.child((Component)infoLabel.margins(Insets.top((int)2)));
        }
        statusPanel.child((Component)messageSection);
        ButtonComponent resetButton = (ButtonComponent)Components.button((class_2561)class_2561.method_43470((String)"Reset Setup"), button -> this.showResetConfirmation()).renderer(ButtonComponent.Renderer.texture((class_2960)class_2960.method_60655((String)"packcore", (String)"textures/gui/wizard/button.png"), (int)0, (int)0, (int)100, (int)60)).horizontalSizing(Sizing.fixed((int)100)).verticalSizing(Sizing.fixed((int)20));
        resetButton.tooltip((class_2561)class_2561.method_43470((String)"Reset the setup wizard and close the game"));
        statusPanel.child((Component)resetButton);
        return statusPanel;
    }

    private void showResetConfirmation() {
        OverlayContainer overlay = Containers.overlay((Component)this.createConfirmDialog());
        overlay.closeOnClick(true);
        overlay.surface(Surface.flat((int)Integer.MIN_VALUE));
        overlay.zIndex(10);
        this.confirmOverlay.child((Component)overlay);
    }

    private FlowLayout createConfirmDialog() {
        FlowLayout dialog = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.fixed((int)350), (Sizing)Sizing.content()).gap(15).surface(Surface.flat((int)-1072031206).and(Surface.outline((int)-348908))).padding(Insets.of((int)20)).positioning(Positioning.relative((int)50, (int)50));
        dialog.child((Component)Components.label((class_2561)class_2561.method_43470((String)"\u26a0 Reset Setup Wizard?").method_10862(class_2583.field_24360.method_10982(Boolean.TRUE))).color(Color.ofRgb((int)-348908)).margins(Insets.of((int)2, (int)2, (int)2, (int)2)));
        LabelComponent message = (LabelComponent)Components.label((class_2561)class_2561.method_43470((String)"This will reset PackCore and close the game. When you reopen it, PackCore will try to apply the configs automatically again.")).color(Color.ofRgb((int)0xFFFFFF)).margins(Insets.of((int)2, (int)2, (int)2, (int)2));
        message.horizontalSizing(Sizing.fill((int)100));
        dialog.child((Component)message);
        LabelComponent warning = (LabelComponent)Components.label((class_2561)class_2561.method_43470((String)"Note: Any manual changes you've made may be lost.").method_10862(class_2583.field_24360.method_10978(Boolean.TRUE))).color(Color.ofRgb((int)-348908)).margins(Insets.of((int)2, (int)2, (int)2, (int)2));
        warning.horizontalSizing(Sizing.fill((int)100));
        dialog.child((Component)warning);
        FlowLayout buttons = (FlowLayout)Containers.horizontalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).gap(10).horizontalAlignment(HorizontalAlignment.CENTER);
        ButtonComponent cancelButton = (ButtonComponent)Components.button((class_2561)class_2561.method_43470((String)"Cancel"), button -> this.confirmOverlay.removeChild((Component)this.confirmOverlay.children().getLast())).renderer(ButtonComponent.Renderer.texture((class_2960)class_2960.method_60655((String)"packcore", (String)"textures/gui/wizard/button.png"), (int)0, (int)0, (int)100, (int)60)).horizontalSizing(Sizing.fixed((int)100)).verticalSizing(Sizing.fixed((int)20));
        ButtonComponent confirmButton = (ButtonComponent)Components.button((class_2561)class_2561.method_43470((String)"Reset & Exit"), button -> this.onResetPressed()).renderer(ButtonComponent.Renderer.texture((class_2960)class_2960.method_60655((String)"packcore", (String)"textures/gui/wizard/button.png"), (int)0, (int)0, (int)100, (int)60)).horizontalSizing(Sizing.fixed((int)100)).verticalSizing(Sizing.fixed((int)20));
        buttons.child((Component)cancelButton);
        buttons.child((Component)confirmButton);
        dialog.child((Component)buttons);
        return dialog;
    }

    private StatusInfo getStatusInfo() {
        if (PackCoreConfig.defaultConfigSuccessfullyApplied) {
            this.wizardFailed = false;
            return new StatusInfo("\u2713", "Configuration Successful", "PackCore has automatically applied the config below based on your screen resolution. If it's incorrect, continue the welcome wizard and open the Configuration Manager in the main menu to change it.", "Applied configuration: " + ConfigFileUtils.getCurrentConfig().getDisplayName(), -1070772202, -11353062, false);
        }
        this.wizardFailed = true;
        return new StatusInfo("\u26a0", "Setup Incomplete", "Automatic config application failed. Close the game with the button below and restart to try again, or continue the welcome wizard and apply the config manually from the Configuration Manager in the main menu.", "Click 'Reset Setup' to close the game and try the automatic configuration again.", -1067699433, -348908, true);
    }

    private FlowLayout createContentContainer() {
        return (FlowLayout)Containers.verticalFlow((Sizing)Sizing.fill((int)this.getContentColumnWidthPercent()), (Sizing)Sizing.expand()).gap(12).surface(UiSurfaces.stretched(class_2960.method_60655((String)"packcore", (String)"textures/gui/wizard/info_box.png"), 1142, 934)).padding(Insets.of((int)(CONTENT_PADDING + 10), (int)(CONTENT_PADDING + 10), (int)(CONTENT_PADDING + 4), (int)(CONTENT_PADDING + 4))).horizontalAlignment(HorizontalAlignment.CENTER).margins(Insets.of((int)0, (int)28, (int)0, (int)0));
    }

    private FlowLayout createContentContainerRight() {
        return (FlowLayout)Containers.verticalFlow((Sizing)Sizing.fill((int)this.getContentColumnWidthRightPercent()), (Sizing)Sizing.fill((int)100)).gap(12).surface(UiSurfaces.stretched(class_2960.method_60655((String)"packcore", (String)"textures/gui/wizard/box.png"), 607, 755)).padding(Insets.of((int)(CONTENT_PADDING + 10), (int)(CONTENT_PADDING + 10), (int)(CONTENT_PADDING + 4), (int)(CONTENT_PADDING + 4))).horizontalAlignment(HorizontalAlignment.CENTER).positioning(Positioning.relative((int)100, (int)0)).margins(Insets.of((int)0, (int)28, (int)0, (int)0));
    }

    private FlowLayout createFooter() {
        FlowLayout footer = (FlowLayout)Containers.horizontalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).padding(Insets.of((int)(CONTENT_PADDING - 8), (int)(CONTENT_PADDING - 8), (int)CONTENT_PADDING, (int)CONTENT_PADDING)).verticalAlignment(VerticalAlignment.CENTER).positioning(Positioning.relative((int)0, (int)100));
        FlowLayout buttonContainer = (FlowLayout)Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).gap(12).positioning(Positioning.relative((int)100, (int)50));
        if (this.hasPreviousPage()) {
            ButtonComponent backButton = (ButtonComponent)Components.button((class_2561)class_2561.method_43470((String)"Back"), button -> this.onBackPressed()).renderer(ButtonComponent.Renderer.texture((class_2960)class_2960.method_60655((String)"packcore", (String)"textures/gui/wizard/previous.png"), (int)0, (int)0, (int)100, (int)60)).horizontalSizing(Sizing.fixed((int)100)).verticalSizing(Sizing.fixed((int)20));
            buttonContainer.child((Component)backButton);
        }
        if (this.isSkippable()) {
            ButtonComponent skipButton = (ButtonComponent)Components.button((class_2561)class_2561.method_43470((String)"Skip"), button -> this.onSkipPressed()).renderer(ButtonComponent.Renderer.texture((class_2960)class_2960.method_60655((String)"packcore", (String)"textures/gui/wizard/continue.png"), (int)0, (int)0, (int)100, (int)60)).horizontalSizing(Sizing.fixed((int)100)).verticalSizing(Sizing.fixed((int)20));
            buttonContainer.child((Component)skipButton);
        }
        ButtonComponent primaryButton = this.createPrimaryButton();
        buttonContainer.child((Component)primaryButton);
        FlowLayout linkButtonContainer = (FlowLayout)Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).gap(8).margins(Insets.of((int)0, (int)0, (int)4, (int)0));
        ButtonComponent discord = (ButtonComponent)Components.button((class_2561)class_2561.method_43473(), button -> class_156.method_668().method_670(info.getDiscord())).renderer(ButtonComponent.Renderer.texture((class_2960)class_2960.method_60655((String)"packcore", (String)"textures/gui/menu/discord_icon.png"), (int)0, (int)0, (int)22, (int)22)).horizontalSizing(Sizing.fixed((int)22)).verticalSizing(Sizing.fixed((int)22));
        ButtonComponent modrinth = (ButtonComponent)Components.button((class_2561)class_2561.method_43473(), button -> class_156.method_668().method_670(info.getWebsite())).renderer(ButtonComponent.Renderer.texture((class_2960)class_2960.method_60655((String)"packcore", (String)"textures/gui/menu/modrinth_icon.png"), (int)0, (int)0, (int)22, (int)22)).horizontalSizing(Sizing.fixed((int)22)).verticalSizing(Sizing.fixed((int)22));
        ButtonComponent github = (ButtonComponent)Components.button((class_2561)class_2561.method_43473(), button -> class_156.method_668().method_670(info.getIssueTracker())).renderer(ButtonComponent.Renderer.texture((class_2960)class_2960.method_60655((String)"packcore", (String)"textures/gui/menu/github_icon.png"), (int)0, (int)0, (int)22, (int)22)).horizontalSizing(Sizing.fixed((int)22)).verticalSizing(Sizing.fixed((int)22));
        linkButtonContainer.child((Component)discord);
        linkButtonContainer.child((Component)modrinth);
        linkButtonContainer.child((Component)github);
        footer.child((Component)linkButtonContainer);
        footer.child((Component)buttonContainer);
        return footer;
    }

    protected void updatePrimaryButtonState(boolean enabled) {
        if (this.primaryButton != null) {
            this.primaryButton.field_22763 = enabled;
        } else {
            this.primaryButtonInitialActive = enabled;
        }
    }

    private ButtonComponent createPrimaryButton() {
        String buttonText = this.isLastPage() ? "Finish" : "Continue";
        this.primaryButton = (ButtonComponent)Components.button((class_2561)class_2561.method_43470((String)buttonText), button -> this.onContinuePressed()).renderer(ButtonComponent.Renderer.texture((class_2960)class_2960.method_60655((String)"packcore", (String)"textures/gui/wizard/continue.png"), (int)0, (int)0, (int)100, (int)60)).horizontalSizing(Sizing.fixed((int)100)).verticalSizing(Sizing.fixed((int)20));
        this.primaryButton.field_22763 = this.primaryButtonInitialActive;
        return this.primaryButton;
    }

    private static int getScaledPadding() {
        int screenWidth = class_310.method_1551().method_22683().method_4486();
        return screenWidth < 900 ? 8 : (screenWidth > 1400 ? 20 : 15);
    }

    protected abstract void buildContent(FlowLayout var1);

    protected abstract void buildContentRight(FlowLayout var1);

    protected abstract void onContinuePressed();

    protected void onBackPressed() {
        if (this.hasPreviousPage()) {
            class_310.method_1551().method_1507(WizardNavigator.createWizardPage(this.pageInfo.currentStep() - 1));
        }
    }

    protected void onSkipPressed() {
        this.onContinuePressed();
    }

    protected void onResetPressed() {
        PackCoreConfig.defaultConfigSuccessfullyApplied = false;
        PackCoreConfig.write((String)"packcore");
        class_310.method_1551().method_1592();
    }

    protected boolean hasPreviousPage() {
        return this.pageInfo.currentStep() >= 1;
    }

    protected boolean isLastPage() {
        return this.pageInfo.currentStep() >= this.pageInfo.totalSteps();
    }

    protected boolean isSkippable() {
        return false;
    }

    protected boolean shouldShowStatusInfo() {
        return true;
    }

    protected boolean shouldShowRightPanel() {
        return false;
    }

    protected int getContentColumnWidthPercent() {
        return 60;
    }

    protected int getContentColumnWidthRightPercent() {
        return 40;
    }

    public record WizardPageInfo(class_2561 title, int currentStep, int totalSteps) {
    }

    private record StatusInfo(String icon, String title, String message, String additionalInfo, int backgroundColor, int borderColor, boolean showResetButton) {
    }
}

