/*
 * Decompiled with CFR 0.152.
 */
package com.github.kd_gaming1.packcore.gui.help;

import com.github.kd_gaming1.packcore.PackCore;
import com.github.kd_gaming1.packcore.gui.help.WizardDataManager;
import com.github.kd_gaming1.packcore.util.config.PerformanceProfileUtil;
import com.github.kd_gaming1.packcore.util.config.ResourcePackUtil;
import com.github.kd_gaming1.packcore.util.config.TabDesignUtil;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;

public class ConfigurationApplicationService {
    public static CompletableFuture<Boolean> applyAllConfigurations() {
        return ConfigurationApplicationService.applyAllConfigurationsWithProgress(null).thenApply(ConfigurationResult::overallSuccess);
    }

    public static CompletableFuture<ConfigurationResult> applyAllConfigurationsWithProgress(ProgressCallback progressCallback) {
        WizardDataManager dataManager = WizardDataManager.getInstance();
        return CompletableFuture.supplyAsync(() -> {
            LinkedHashMap<String, String> failedSteps = new LinkedHashMap<String, String>();
            LinkedHashMap<String, String> successfulSteps = new LinkedHashMap<String, String>();
            try {
                Set<String> additionalSettings;
                String tabDesign;
                block29: {
                    List<String> resourcePacks;
                    PackCore.LOGGER.info("Starting comprehensive configuration application");
                    String optimizationProfile = dataManager.getOptimizationProfile();
                    if (!optimizationProfile.isEmpty()) {
                        boolean performanceApplied;
                        if (progressCallback != null) {
                            progressCallback.updateProgress("performance", "running", null);
                        }
                        if (!(performanceApplied = ConfigurationApplicationService.applyPerformanceProfile(optimizationProfile))) {
                            String error = "Could not apply the '" + optimizationProfile + "' performance profile. The settings may be incompatible or already active.";
                            PackCore.LOGGER.warn(error);
                            failedSteps.put("Performance Settings", error);
                            if (progressCallback != null) {
                                progressCallback.updateProgress("performance", "error", "Setup failed");
                            }
                        } else {
                            String success = "Successfully configured performance to '" + optimizationProfile + "' profile";
                            PackCore.LOGGER.info(success);
                            successfulSteps.put("Performance Settings", success);
                            if (progressCallback != null) {
                                progressCallback.updateProgress("performance", "success", null);
                            }
                        }
                    }
                    if (!(resourcePacks = dataManager.getResourcePacksOrdered()).isEmpty()) {
                        Object error;
                        if (progressCallback != null) {
                            progressCallback.updateProgress("resourcepacks", "running", null);
                        }
                        try {
                            boolean resourcePacksApplied = (Boolean)((CompletableFuture)ResourcePackUtil.applyResourcePacksOrdered(resourcePacks).exceptionally(ex -> {
                                PackCore.LOGGER.error("Exception while applying resource packs", ex);
                                String userFriendlyError = "Failed to enable resource packs. They may be missing or corrupted.";
                                failedSteps.put("Resource Packs", userFriendlyError);
                                return false;
                            })).join();
                            if (!resourcePacksApplied) {
                                error = "Could not enable the selected resource packs: " + String.join((CharSequence)", ", resourcePacks) + ". They may already be active or unavailable.";
                                PackCore.LOGGER.warn((String)error);
                                failedSteps.put("Resource Packs", (String)error);
                                if (progressCallback != null) {
                                    progressCallback.updateProgress("resourcepacks", "error", "Activation failed");
                                }
                            } else {
                                String success = "Successfully enabled " + resourcePacks.size() + " resource pack(s)";
                                PackCore.LOGGER.info(success);
                                successfulSteps.put("Resource Packs", success);
                                if (progressCallback != null) {
                                    progressCallback.updateProgress("resourcepacks", "success", null);
                                }
                            }
                        }
                        catch (Exception e) {
                            error = "An error occurred while trying to enable resource packs. Check that they're properly installed.";
                            PackCore.LOGGER.error((String)error, (Throwable)e);
                            failedSteps.put("Resource Packs", (String)error);
                            if (progressCallback == null) break block29;
                            progressCallback.updateProgress("resourcepacks", "error", "Error occurred");
                        }
                    }
                }
                if (!(tabDesign = dataManager.getTabDesign()).isEmpty()) {
                    boolean tabDesignApplied;
                    if (progressCallback != null) {
                        progressCallback.updateProgress("tabdesign", "running", null);
                    }
                    if (!(tabDesignApplied = TabDesignUtil.applyTabDesignFromWizard())) {
                        String error = "Could not apply the '" + tabDesign + "' tab menu style. The theme may be unavailable.";
                        PackCore.LOGGER.warn(error);
                        failedSteps.put("Tab Menu Style", error);
                        if (progressCallback != null) {
                            progressCallback.updateProgress("tabdesign", "error", "Theme unavailable");
                        }
                    } else {
                        String success = "Successfully applied '" + tabDesign + "' tab menu style";
                        PackCore.LOGGER.info(success);
                        successfulSteps.put("Tab Menu Style", success);
                        if (progressCallback != null) {
                            progressCallback.updateProgress("tabdesign", "success", null);
                        }
                    }
                }
                if (!(additionalSettings = dataManager.getAdditionalSettings()).isEmpty()) {
                    boolean additionalSettingsApplied;
                    if (progressCallback != null) {
                        progressCallback.updateProgress("additional", "running", null);
                    }
                    if (!(additionalSettingsApplied = ConfigurationApplicationService.applyAdditionalSettings(additionalSettings))) {
                        String error = "Some extra settings could not be applied. They may conflict with existing settings.";
                        PackCore.LOGGER.warn(error);
                        failedSteps.put("Extra Settings", error);
                        if (progressCallback != null) {
                            progressCallback.updateProgress("additional", "error", "Some failed");
                        }
                    } else {
                        String success = "Successfully applied all extra settings";
                        PackCore.LOGGER.info(success);
                        successfulSteps.put("Extra Settings", success);
                        if (progressCallback != null) {
                            progressCallback.updateProgress("additional", "success", null);
                        }
                    }
                }
                boolean overallSuccess = failedSteps.isEmpty();
                PackCore.LOGGER.info("Configuration application completed with overall success: {}", (Object)overallSuccess);
                if (!overallSuccess) {
                    PackCore.LOGGER.warn("Failed steps: {}", failedSteps);
                }
                return new ConfigurationResult(overallSuccess, failedSteps, successfulSteps);
            }
            catch (Exception e) {
                PackCore.LOGGER.error("Fatal error during configuration application", (Throwable)e);
                failedSteps.put("Setup Error", "An unexpected problem occurred during setup. Please try again or skip this step.");
                return new ConfigurationResult(false, failedSteps, successfulSteps);
            }
        });
    }

    private static boolean applyPerformanceProfile(String optimizationProfile) {
        try {
            PerformanceProfileUtil.PerformanceProfile profile = ConfigurationApplicationService.mapToPerformanceProfile(optimizationProfile);
            if (profile != null) {
                PerformanceProfileUtil.ProfileResult result = PerformanceProfileUtil.applyPerformanceProfile(profile);
                return result.isFullySuccessful();
            }
            PackCore.LOGGER.warn("Unrecognized performance profile: {}", (Object)optimizationProfile);
            return false;
        }
        catch (Exception e) {
            PackCore.LOGGER.error("Failed to apply performance profile: {}", (Object)optimizationProfile, (Object)e);
            return false;
        }
    }

    private static boolean applyAdditionalSettings(Set<String> additionalSettings) {
        try {
            boolean allSuccessful = true;
            for (String setting : additionalSettings) {
                boolean applied = ConfigurationApplicationService.applySingleAdditionalSetting(setting);
                if (!applied) {
                    PackCore.LOGGER.warn("Could not apply extra setting: {}", (Object)setting);
                    allSuccessful = false;
                    continue;
                }
                PackCore.LOGGER.info("Successfully applied extra setting: {}", (Object)setting);
            }
            return allSuccessful;
        }
        catch (Exception e) {
            PackCore.LOGGER.error("Error while applying extra settings", (Throwable)e);
            return false;
        }
    }

    private static boolean applySingleAdditionalSetting(String setting) {
        PackCore.LOGGER.info("Applying additional setting: {}", (Object)setting);
        switch (setting.toLowerCase()) {
            case "enable_chat_timestamps": {
                return true;
            }
            case "auto_reconnect": {
                return true;
            }
            case "performance_mode": {
                return true;
            }
        }
        PackCore.LOGGER.warn("Unknown extra setting: {}", (Object)setting);
        return false;
    }

    private static PerformanceProfileUtil.PerformanceProfile mapToPerformanceProfile(String optimizationProfile) {
        return switch (optimizationProfile.toLowerCase()) {
            case "max fps" -> PerformanceProfileUtil.PerformanceProfile.PERFORMANCE;
            case "balanced" -> PerformanceProfileUtil.PerformanceProfile.BALANCED;
            case "quality" -> PerformanceProfileUtil.PerformanceProfile.QUALITY;
            case "shaders" -> PerformanceProfileUtil.PerformanceProfile.SHADERS;
            default -> null;
        };
    }

    public static interface ProgressCallback {
        public void updateProgress(String var1, String var2, String var3);
    }

    public record ConfigurationResult(boolean overallSuccess, Map<String, String> failedSteps, Map<String, String> successfulSteps) {
    }
}

