/*
 * Decompiled with CFR 0.152.
 */
package com.github.kd_gaming1.packcore.gui.help.introduction;

import com.github.kd_gaming1.packcore.PackCore;
import com.github.kd_gaming1.packcore.gui.help.BaseWizardPage;
import com.github.kd_gaming1.packcore.gui.help.WizardDataManager;
import com.github.kd_gaming1.packcore.gui.help.WizardNavigator;
import com.github.kd_gaming1.packcore.gui.help.introduction.IntroductionScreenPageOne;
import com.github.kd_gaming1.packcore.lavendermd.CustomLavenderCompiler;
import com.github.kd_gaming1.packcore.util.MarkdownFileUtil;
import com.github.kd_gaming1.packcore.util.modpack.ModpackInfo;
import io.wispforest.lavendermd.MarkdownFeature;
import io.wispforest.lavendermd.MarkdownProcessor;
import io.wispforest.lavendermd.feature.BasicFormattingFeature;
import io.wispforest.lavendermd.feature.BlockQuoteFeature;
import io.wispforest.lavendermd.feature.ColorFeature;
import io.wispforest.lavendermd.feature.ImageFeature;
import io.wispforest.lavendermd.feature.LinkFeature;
import io.wispforest.lavendermd.feature.ListFeature;
import io.wispforest.owo.ops.TextOps;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.container.ScrollContainer;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.ParentComponent;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

public class IntroductionScreenPageThree
extends BaseWizardPage {
    private static final MarkdownProcessor<ParentComponent> MARKDOWN_PROCESSOR = new MarkdownProcessor(CustomLavenderCompiler::new, new MarkdownFeature[]{new BasicFormattingFeature(), new ColorFeature(), new LinkFeature(), new ListFeature(), new BlockQuoteFeature(), new ImageFeature()});
    private static final Map<String, ParentComponent> COMPONENT_CACHE = new ConcurrentHashMap<String, ParentComponent>();
    private final String welcomeMarkdown;
    private final ModpackInfo modpackInfo;
    private final Set<String> selectedResourcePacks = new LinkedHashSet<String>();
    LabelComponent headerTitle;
    private FlowLayout rightPanel;
    private static final int SELECTED_OUTLINE_COLOR = -16711936;
    private static final int UNSELECTED_OUTLINE_COLOR = -10496;
    private final List<OptionProfile> allProfiles = List.of(new OptionProfile("HypixelPlus", "Pack: Hypixel Plus", "A clean, mostly vanilla pack designed for Hypixel modes like SkyBlock. It updates items and icons for better clarity without changing the overall Minecraft feel."), new OptionProfile("FurfSkyOverlay", "Pack: FurfSky Overlay", "A comprehensive resource pack for Hypixel SkyBlock, offering textures for nearly every item in the game. With full retextures for only items in a special style."), new OptionProfile("FurfSkyFull", "Pack: FurfSky Full", "A comprehensive resource pack for Hypixel SkyBlock, offering textures for nearly every item in the game. With full retextures for items and menus in a special style."), new OptionProfile("SkyBlockDarkUI", "Pack: SkyBlock Dark UI", " A sleek, dark-themed resource pack for Hypixel SkyBlock, enhancing all GUI elements, including mod interfaces, with a modern aesthetic. Inspired by PacksHQ Dark UI"), new OptionProfile("Defrosted", "Pack: Defrosted", "Icy-themed 16x pack for Minecraft 1.21.5. It offers a frosty blue aesthetic across items and menus, maintaining a minimalist look without altering gameplay clarity."), new OptionProfile("Looshy", "Pack: Looshy", "A smooth, vanilla\u2011like 16x resource pack with clean updates and subtle charm. It keeps Minecraft\u2019s original style while offering refined textures that feel fresh and polished."));

    public IntroductionScreenPageThree() {
        super(new BaseWizardPage.WizardPageInfo((class_2561)class_2561.method_43470((String)"Resource Packs"), 3, 5), class_2960.method_60655((String)"packcore", (String)"textures/gui/wizard/welcome_bg.png"));
        this.welcomeMarkdown = MarkdownFileUtil.readMarkdownFile("ResourcePacks.md");
        this.modpackInfo = PackCore.getModpackInfo();
        List<String> savedPacks = WizardDataManager.getInstance().getResourcePacksOrdered();
        this.selectedResourcePacks.addAll(savedPacks);
    }

    @Override
    protected void buildContent(FlowLayout contentContainer) {
        contentContainer.child((Component)this.createWelcomeHeader());
        contentContainer.child(this.createMarkdownSection());
    }

    @Override
    protected void buildContentRight(FlowLayout contentContainerRight) {
        this.rightPanel = contentContainerRight;
        this.rightPanel.child((Component)this.createHeader());
        this.rightPanel.child(this.createProfilesScrollContainer());
    }

    private FlowLayout createWelcomeHeader() {
        FlowLayout header = Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).gap(6);
        class_5250 welcomeText = TextOps.concat((class_2561)TextOps.withColor((String)"Choose your prefer resource packs when using ", (int)0xFFFFFF), (class_2561)class_2561.method_43470((String)this.modpackInfo.getName()).method_10862(class_2583.field_24360.method_36139(-10496).method_10982(Boolean.TRUE)));
        return IntroductionScreenPageOne.getFlowLayout(header, (class_2561)welcomeText, Color.ofRgb((int)0xB9BBBE));
    }

    private ScrollContainer<FlowLayout> createMarkdownSection() {
        FlowLayout markdownWrapper = Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).gap(4);
        Component markdownComponent = COMPONENT_CACHE.computeIfAbsent(this.welcomeMarkdown, arg_0 -> MARKDOWN_PROCESSOR.process(arg_0)).horizontalSizing(Sizing.fill((int)96));
        return IntroductionScreenPageThree.getFlowLayoutScrollContainer(markdownWrapper, markdownComponent);
    }

    @NotNull
    public static ScrollContainer<FlowLayout> getFlowLayoutScrollContainer(FlowLayout markdownWrapper, Component markdownComponent) {
        markdownWrapper.child(markdownComponent);
        ScrollContainer scrollContainer = Containers.verticalScroll((Sizing)Sizing.fill((int)100), (Sizing)Sizing.expand(), (Component)markdownWrapper);
        scrollContainer.scrollbar(ScrollContainer.Scrollbar.vanilla());
        scrollContainer.scrollbarThiccness(6);
        scrollContainer.surface(Surface.flat((int)0x40000000).and(Surface.outline((int)0x30FFFFFF)));
        scrollContainer.padding(Insets.of((int)8));
        return scrollContainer;
    }

    private FlowLayout createHeader() {
        FlowLayout header = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).gap(6).margins(Insets.top((int)4));
        if (this.selectedResourcePacks.isEmpty()) {
            this.headerTitle = (LabelComponent)Components.label((class_2561)TextOps.withColor((String)"Select the resource packs you want by click the boxes below", (int)-10496)).horizontalSizing(Sizing.fill((int)100));
        } else {
            String joined = String.join((CharSequence)", ", this.selectedResourcePacks);
            this.headerTitle = (LabelComponent)Components.label((class_2561)TextOps.withColor((String)("Your selected resource packs are: " + joined), (int)-10496)).horizontalSizing(Sizing.fill((int)100));
        }
        header.child((Component)this.headerTitle);
        return header;
    }

    private FlowLayout createProfileBox(OptionProfile profile) {
        boolean isSelected = this.selectedResourcePacks.contains(profile.key);
        FlowLayout box = Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content());
        box.surface(Surface.flat((int)553637632).and(Surface.outline((int)(isSelected ? -16711936 : -10496))));
        box.padding(Insets.of((int)2));
        LabelComponent infoTitle = (LabelComponent)Components.label((class_2561)TextOps.withColor((String)profile.title, (int)-10496).method_10862(class_2583.field_24360.method_10982(Boolean.TRUE))).margins(Insets.of((int)2, (int)2, (int)2, (int)2));
        LabelComponent infoText = (LabelComponent)Components.label((class_2561)TextOps.withColor((String)profile.description, (int)0xFFFFFF).method_10862(class_2583.field_24360.method_10978(Boolean.TRUE))).horizontalSizing(Sizing.fill((int)100)).margins(Insets.of((int)2, (int)2, (int)2, (int)2));
        box.child((Component)infoTitle).child((Component)infoText);
        box.mouseDown().subscribe((mouseX, mouseY, button) -> {
            this.toggleSelectedProfile(profile.key);
            return true;
        });
        return box;
    }

    private ScrollContainer<FlowLayout> createProfilesScrollContainer() {
        FlowLayout profilesLayout = Containers.verticalFlow((Sizing)Sizing.fill((int)96), (Sizing)Sizing.content()).gap(6);
        for (OptionProfile profile : this.allProfiles) {
            profilesLayout.child((Component)this.createProfileBox(profile));
        }
        ScrollContainer scrollContainer = Containers.verticalScroll((Sizing)Sizing.fill((int)100), (Sizing)Sizing.expand(), (Component)profilesLayout);
        scrollContainer.scrollbar(ScrollContainer.Scrollbar.vanilla());
        scrollContainer.scrollbarThiccness(6);
        scrollContainer.surface(Surface.flat((int)0x40000000).and(Surface.outline((int)0x30FFFFFF)));
        scrollContainer.padding(Insets.of((int)6));
        scrollContainer.margins(Insets.bottom((int)4));
        return scrollContainer;
    }

    private void toggleSelectedProfile(String profileKey) {
        if (this.selectedResourcePacks.contains(profileKey)) {
            this.selectedResourcePacks.remove(profileKey);
        } else {
            this.selectedResourcePacks.add(profileKey);
        }
        ArrayList<String> orderedList = new ArrayList<String>(this.selectedResourcePacks);
        WizardDataManager.getInstance().setResourcePacksOrdered(orderedList);
        if (this.headerTitle != null) {
            if (this.selectedResourcePacks.isEmpty()) {
                this.headerTitle.text((class_2561)TextOps.withColor((String)"Select the resource packs you want by click the boxes below", (int)-10496));
            } else {
                this.headerTitle.text((class_2561)TextOps.withColor((String)("Your selected resource packs are: " + String.join((CharSequence)", ", this.selectedResourcePacks)), (int)-10496));
            }
        }
        this.updateProfileBoxes();
    }

    private void updateProfileBoxes() {
        this.rightPanel.children().stream().filter(child -> child instanceof ScrollContainer).findFirst().ifPresent(scrollContainer -> {
            FlowLayout profilesLayout = (FlowLayout)((ScrollContainer)scrollContainer).child();
            for (int i = 0; i < profilesLayout.children().size() && i < this.allProfiles.size(); ++i) {
                Component child = (Component)profilesLayout.children().get(i);
                if (!(child instanceof FlowLayout)) continue;
                FlowLayout existingBox = (FlowLayout)child;
                OptionProfile profile = this.allProfiles.get(i);
                boolean isSelected = this.selectedResourcePacks.contains(profile.key);
                existingBox.surface(Surface.flat((int)553637632).and(Surface.outline((int)(isSelected ? -16711936 : -10496))));
            }
        });
    }

    @Override
    protected void onContinuePressed() {
        this.field_22787.method_1507(WizardNavigator.createWizardPage(4));
    }

    @Override
    protected int getContentColumnWidthPercent() {
        return 55;
    }

    @Override
    protected boolean shouldShowStatusInfo() {
        return false;
    }

    @Override
    protected boolean shouldShowRightPanel() {
        return true;
    }

    public record OptionProfile(String key, String title, String description) {
    }
}

