/*
 * Decompiled with CFR 0.152.
 */
package com.github.kd_gaming1.packcore.util;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Comparator;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigFileOperations {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigFileOperations.class);
    private static final DateTimeFormatter BACKUP_TIMESTAMP = DateTimeFormatter.ofPattern("yyyy-MM-dd_HH-mm-ss");

    public static Path createBackup(Path gameDir) {
        try {
            Path backupDir = gameDir.resolve("packcore/backups");
            Files.createDirectories(backupDir, new FileAttribute[0]);
            String timestamp = LocalDateTime.now().format(BACKUP_TIMESTAMP);
            Path backupPath = backupDir.resolve("config_backup_" + timestamp);
            Files.createDirectories(backupPath, new FileAttribute[0]);
            LOGGER.info("Creating backup at: {}", (Object)backupPath);
            ConfigFileOperations.backupIfExists(gameDir.resolve("config"), backupPath.resolve("config"));
            ConfigFileOperations.backupIfExists(gameDir.resolve("options.txt"), backupPath.resolve("options.txt"));
            ConfigFileOperations.backupIfExists(gameDir.resolve("servers.dat"), backupPath.resolve("servers.dat"));
            Path currentMetadata = gameDir.resolve("packcore_metadata.json");
            if (Files.exists(currentMetadata, new LinkOption[0])) {
                Files.copy(currentMetadata, backupPath.resolve("packcore_metadata.json"), StandardCopyOption.REPLACE_EXISTING);
            }
            LOGGER.info("Backup created successfully at: {}", (Object)backupPath);
            return backupPath;
        }
        catch (IOException e) {
            LOGGER.error("Failed to create backup", (Throwable)e);
            return null;
        }
    }

    private static void backupIfExists(Path source, Path target) {
        try {
            if (Files.exists(source, new LinkOption[0])) {
                if (Files.isDirectory(source, new LinkOption[0])) {
                    ConfigFileOperations.copyDirectory(source, target);
                } else {
                    Files.createDirectories(target.getParent(), new FileAttribute[0]);
                    Files.copy(source, target, StandardCopyOption.REPLACE_EXISTING);
                }
                LOGGER.debug("Backed up: {}", (Object)source);
            }
        }
        catch (IOException e) {
            LOGGER.warn("Could not backup: {} - {}", (Object)source, (Object)e.getMessage());
        }
    }

    public static void copyDirectory(final Path source, final Path target) throws IOException {
        Files.walkFileTree(source, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            @NotNull
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                Path targetDir = target.resolve(source.relativize(dir));
                Files.createDirectories(targetDir, new FileAttribute[0]);
                return FileVisitResult.CONTINUE;
            }

            @Override
            @NotNull
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Path targetFile = target.resolve(source.relativize(file));
                Files.copy(file, targetFile, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
                return FileVisitResult.CONTINUE;
            }

            @Override
            @NotNull
            public FileVisitResult visitFileFailed(Path file, IOException exc) {
                LOGGER.warn("Failed to copy file: {} - {}", (Object)file, (Object)exc.getMessage());
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static void deleteDirectory(Path directory) {
        if (!Files.exists(directory, new LinkOption[0])) {
            return;
        }
        try (Stream<Path> paths = Files.walk(directory, new FileVisitOption[0]);){
            paths.sorted(Comparator.reverseOrder()).forEach(path -> {
                try {
                    Files.deleteIfExists(path);
                }
                catch (IOException e) {
                    LOGGER.debug("Could not delete: {}", path);
                }
            });
        }
        catch (IOException e) {
            LOGGER.warn("Could not fully delete directory: {}", (Object)directory);
        }
    }

    public static long calculateSize(Path path) {
        block9: {
            long l;
            block10: {
                if (Files.isRegularFile(path, new LinkOption[0])) {
                    return Files.size(path);
                }
                if (!Files.isDirectory(path, new LinkOption[0])) break block9;
                Stream<Path> paths = Files.walk(path, new FileVisitOption[0]);
                try {
                    l = paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).mapToLong(p -> {
                        try {
                            return Files.size(p);
                        }
                        catch (IOException e) {
                            return 0L;
                        }
                    }).sum();
                    if (paths == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (paths != null) {
                            try {
                                paths.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        LOGGER.debug("Could not calculate size for: {}", (Object)path);
                    }
                }
                paths.close();
            }
            return l;
        }
        return 0L;
    }

    public static void cleanOldBackups(Path gameDir, int keepCount) {
        Path backupDir = gameDir.resolve("packcore/backups");
        if (!Files.exists(backupDir, new LinkOption[0])) {
            return;
        }
        try (Stream<Path> backups = Files.list(backupDir);){
            backups.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).sorted(Comparator.comparing(path -> {
                try {
                    return Files.getLastModifiedTime((Path)path, new LinkOption[0]);
                }
                catch (IOException e) {
                    return FileTime.fromMillis(0L);
                }
            }).reversed()).skip(keepCount).forEach(backup -> {
                LOGGER.info("Removing old backup: {}", (Object)backup.getFileName());
                ConfigFileOperations.deleteDirectory(backup);
            });
        }
        catch (IOException e) {
            LOGGER.warn("Failed to clean old backups", (Throwable)e);
        }
    }
}

