/*
 * Decompiled with CFR 0.152.
 */
package com.github.kd_gaming1.packcore.util.api;

import com.github.kd_gaming1.packcore.PackCore;
import com.github.kd_gaming1.packcore.util.modpack.ModpackInfo;
import com.mojang.text2speech.Narrator;

public class UpdateCheckResult {
    private final boolean success;
    private final boolean updateAvailable;
    private final String versionNumber;
    private final String versionType;
    private final String changelog;
    private final String versionId;
    private final String errorMessage;

    public UpdateCheckResult(boolean updateAvailable, String versionNumber, String versionType, String changelog, String versionId) {
        this.success = true;
        this.updateAvailable = updateAvailable;
        this.versionNumber = versionNumber;
        this.versionType = versionType;
        this.changelog = changelog;
        this.versionId = versionId;
        this.errorMessage = null;
    }

    private UpdateCheckResult(String errorMessage) {
        this.success = false;
        this.updateAvailable = false;
        this.versionNumber = null;
        this.versionType = null;
        this.changelog = null;
        this.versionId = null;
        this.errorMessage = errorMessage;
    }

    public static UpdateCheckResult error(String errorMessage) {
        return new UpdateCheckResult(errorMessage);
    }

    public boolean isSuccess() {
        return this.success;
    }

    public boolean isUpdateAvailable() {
        return this.updateAvailable;
    }

    public String getVersionNumber() {
        return this.versionNumber;
    }

    public String getVersionType() {
        return this.versionType;
    }

    public String getChangelog() {
        return this.changelog;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getModrinthUrl() {
        ModpackInfo info = PackCore.getModpackInfo();
        if (info == null) {
            Narrator.LOGGER.error("Update system not initialized properly. Cannot create URL");
            return null;
        }
        if (info.isConfigurationValid()) {
            Narrator.LOGGER.warn("Configuration is invalid, cannot create URL for changelog: {}", (Object)info.getValidationError());
            return null;
        }
        return this.versionId != null ? "https://modrinth.com/project/" + info.getModrinthProjectId() + "/version/" + this.versionId : null;
    }
}

