/*
 * Decompiled with CFR 0.152.
 */
package com.github.kd_gaming1.packcore.util.config;

import com.github.kd_gaming1.packcore.PackCore;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.loader.api.FabricLoader;

public class BobbyConfigModifier {
    public static void enableDynamicMultiWorld() {
        if (!FabricLoader.getInstance().isModLoaded("bobby")) {
            PackCore.LOGGER.info("Bobby mod not found, skipping config modification");
            return;
        }
        try {
            Path configPath = FabricLoader.getInstance().getConfigDir().resolve("bobby.conf");
            if (!Files.exists(configPath, new LinkOption[0])) {
                PackCore.LOGGER.info("Bobby config not found yet, skipping modification (will use defaults)");
                return;
            }
            List<String> lines = Files.readAllLines(configPath);
            ArrayList<Object> newLines = new ArrayList<Object>();
            boolean modified = false;
            boolean foundDynamicMultiWorld = false;
            for (String line : lines) {
                String trimmed = line.trim();
                if (trimmed.startsWith("dynamic-multi-world=") || trimmed.startsWith("dynamic-multi-world ")) {
                    foundDynamicMultiWorld = true;
                    if (trimmed.contains("=true")) {
                        PackCore.LOGGER.info("Bobby's dynamicMultiWorld is already enabled");
                        return;
                    }
                    String indentation = line.substring(0, line.indexOf(trimmed));
                    newLines.add(indentation + "dynamic-multi-world=true");
                    modified = true;
                    continue;
                }
                newLines.add(line);
            }
            if (!foundDynamicMultiWorld) {
                PackCore.LOGGER.warn("Could not find dynamic-multi-world setting in Bobby config");
                return;
            }
            if (modified) {
                Files.write(configPath, newLines, new OpenOption[0]);
                PackCore.LOGGER.info("Successfully enabled Bobby's dynamicMultiWorld");
            }
        }
        catch (Exception e) {
            PackCore.LOGGER.error("Failed to modify Bobby config", (Throwable)e);
        }
    }
}

