/*
 * Decompiled with CFR 0.152.
 */
package com.github.kd_gaming1.packcore.util.config;

import com.github.kd_gaming1.packcore.PackCore;
import com.github.kd_gaming1.packcore.gui.help.WizardDataManager;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_310;
import net.minecraft.class_746;

public class TabDesignUtil {
    private static final AtomicBoolean skyhanniConfigApplied = new AtomicBoolean(false);
    private static volatile Boolean pendingSkyHanniState = null;

    public static boolean applyTabDesignFromWizard() {
        String tabDesign = WizardDataManager.getInstance().getTabDesign();
        if (tabDesign == null || tabDesign.isEmpty() || "None".equals(tabDesign)) {
            return false;
        }
        boolean skyblockerPresent = TabDesignUtil.isModLoaded("skyblocker");
        boolean skyhanniPresent = TabDesignUtil.isModLoaded("skyhanni");
        if ("skyblocker".equalsIgnoreCase(tabDesign) && skyblockerPresent) {
            boolean changed = TabDesignUtil.enableSkyblockerTabList(true);
            if (skyhanniPresent) {
                TabDesignUtil.enableSkyHanniTabList(false);
            }
            return changed;
        }
        if ("skyhanni".equalsIgnoreCase(tabDesign) && skyhanniPresent) {
            boolean changed = TabDesignUtil.enableSkyHanniTabList(true);
            if (skyblockerPresent) {
                TabDesignUtil.enableSkyblockerTabList(false);
            }
            return changed;
        }
        return false;
    }

    public static void resetSkyHanniState() {
        skyhanniConfigApplied.set(false);
        pendingSkyHanniState = null;
    }

    private static boolean isModLoaded(String modId) {
        return FabricLoader.getInstance().isModLoaded(modId);
    }

    private static boolean enableSkyblockerTabList(boolean enable) {
        try {
            Class<?> configManager = Class.forName("de.hysky.skyblocker.config.SkyblockerConfigManager");
            Method updateMethod = configManager.getDeclaredMethod("update", Consumer.class);
            Consumer<Object> consumer = config -> TabDesignUtil.updateSkyblockerConfig(config, enable);
            updateMethod.invoke(null, consumer);
            PackCore.LOGGER.info("Set Skyblocker TabHud enabled = {}", (Object)enable);
            return true;
        }
        catch (ClassNotFoundException e) {
            PackCore.LOGGER.info("Skyblocker not present");
            return false;
        }
        catch (Exception e) {
            PackCore.LOGGER.warn("Could not update Skyblocker config", (Throwable)e);
            return false;
        }
    }

    private static void updateSkyblockerConfig(Object config, boolean enable) {
        try {
            Object uiAndVisuals = config.getClass().getField("uiAndVisuals").get(config);
            Object tabHud = uiAndVisuals.getClass().getField("tabHud").get(uiAndVisuals);
            tabHud.getClass().getField("tabHudEnabled").setBoolean(tabHud, enable);
            tabHud.getClass().getField("showVanillaTabByDefault").setBoolean(tabHud, !enable);
        }
        catch (Exception e) {
            PackCore.LOGGER.warn("Failed to update Skyblocker TabHud config", (Throwable)e);
        }
    }

    private static boolean enableSkyHanniTabList(boolean enable) {
        try {
            class_310 client = class_310.method_1551();
            if (client.field_1724 != null) {
                TabDesignUtil.scheduleDelayedCommand(enable);
                skyhanniConfigApplied.set(true);
                return true;
            }
            pendingSkyHanniState = enable;
            PackCore.LOGGER.info("Queued SkyHanni command to run on world join");
            return true;
        }
        catch (Exception e) {
            PackCore.LOGGER.warn("Could not queue SkyHanni config command", (Throwable)e);
            return false;
        }
    }

    private static void scheduleDelayedCommand(boolean enable) {
        class_310 client = class_310.method_1551();
        new Thread(() -> {
            try {
                Thread.sleep(2000L);
                client.execute(() -> {
                    try {
                        TabDesignUtil.executeSkyHanniCommand(enable);
                        PackCore.LOGGER.info("Executed SkyHanni command after delay");
                    }
                    catch (Exception e) {
                        PackCore.LOGGER.warn("Failed to execute SkyHanni command", (Throwable)e);
                        skyhanniConfigApplied.set(false);
                    }
                });
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                skyhanniConfigApplied.set(false);
            }
        }, "SkyHanni-Config-Delay").start();
    }

    private static void executeSkyHanniCommand(boolean enable) {
        String command = "shconfig set config.gui.compactTabList.enabled " + enable;
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        player.field_3944.method_45730(command);
        PackCore.LOGGER.info("Executed SkyHanni command: /{}", (Object)command);
    }

    public static TabDesignAvailability getAvailability() {
        return new TabDesignAvailability(TabDesignUtil.isModLoaded("skyhanni"), TabDesignUtil.isModLoaded("skyblocker"));
    }

    public static boolean applyTabDesign(String design) {
        if (design == null || design.isEmpty()) {
            return false;
        }
        boolean skyblockerPresent = TabDesignUtil.isModLoaded("skyblocker");
        boolean skyhanniPresent = TabDesignUtil.isModLoaded("skyhanni");
        if ("skyblocker".equalsIgnoreCase(design) && skyblockerPresent) {
            boolean changed = TabDesignUtil.enableSkyblockerTabList(true);
            if (skyhanniPresent) {
                TabDesignUtil.enableSkyHanniTabList(false);
            }
            return changed;
        }
        if ("skyhanni".equalsIgnoreCase(design) && skyhanniPresent) {
            boolean changed = TabDesignUtil.enableSkyHanniTabList(true);
            if (skyblockerPresent) {
                TabDesignUtil.enableSkyblockerTabList(false);
            }
            return changed;
        }
        return false;
    }

    static {
        ClientPlayConnectionEvents.JOIN.register((handler, sender, clientPlayNetworkHandler) -> {
            if (pendingSkyHanniState != null && skyhanniConfigApplied.compareAndSet(false, true)) {
                boolean enable = pendingSkyHanniState;
                TabDesignUtil.scheduleDelayedCommand(enable);
            }
        });
    }

    public static class TabDesignAvailability {
        private final boolean skyhanniAvailable;
        private final boolean skyblockerAvailable;

        public TabDesignAvailability(boolean skyhanniAvailable, boolean skyblockerAvailable) {
            this.skyhanniAvailable = skyhanniAvailable;
            this.skyblockerAvailable = skyblockerAvailable;
        }

        public boolean isSkyHanniAvailable() {
            return this.skyhanniAvailable;
        }

        public boolean isSkyblockerAvailable() {
            return this.skyblockerAvailable;
        }
    }
}

