/*
 * Decompiled with CFR 0.152.
 */
package com.github.kd_gaming1.packcore.prelaunch;

import com.github.kd_gaming1.packcore.config.PackCoreConfig;
import com.github.kd_gaming1.packcore.config.apply.ConfigApplyService;
import com.github.kd_gaming1.packcore.config.apply.ConfigAutoApplier;
import com.github.kd_gaming1.packcore.util.io.file.FileLayoutInitializer;
import eu.midnightdust.lib.config.MidnightConfig;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.entrypoint.PreLaunchEntrypoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreLaunchWizardInitializer
implements PreLaunchEntrypoint {
    private static final Logger LOGGER = LoggerFactory.getLogger(PreLaunchWizardInitializer.class);

    public void onPreLaunch() {
        LOGGER.info("PackCore pre-launch initializer started");
        MidnightConfig.init((String)"packcore", PackCoreConfig.class);
        Path runDir = FabricLoader.getInstance().getGameDir();
        FileLayoutInitializer.initializeFileStructure();
        boolean configApplied = ConfigApplyService.checkAndApplyPendingConfig(runDir);
        if (configApplied) {
            LOGGER.info("Applied pending config during pre-launch");
            PackCoreConfig.defaultConfigSuccessfullyApplied = true;
            PackCoreConfig.write((String)"packcore");
        }
        if (this.isUpgradeFromOldVersion(runDir)) {
            LOGGER.info("Upgrade from old version detected - marking as not first startup");
            PackCoreConfig.isFirstStartup = false;
            PackCoreConfig.write((String)"packcore");
        } else if (this.shouldApplyConfigAutomatically()) {
            LOGGER.info("First launch detected - applying config automatically...");
            boolean success = ConfigAutoApplier.applyBestMatchingConfig(runDir);
            if (success) {
                LOGGER.info("Config applied successfully on first launch");
                PackCoreConfig.defaultConfigSuccessfullyApplied = true;
                PackCoreConfig.isFirstStartup = false;
                PackCoreConfig.write((String)"packcore");
            } else {
                LOGGER.warn("Failed to apply config automatically - will use defaults");
            }
        }
        LOGGER.info("PackCore pre-launch initialization complete");
    }

    private boolean shouldApplyConfigAutomatically() {
        return PackCoreConfig.isFirstStartup && !PackCoreConfig.defaultConfigSuccessfullyApplied;
    }

    private boolean isUpgradeFromOldVersion(Path gameDir) {
        boolean exists;
        Path oldFolder = gameDir.resolve("SkyBlock Enhanced");
        boolean bl = exists = Files.exists(oldFolder, new LinkOption[0]) && Files.isDirectory(oldFolder, new LinkOption[0]);
        if (exists) {
            LOGGER.info("Detected 'SkyBlock Enhanced' folder - this is an upgrade from old version");
        }
        return exists;
    }
}

