/*
 * Decompiled with CFR 0.152.
 */
package com.github.kd_gaming1.packcore.scamshield;

import com.github.kd_gaming1.packcore.PackCore;
import com.github.kd_gaming1.packcore.config.PackCoreConfig;
import com.github.kd_gaming1.packcore.scamshield.ScamShieldScreenIntegration;
import com.github.kd_gaming1.packcore.scamshield.ScamShieldWhitelist;
import com.github.kd_gaming1.packcore.scamshield.ScamWarningMessageBuilder;
import com.github.kd_gaming1.packcore.scamshield.detector.ConfidenceLevel;
import com.github.kd_gaming1.packcore.scamshield.detector.DetectionResult;
import com.github.kd_gaming1.packcore.scamshield.detector.ScamDetector;
import com.github.kd_gaming1.packcore.scamshield.storage.DetectedScam;
import com.github.kd_gaming1.packcore.scamshield.storage.ScamShieldDataManager;
import com.github.kd_gaming1.packcore.ui.screen.scamshield.ScamWarningScreen;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;

public class ScamShieldChatHandler {
    private static final ScamShieldChatHandler INSTANCE = new ScamShieldChatHandler();
    private final ScamDetector detector = ScamDetector.getInstance();
    private final class_310 client = class_310.method_1551();
    private final ConcurrentLinkedQueue<DetectionResult> recentDetections = new ConcurrentLinkedQueue();
    private final ExecutorService detectionExecutor = new ThreadPoolExecutor(1, 2, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(50), r -> {
        Thread t = new Thread(r, "ScamShield-Detector");
        t.setDaemon(true);
        return t;
    }, new ThreadPoolExecutor.CallerRunsPolicy());
    private long lastLowConfidenceWarning = 0L;
    private long lastMediumConfidenceWarning = 0L;
    private long lastHighConfidenceWarning = 0L;

    private ScamShieldChatHandler() {
    }

    public static ScamShieldChatHandler getInstance() {
        return INSTANCE;
    }

    public void processChatMessage(String message, String sender) {
        if (!PackCoreConfig.enableScamShield || message == null || message.isEmpty()) {
            return;
        }
        if (this.client.field_1724 != null && sender.equals(this.client.field_1724.method_5477().getString())) {
            return;
        }
        if (ScamShieldWhitelist.getInstance().isWhitelisted(sender)) {
            if (PackCoreConfig.enableScamShieldDebugging) {
                PackCore.LOGGER.info("[ScamShield] Skipping whitelisted player: {}", (Object)sender);
            }
            return;
        }
        this.detectionExecutor.execute(() -> {
            try {
                DetectionResult result = this.detector.analyze(message, sender);
                if (result.isTriggered()) {
                    this.handleDetection(result);
                }
            }
            catch (Exception e) {
                PackCore.LOGGER.error("[ScamShield] Detection failed", (Throwable)e);
            }
        });
    }

    private void handleDetection(DetectionResult result) {
        long now = System.currentTimeMillis();
        ConfidenceLevel level = result.getConfidenceLevel();
        if (!this.shouldShowWarning(level, now)) {
            if (PackCoreConfig.enableScamShieldDebugging) {
                PackCore.LOGGER.info("[ScamShield] {} confidence cooldown active", (Object)level);
            }
            this.recentDetections.offer(result);
            return;
        }
        this.updateCooldown(level, now);
        this.recentDetections.offer(result);
        while (this.recentDetections.size() > PackCoreConfig.scamShieldMaxRecentDetections) {
            this.recentDetections.poll();
        }
        this.logDetection(result);
        DetectedScam detectedScam = DetectedScam.fromResult(result);
        ScamShieldDataManager.getInstance().saveDetectionAsync(detectedScam);
        if (PackCoreConfig.scamShieldShowNotifications) {
            this.client.execute(() -> this.showWarning(result));
        }
    }

    private boolean shouldShowWarning(ConfidenceLevel level, long now) {
        long cooldownMs;
        long lastWarning = switch (level) {
            case ConfidenceLevel.LOW -> {
                cooldownMs = 30000L;
                yield this.lastLowConfidenceWarning;
            }
            case ConfidenceLevel.MEDIUM -> {
                cooldownMs = 20000L;
                yield this.lastMediumConfidenceWarning;
            }
            case ConfidenceLevel.HIGH -> {
                cooldownMs = 10000L;
                yield this.lastHighConfidenceWarning;
            }
            default -> {
                cooldownMs = 30000L;
                yield this.lastLowConfidenceWarning;
            }
        };
        return now - lastWarning >= cooldownMs;
    }

    private void updateCooldown(ConfidenceLevel level, long timestamp) {
        switch (level) {
            case LOW: {
                this.lastLowConfidenceWarning = timestamp;
                break;
            }
            case MEDIUM: {
                this.lastMediumConfidenceWarning = timestamp;
                break;
            }
            case HIGH: {
                this.lastHighConfidenceWarning = timestamp;
            }
        }
    }

    private void logDetection(DetectionResult result) {
        ConfidenceLevel level = result.getConfidenceLevel();
        String logMessage = String.format("[ScamShield] %s confidence detection | Score: %d | Category: %s | Sender: %s", level.getDisplayName(), result.getTotalScore(), result.getPrimaryCategory().getDisplayName(), result.getSender());
        switch (level) {
            case LOW: {
                PackCore.LOGGER.info(logMessage);
                break;
            }
            case MEDIUM: {
                PackCore.LOGGER.warn(logMessage);
                break;
            }
            case HIGH: {
                PackCore.LOGGER.error(logMessage);
            }
        }
    }

    private void showWarning(DetectionResult result) {
        ConfidenceLevel level = result.getConfidenceLevel();
        this.sendChatWarning(result);
        if (level.shouldForceScreen()) {
            this.openWarningScreen(result);
        }
    }

    private void sendChatWarning(DetectionResult result) {
        if (this.client.field_1724 != null) {
            this.client.field_1724.method_7353(ScamWarningMessageBuilder.buildWarningMessage(result), false);
        }
    }

    private void openWarningScreen(DetectionResult result) {
        block3: {
            if (this.client.field_1755 != null) {
                PackCore.LOGGER.info("[ScamShield] User already in screen, skipping forced screen open");
                return;
            }
            try {
                ScamWarningScreen.ScamWarning warning = ScamShieldScreenIntegration.convertToWarning(result);
                ScamWarningScreen warningScreen = new ScamWarningScreen(warning, () -> {
                    if (PackCoreConfig.enableScamShieldDebugging) {
                        PackCore.LOGGER.info("[ScamShield] Warning screen dismissed for: {}", (Object)result.getSender());
                    }
                });
                this.client.method_1507((class_437)warningScreen);
                PackCore.LOGGER.warn("[ScamShield] Opened critical warning screen for: {}", (Object)result.getSender());
            }
            catch (Exception e) {
                PackCore.LOGGER.error("[ScamShield] Failed to open warning screen", (Throwable)e);
                if (this.client.field_1724 == null) break block3;
                this.client.field_1724.method_7353((class_2561)class_2561.method_43470((String)("\u00a7c\u00a7l[!] CRITICAL SCAM ALERT: Do NOT interact with " + result.getSender() + "! Type /scamshield education to learn more.\u00a7r")), false);
            }
        }
    }

    public DetectionResult[] getRecentDetections() {
        return this.recentDetections.toArray(new DetectionResult[0]);
    }

    public void clearHistory() {
        this.recentDetections.clear();
    }

    public void shutdown() {
        this.detectionExecutor.shutdown();
        try {
            if (!this.detectionExecutor.awaitTermination(5L, TimeUnit.SECONDS)) {
                this.detectionExecutor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.detectionExecutor.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    public ScamDetector getDetector() {
        return this.detector;
    }
}

